/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.extended;

import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.memory.AbstractWriteNode;
import jdk.graal.compiler.nodes.memory.MemoryAccess;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="JavaWrite#{p#location/s}")
public final class JavaWriteNode
extends AbstractWriteNode
implements Lowerable,
MemoryAccess {
    public static final NodeClass<JavaWriteNode> TYPE = NodeClass.create(JavaWriteNode.class);
    protected final JavaKind writeKind;
    protected final boolean compressible;
    protected final boolean hasSideEffect;
    protected final MemoryOrderMode memoryOrder;

    public JavaWriteNode(JavaKind writeKind, AddressNode address, LocationIdentity location, ValueNode value, BarrierType barrierType, boolean compressible) {
        this(writeKind, address, location, value, barrierType, compressible, true, MemoryOrderMode.PLAIN);
    }

    public JavaWriteNode(JavaKind writeKind, AddressNode address, LocationIdentity location, ValueNode value, BarrierType barrierType, boolean compressible, boolean hasSideEffect, MemoryOrderMode memoryOrder) {
        super(TYPE, address, location, value, barrierType);
        assert (!MemoryOrderMode.ordersMemoryAccesses(memoryOrder) || hasSideEffect);
        this.writeKind = writeKind;
        this.compressible = compressible;
        this.hasSideEffect = hasSideEffect;
        this.memoryOrder = memoryOrder;
    }

    @Override
    public boolean canNullCheck() {
        return true;
    }

    public JavaKind getWriteKind() {
        return this.writeKind;
    }

    public boolean isCompressible() {
        return this.compressible;
    }

    @Override
    public MemoryOrderMode getMemoryOrder() {
        return this.memoryOrder;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        if (this.ordersMemoryAccesses()) {
            return LocationIdentity.any();
        }
        return this.getLocationIdentity();
    }

    @Override
    public Stamp getAccessStamp(NodeView view) {
        return this.value().stamp(view);
    }

    @Override
    public boolean hasSideEffect() {
        return this.hasSideEffect;
    }
}

