/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.extended;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.LoadHubNode;
import jdk.graal.compiler.nodes.memory.MemoryAccess;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class LoadMethodNode
extends FixedWithNextNode
implements Lowerable,
Canonicalizable,
MemoryAccess {
    public static final NodeClass<LoadMethodNode> TYPE = NodeClass.create(LoadMethodNode.class);
    @Node.Input
    ValueNode hub;
    protected final ResolvedJavaMethod method;
    protected final ResolvedJavaType receiverType;
    protected final ResolvedJavaType callerType;

    public ValueNode getHub() {
        return this.hub;
    }

    public LoadMethodNode(@Node.InjectedNodeParameter Stamp stamp, ResolvedJavaMethod method, ResolvedJavaType receiverType, ResolvedJavaType callerType, ValueNode hub) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, stamp);
        this.receiverType = receiverType;
        this.callerType = callerType;
        this.hub = hub;
        this.method = method;
        assert (method.hasReceiver()) : "Cannot load a static method from a hub";
        if (!method.isInVirtualMethodTable(receiverType)) {
            throw new GraalError("%s does not have a vtable entry in type %s", method, receiverType);
        }
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ValueNode object;
        TypeReference type;
        if (this.hub instanceof LoadHubNode && (type = StampTool.typeReferenceOrNull(object = ((LoadHubNode)this.hub).getValue())) != null) {
            if (type.isExact()) {
                return this.resolveExactMethod(tool, type.getType());
            }
            Assumptions assumptions = this.graph().getAssumptions();
            Assumptions.AssumptionResult resolvedMethod = type.getType().findUniqueConcreteMethod(this.method);
            if (resolvedMethod != null && resolvedMethod.canRecordTo(assumptions) && !type.getType().isInterface() && this.method.getDeclaringClass().isAssignableFrom(type.getType())) {
                NodeView view = NodeView.from(tool);
                resolvedMethod.recordTo(assumptions);
                return ConstantNode.forConstant(this.stamp(view), ((ResolvedJavaMethod)resolvedMethod.getResult()).getEncoding(), tool.getMetaAccess());
            }
        }
        if (this.hub.isConstant()) {
            return this.resolveExactMethod(tool, tool.getConstantReflection().asJavaType(this.hub.asConstant()));
        }
        return this;
    }

    private Node resolveExactMethod(CanonicalizerTool tool, ResolvedJavaType type) {
        ResolvedJavaMethod newMethod = type.resolveConcreteMethod(this.method, this.callerType);
        if (newMethod == null) {
            return ConstantNode.forConstant(this.stamp(NodeView.DEFAULT), (Constant)JavaConstant.NULL_POINTER, null);
        }
        return ConstantNode.forConstant(this.stamp(NodeView.DEFAULT), newMethod.getEncoding(), tool.getMetaAccess());
    }

    public ResolvedJavaMethod getMethod() {
        return this.method;
    }

    public ResolvedJavaType getReceiverType() {
        return this.receiverType;
    }

    public ResolvedJavaType getCallerType() {
        return this.callerType;
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return LocationIdentity.ANY_LOCATION;
    }
}

