/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.extended;

import java.util.Arrays;
import java.util.Iterator;
import jdk.graal.compiler.core.common.type.AbstractPointerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeSuccessorList;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.SwitchCaseProbabilityNode;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.vm.ci.meta.Constant;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="We cannot estimate the runtime cost of a switch statement without knowing the numberof case statements and the involved keys.", size=NodeSize.SIZE_UNKNOWN, sizeRationale="We cannot estimate the code size of a switch statement without knowing the numberof case statements.")
public abstract class SwitchNode
extends ControlSplitNode {
    public static final NodeClass<SwitchNode> TYPE = NodeClass.create(SwitchNode.class);
    @Node.Successor
    protected NodeSuccessorList<AbstractBeginNode> successors;
    @Node.Input
    protected ValueNode value;
    protected final int[] keySuccessors;
    protected ProfileData.SwitchProbabilityData profileData;

    protected SwitchNode(NodeClass<? extends SwitchNode> c, ValueNode value, AbstractBeginNode[] successors, int[] keySuccessors, ProfileData.SwitchProbabilityData profileData) {
        super((NodeClass<? extends ControlSplitNode>)c, StampFactory.forVoid());
        assert (value.stamp(NodeView.DEFAULT).getStackKind().isNumericInteger() || value.stamp(NodeView.DEFAULT) instanceof AbstractPointerStamp) : String.valueOf(value.stamp(NodeView.DEFAULT)) + " key not supported by SwitchNode";
        assert (keySuccessors.length == profileData.getKeyProbabilities().length) : Assertions.errorMessageContext("keySucc", keySuccessors, "profiles", profileData.getKeyProbabilities());
        this.successors = new NodeSuccessorList((Node)this, (Node[])successors);
        this.value = value;
        this.keySuccessors = keySuccessors;
        this.profileData = profileData;
        assert (this.assertProbabilities());
    }

    protected double[] getKeyProbabilities() {
        return this.profileData.getKeyProbabilities();
    }

    private boolean assertProbabilities() {
        double total = 0.0;
        for (double d : this.getKeyProbabilities()) {
            total += d;
            GraalError.guarantee(d >= 0.0, "Cannot have negative probabilities in switch node: %s", (Object)d);
        }
        GraalError.guarantee(ProfileData.isApproximatelyEqual(total, 1.0), "Total probability across branches not equal to one: %.10f", (Object)total);
        return true;
    }

    @Override
    public int getSuccessorCount() {
        return this.successors.count();
    }

    @Override
    public double probability(AbstractBeginNode successor) {
        double sum = 0.0;
        for (int i = 0; i < this.keySuccessors.length; ++i) {
            if (this.successors.get(this.keySuccessors[i]) != successor) continue;
            sum += this.getKeyProbabilities()[i];
        }
        return sum;
    }

    @Override
    public boolean setProbability(AbstractBeginNode successor, ProfileData.BranchProbabilityData successorProfileData) {
        double newProbability = successorProfileData.getDesignatedSuccessorProbability();
        assert (newProbability <= 1.0 && newProbability >= 0.0) : newProbability;
        double[] keyProbabilities = (double[])this.getKeyProbabilities().clone();
        double sum = 0.0;
        double otherSum = 0.0;
        for (int i = 0; i < this.keySuccessors.length; ++i) {
            if (this.successors.get(this.keySuccessors[i]) == successor) {
                sum += keyProbabilities[i];
                continue;
            }
            otherSum += keyProbabilities[i];
        }
        if (otherSum == 0.0 || sum == 0.0) {
            return false;
        }
        double delta = newProbability - sum;
        for (int i = 0; i < this.keySuccessors.length; ++i) {
            keyProbabilities[i] = this.successors.get(this.keySuccessors[i]) == successor ? Math.max(0.0, keyProbabilities[i] + delta * keyProbabilities[i] / sum) : Math.max(0.0, keyProbabilities[i] - delta * keyProbabilities[i] / otherSum);
        }
        this.profileData = ProfileData.SwitchProbabilityData.create(keyProbabilities, this.profileData.getProfileSource().combine(successorProfileData.getProfileSource()));
        assert (this.assertProbabilities());
        return true;
    }

    public void setProfileData(ProfileData.SwitchProbabilityData profileData) {
        this.profileData = profileData;
        assert (this.assertProbabilities());
    }

    @Override
    public ProfileData.SwitchProbabilityData getProfileData() {
        return this.profileData;
    }

    public ValueNode value() {
        return this.value;
    }

    public abstract boolean isSorted();

    public abstract int keyCount();

    public abstract Constant keyAt(int var1);

    public boolean structureEquals(SwitchNode switchNode) {
        return Arrays.equals(this.keySuccessors, switchNode.keySuccessors) && this.equalKeys(switchNode);
    }

    public abstract boolean equalKeys(SwitchNode var1);

    public int keySuccessorIndex(int i) {
        return this.keySuccessors[i];
    }

    public AbstractBeginNode keySuccessor(int i) {
        return (AbstractBeginNode)this.successors.get(this.keySuccessors[i]);
    }

    public double keyProbability(int i) {
        return this.getKeyProbabilities()[i];
    }

    public double defaultProbability() {
        return this.getKeyProbabilities()[this.getKeyProbabilities().length - 1];
    }

    public int defaultSuccessorIndex() {
        return this.keySuccessors[this.keySuccessors.length - 1];
    }

    public AbstractBeginNode blockSuccessor(int i) {
        return (AbstractBeginNode)this.successors.get(i);
    }

    public void setBlockSuccessor(int i, AbstractBeginNode s) {
        this.successors.set(i, (Object)s);
    }

    public int blockSuccessorCount() {
        return this.successors.count();
    }

    public AbstractBeginNode defaultSuccessor() {
        if (this.defaultSuccessorIndex() == -1) {
            throw new GraalError("unexpected");
        }
        return (AbstractBeginNode)this.successors.get(this.defaultSuccessorIndex());
    }

    @Override
    public AbstractBeginNode getPrimarySuccessor() {
        return null;
    }

    protected boolean shouldInjectBranchProbabilities() {
        for (AbstractBeginNode succ : this.successors) {
            if (!(succ.next() instanceof SwitchCaseProbabilityNode)) continue;
            return true;
        }
        return false;
    }

    protected void injectBranchProbabilities() {
        int[] numKeysPerBlock = new int[this.blockSuccessorCount()];
        for (int i = 0; i < this.keySuccessors.length; ++i) {
            int n = this.keySuccessorIndex(i);
            numKeysPerBlock[n] = numKeysPerBlock[n] + 1;
        }
        double[] nodeProbabilities = new double[this.keySuccessors.length];
        for (int i = 0; i < this.keySuccessors.length; ++i) {
            FixedNode fixedNode;
            AbstractBeginNode succ = this.keySuccessor(i);
            while ((fixedNode = succ.next()) instanceof AbstractBeginNode) {
                AbstractBeginNode next;
                succ = next = (AbstractBeginNode)fixedNode;
            }
            this.assertTrue(succ.next() instanceof SwitchCaseProbabilityNode, "Cannot inject switch probability, since key successor %s is not a SwitchCaseProbabilityNode", this, succ.next());
            SwitchCaseProbabilityNode caseProbabilityNode = (SwitchCaseProbabilityNode)succ.next();
            ValueNode probabilityNode = caseProbabilityNode.getProbability();
            if (!probabilityNode.isConstant()) {
                return;
            }
            double probabilityValue = probabilityNode.asJavaConstant().asDouble();
            if (probabilityValue < 0.0) {
                throw new GraalError("A negative probability of " + probabilityValue + " is not allowed!");
            }
            if (probabilityValue > 1.0) {
                throw new GraalError("A probability of more than 1.0 (" + probabilityValue + ") is not allowed!");
            }
            if (Double.isNaN(probabilityValue)) {
                return;
            }
            nodeProbabilities[i] = probabilityValue / (double)numKeysPerBlock[this.keySuccessorIndex(i)];
        }
        Iterator iterator = this.successors.iterator();
        while (iterator.hasNext()) {
            FixedNode fixedNode;
            AbstractBeginNode blockSuccessor;
            AbstractBeginNode succ = blockSuccessor = (AbstractBeginNode)iterator.next();
            while ((fixedNode = succ.next()) instanceof AbstractBeginNode) {
                AbstractBeginNode next;
                succ = next = (AbstractBeginNode)fixedNode;
            }
            SwitchCaseProbabilityNode caseProbabilityNode = (SwitchCaseProbabilityNode)succ.next();
            caseProbabilityNode.replaceAtUsages(null);
            this.graph().removeFixed(caseProbabilityNode);
        }
        this.setProfileData(ProfileData.SwitchProbabilityData.create(nodeProbabilities, ProfileData.ProfileSource.INJECTED));
    }

    protected void killOtherSuccessors(SimplifierTool tool, int survivingEdge) {
        for (Node successor : this.successors()) {
            if (successor == this.blockSuccessor(survivingEdge)) continue;
            tool.deleteBranch(successor);
        }
        tool.addToWorkList(this.blockSuccessor(survivingEdge));
        this.graph().removeSplit(this, this.blockSuccessor(survivingEdge));
    }

    public abstract Stamp getValueStampForSuccessor(AbstractBeginNode var1);

    @Override
    public NodeCycles estimatedNodeCycles() {
        if (this.keyCount() == 1) {
            return NodeCycles.CYCLES_2;
        }
        if (this.isSorted()) {
            return NodeCycles.CYCLES_8;
        }
        return NodeCycles.CYCLES_64;
    }

    @Override
    protected NodeSize dynamicNodeSizeEstimate() {
        if (this.keyCount() == 1) {
            return NodeSize.SIZE_2;
        }
        if (this.isSorted()) {
            return NodeSize.SIZE_8;
        }
        return NodeSize.SIZE_64;
    }

    public int[] getKeySuccessors() {
        return (int[])this.keySuccessors.clone();
    }
}

