/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.extended;

import java.nio.ByteOrder;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.memory.MemoryAccess;
import jdk.graal.compiler.nodes.memory.OrderedMemoryAccess;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public abstract class UnsafeAccessNode
extends FixedWithNextNode
implements Canonicalizable,
OrderedMemoryAccess,
MemoryAccess {
    public static final NodeClass<UnsafeAccessNode> TYPE = NodeClass.create(UnsafeAccessNode.class);
    @Node.Input
    ValueNode object;
    @Node.Input
    ValueNode offset;
    protected final JavaKind accessKind;
    protected final LocationIdentity locationIdentity;
    protected final boolean forceLocation;
    private final MemoryOrderMode memoryOrder;

    protected UnsafeAccessNode(NodeClass<? extends UnsafeAccessNode> c, Stamp stamp, ValueNode object, ValueNode offset, JavaKind accessKind, LocationIdentity locationIdentity, boolean forceLocation, MemoryOrderMode memoryOrder) {
        super((NodeClass<? extends FixedWithNextNode>)c, stamp);
        this.forceLocation = forceLocation;
        assert (accessKind != null);
        assert (locationIdentity != null);
        this.object = object;
        this.offset = offset;
        this.accessKind = accessKind;
        this.locationIdentity = locationIdentity;
        this.memoryOrder = memoryOrder;
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return this.locationIdentity;
    }

    public boolean isLocationForced() {
        return this.forceLocation;
    }

    public boolean isCanonicalizable() {
        return !this.isLocationForced();
    }

    public ValueNode object() {
        return this.object;
    }

    public ValueNode offset() {
        return this.offset;
    }

    public JavaKind accessKind() {
        return this.accessKind;
    }

    @Override
    public MemoryOrderMode getMemoryOrder() {
        return this.memoryOrder;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (this.isCanonicalizable()) {
            ResolvedJavaType receiverType;
            if (this.offset().isConstant()) {
                long constantOffset = this.offset().asJavaConstant().asLong();
                ResolvedJavaType receiverType2 = StampTool.typeOrNull(this.object());
                if (receiverType2 != null) {
                    ResolvedJavaField field = this.getStaticFieldUnsafeAccess(tool.getConstantReflection());
                    if (field == null) {
                        field = receiverType2.findInstanceFieldWithOffset(constantOffset, this.accessKind());
                    }
                    if (field != null && field.getJavaKind() == this.accessKind() && !field.isInternal()) {
                        return this.cloneAsFieldAccess(field);
                    }
                }
            }
            if (this.getLocationIdentity().isAny() && (receiverType = StampTool.typeOrNull(this.object())) != null && receiverType.isArray()) {
                LocationIdentity identity = NamedLocationIdentity.getArrayLocation(receiverType.getComponentType().getJavaKind());
                assert (this.graph().isBeforeStage(GraphState.StageFlag.FLOATING_READS)) : "cannot add more precise memory location after floating read phase";
                return this.cloneAsArrayAccess(this.offset(), identity, this.getMemoryOrder());
            }
        }
        return this;
    }

    public abstract ValueNode cloneAsFieldAccess(ResolvedJavaField var1);

    protected abstract ValueNode cloneAsArrayAccess(ValueNode var1, LocationIdentity var2, MemoryOrderMode var3);

    private ResolvedJavaField getStaticFieldUnsafeAccess(ConstantReflectionProvider constantReflection) {
        if (!this.object().isJavaConstant() || !this.offset().isJavaConstant() || this.object().isNullConstant() || this.offset().isNullConstant()) {
            return null;
        }
        JavaConstant objectConstant = this.object().asJavaConstant();
        JavaConstant offsetConstant = this.offset().asJavaConstant();
        assert (objectConstant != null && offsetConstant != null) : "Verified by the check at the beginning.";
        ResolvedJavaType staticReceiverType = constantReflection.asJavaType((Constant)objectConstant);
        if (staticReceiverType == null) {
            return null;
        }
        return UnsafeAccessNode.findStaticFieldWithOffset(staticReceiverType, offsetConstant.asLong(), this.accessKind);
    }

    public static ResolvedJavaField findStaticFieldWithOffset(ResolvedJavaType type, long offset, JavaKind expectedEntryKind) {
        try {
            ResolvedJavaField[] declaredFields = type.getStaticFields();
            return UnsafeAccessNode.findFieldWithOffset(offset, expectedEntryKind, declaredFields);
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    private static ResolvedJavaField findFieldWithOffset(long offset, JavaKind expectedEntryKind, ResolvedJavaField[] declaredFields) {
        for (ResolvedJavaField field : declaredFields) {
            long resolvedFieldOffset = field.getOffset();
            if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN && expectedEntryKind.isPrimitive() && !expectedEntryKind.equals((Object)JavaKind.Void) && field.getJavaKind().isPrimitive()) {
                resolvedFieldOffset += (long)(field.getJavaKind().getByteCount() - Math.min(field.getJavaKind().getByteCount(), 4 + expectedEntryKind.getByteCount()));
            }
            if (resolvedFieldOffset != offset) continue;
            return field;
        }
        return null;
    }
}

