/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.gc;

import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.type.AbstractObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.ArrayRangeWrite;
import jdk.graal.compiler.nodes.extended.RawStoreNode;
import jdk.graal.compiler.nodes.gc.BarrierSet;
import jdk.graal.compiler.nodes.gc.SerialArrayRangeWriteBarrier;
import jdk.graal.compiler.nodes.gc.SerialWriteBarrier;
import jdk.graal.compiler.nodes.gc.WriteBarrier;
import jdk.graal.compiler.nodes.java.AbstractCompareAndSwapNode;
import jdk.graal.compiler.nodes.java.LoweredAtomicReadAndWriteNode;
import jdk.graal.compiler.nodes.memory.FixedAccessNode;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.nodes.memory.WriteNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.word.LocationIdentity;

public class CardTableBarrierSet
implements BarrierSet {
    private final ResolvedJavaType objectArrayType;

    public CardTableBarrierSet(ResolvedJavaType objectArrayType) {
        this.objectArrayType = objectArrayType;
    }

    @Override
    public BarrierType readBarrierType(LocationIdentity location, ValueNode address, Stamp loadStamp) {
        return BarrierType.NONE;
    }

    @Override
    public BarrierType writeBarrierType(RawStoreNode store) {
        return store.needsBarrier() ? this.guessReadWriteBarrier(store.object(), store.value()) : BarrierType.NONE;
    }

    @Override
    public BarrierType fieldReadBarrierType(ResolvedJavaField field, JavaKind storageKind) {
        return BarrierType.NONE;
    }

    @Override
    public BarrierType fieldWriteBarrierType(ResolvedJavaField field, JavaKind storageKind) {
        return storageKind == JavaKind.Object ? BarrierType.FIELD : BarrierType.NONE;
    }

    @Override
    public BarrierType arrayWriteBarrierType(JavaKind storageKind) {
        return storageKind == JavaKind.Object ? BarrierType.ARRAY : BarrierType.NONE;
    }

    @Override
    public BarrierType guessReadWriteBarrier(ValueNode object, ValueNode value) {
        if (value.getStackKind() == JavaKind.Object && object.getStackKind() == JavaKind.Object) {
            ResolvedJavaType type = StampTool.typeOrNull(object);
            if (type != null && type.isArray()) {
                return BarrierType.ARRAY;
            }
            if (type == null || type.isAssignableFrom(this.objectArrayType)) {
                return BarrierType.UNKNOWN;
            }
            return BarrierType.FIELD;
        }
        return BarrierType.NONE;
    }

    @Override
    public boolean hasWriteBarrier() {
        return true;
    }

    @Override
    public boolean hasReadBarrier() {
        return false;
    }

    @Override
    public void addBarriers(FixedAccessNode n) {
        if (!(n instanceof ReadNode)) {
            if (n instanceof WriteNode) {
                WriteNode write = (WriteNode)n;
                this.addWriteBarrier(write, write.value());
            } else if (n instanceof LoweredAtomicReadAndWriteNode) {
                LoweredAtomicReadAndWriteNode atomic = (LoweredAtomicReadAndWriteNode)n;
                this.addWriteBarrier(atomic, atomic.getNewValue());
            } else if (n instanceof AbstractCompareAndSwapNode) {
                AbstractCompareAndSwapNode cmpSwap = (AbstractCompareAndSwapNode)n;
                this.addWriteBarrier(cmpSwap, cmpSwap.getNewValue());
            } else if (n instanceof ArrayRangeWrite) {
                this.addArrayRangeBarriers((ArrayRangeWrite)((Object)n));
            } else {
                GraalError.guarantee(n.getBarrierType() == BarrierType.NONE, "missed a node that requires a GC barrier: %s", n.getClass());
            }
        }
    }

    public boolean needsBarrier(FixedAccessNode n) {
        if (n instanceof ReadNode) {
            return false;
        }
        if (n instanceof WriteNode) {
            WriteNode write = (WriteNode)n;
            return this.needsWriteBarrier(write, write.value());
        }
        if (n instanceof LoweredAtomicReadAndWriteNode) {
            LoweredAtomicReadAndWriteNode atomic = (LoweredAtomicReadAndWriteNode)n;
            return this.needsWriteBarrier(atomic, atomic.getNewValue());
        }
        if (n instanceof AbstractCompareAndSwapNode) {
            AbstractCompareAndSwapNode cmpSwap = (AbstractCompareAndSwapNode)n;
            return this.needsWriteBarrier(cmpSwap, cmpSwap.getNewValue());
        }
        if (n instanceof ArrayRangeWrite) {
            return this.arrayRangeWriteRequiresBarrier((ArrayRangeWrite)((Object)n));
        }
        GraalError.guarantee(n.getBarrierType() == BarrierType.NONE, "missed a node that requires a GC barrier: %s", n.getClass());
        return false;
    }

    public boolean hasBarrier(FixedAccessNode n) {
        if (n instanceof ReadNode) {
            return false;
        }
        if (n instanceof WriteNode) {
            WriteNode write = (WriteNode)n;
            return CardTableBarrierSet.hasWriteBarrier(write);
        }
        if (n instanceof LoweredAtomicReadAndWriteNode) {
            LoweredAtomicReadAndWriteNode atomic = (LoweredAtomicReadAndWriteNode)n;
            return CardTableBarrierSet.hasWriteBarrier(atomic);
        }
        if (n instanceof AbstractCompareAndSwapNode) {
            AbstractCompareAndSwapNode cmpSwap = (AbstractCompareAndSwapNode)n;
            return CardTableBarrierSet.hasWriteBarrier(cmpSwap);
        }
        if (n instanceof ArrayRangeWrite) {
            return CardTableBarrierSet.hasWriteBarrier((ArrayRangeWrite)((Object)n));
        }
        GraalError.guarantee(n.getBarrierType() == BarrierType.NONE, "missed a node that requires a GC barrier: %s", n.getClass());
        return false;
    }

    public boolean isMatchingBarrier(FixedAccessNode n, WriteBarrier barrier) {
        if (n instanceof ReadNode) {
            return false;
        }
        if (n instanceof WriteNode || n instanceof LoweredAtomicReadAndWriteNode || n instanceof AbstractCompareAndSwapNode) {
            return barrier instanceof SerialWriteBarrier && CardTableBarrierSet.matches(n, (SerialWriteBarrier)barrier);
        }
        if (n instanceof ArrayRangeWrite) {
            return barrier instanceof SerialArrayRangeWriteBarrier && CardTableBarrierSet.matches((ArrayRangeWrite)((Object)n), (SerialArrayRangeWriteBarrier)barrier);
        }
        throw GraalError.shouldNotReachHere("Unexpected node: " + String.valueOf(n.getClass()));
    }

    public void addArrayRangeBarriers(ArrayRangeWrite write) {
        if (this.arrayRangeWriteRequiresBarrier(write)) {
            StructuredGraph graph = write.asNode().graph();
            SerialArrayRangeWriteBarrier serialArrayRangeWriteBarrier = graph.add(new SerialArrayRangeWriteBarrier(write.getAddress(), write.getLength(), write.getElementStride()));
            graph.addAfterFixed(write.postBarrierInsertionPosition(), serialArrayRangeWriteBarrier);
        }
    }

    private void addWriteBarrier(FixedAccessNode node, ValueNode writtenValue) {
        if (this.needsWriteBarrier(node, writtenValue)) {
            CardTableBarrierSet.addSerialPostWriteBarrier(node, node.getAddress(), node.graph());
        }
    }

    public boolean needsWriteBarrier(FixedAccessNode node, ValueNode writtenValue) {
        assert (!(node instanceof ArrayRangeWrite)) : Assertions.errorMessageContext("node", node, "val", writtenValue);
        BarrierType barrierType = node.getBarrierType();
        switch (barrierType) {
            case NONE: {
                return false;
            }
            case FIELD: 
            case ARRAY: 
            case UNKNOWN: {
                return this.writeRequiresBarrier(node, writtenValue);
            }
        }
        throw new GraalError("unexpected barrier type: " + String.valueOf((Object)barrierType));
    }

    protected boolean writeRequiresBarrier(FixedAccessNode node, ValueNode writtenValue) {
        return CardTableBarrierSet.isNonNullObjectValue(writtenValue);
    }

    protected boolean arrayRangeWriteRequiresBarrier(ArrayRangeWrite write) {
        return write.writesObjectArray();
    }

    private static boolean hasWriteBarrier(FixedAccessNode node) {
        return node.next() instanceof SerialWriteBarrier && CardTableBarrierSet.matches(node, (SerialWriteBarrier)node.next());
    }

    private static boolean hasWriteBarrier(ArrayRangeWrite write) {
        FixedWithNextNode node = write.asFixedWithNextNode();
        return node.next() instanceof SerialArrayRangeWriteBarrier && CardTableBarrierSet.matches(write, (SerialArrayRangeWriteBarrier)node.next());
    }

    private static void addSerialPostWriteBarrier(FixedAccessNode node, AddressNode address, StructuredGraph graph) {
        boolean precise = node.getBarrierType() != BarrierType.FIELD;
        graph.addAfterFixed(node, graph.add(new SerialWriteBarrier(address, precise)));
    }

    private static boolean isNonNullObjectValue(ValueNode value) {
        return value.stamp(NodeView.DEFAULT) instanceof AbstractObjectStamp && !StampTool.isPointerAlwaysNull(value);
    }

    private static boolean matches(FixedAccessNode node, SerialWriteBarrier barrier) {
        if (!barrier.usePrecise() && barrier.getAddress() instanceof OffsetAddressNode && node.getAddress() instanceof OffsetAddressNode) {
            return GraphUtil.unproxify(((OffsetAddressNode)barrier.getAddress()).getBase()) == GraphUtil.unproxify(((OffsetAddressNode)node.getAddress()).getBase());
        }
        return barrier.getAddress() == node.getAddress();
    }

    private static boolean matches(ArrayRangeWrite node, SerialArrayRangeWriteBarrier barrier) {
        return barrier.getAddress() == node.getAddress() && node.getLength() == barrier.getLength() && node.getElementStride() == barrier.getElementStride();
    }

    @Override
    public boolean mayNeedPreWriteBarrier(JavaKind storageKind) {
        return false;
    }
}

