/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.gc;

import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.DeoptimizingNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.gc.ObjectWriteBarrier;
import jdk.graal.compiler.nodes.gc.WriteBarrier;
import jdk.graal.compiler.nodes.memory.address.AddressNode;

@NodeInfo(cycles=NodeCycles.CYCLES_64, size=NodeSize.SIZE_64)
public final class G1PreWriteBarrier
extends ObjectWriteBarrier
implements DeoptimizingNode.DeoptBefore {
    public static final NodeClass<G1PreWriteBarrier> TYPE = NodeClass.create(G1PreWriteBarrier.class);
    @Node.OptionalInput(value=InputType.State)
    private FrameState stateBefore;
    private final boolean nullCheck;
    private final boolean doLoad;

    public G1PreWriteBarrier(AddressNode address, ValueNode expectedObject, boolean doLoad, boolean nullCheck) {
        super(TYPE, address, expectedObject, true);
        assert (doLoad == (expectedObject == null)) : Assertions.errorMessageContext("adr", address, "expectedO", expectedObject, "doLoad", doLoad, "nullCheck", nullCheck);
        this.doLoad = doLoad;
        this.nullCheck = nullCheck;
    }

    public ValueNode getExpectedObject() {
        return this.getValue();
    }

    public boolean doLoad() {
        return this.doLoad;
    }

    public boolean getNullCheck() {
        return this.nullCheck;
    }

    @Override
    public boolean canDeoptimize() {
        return this.nullCheck;
    }

    @Override
    public FrameState stateBefore() {
        return this.stateBefore;
    }

    @Override
    public void setStateBefore(FrameState state) {
        this.updateUsages(this.stateBefore, state);
        this.stateBefore = state;
    }

    @Override
    public WriteBarrier.Kind getKind() {
        return WriteBarrier.Kind.PRE_BARRIER;
    }
}

