/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.graphbuilderconf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.nodes.graphbuilderconf.ClassInitializationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderTool;
import jdk.graal.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.nodes.graphbuilderconf.NodePlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.ParameterPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.TypePlugin;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class GraphBuilderConfiguration {
    private final boolean eagerResolving;
    private final boolean unresolvedIsError;
    private final BytecodeExceptionMode bytecodeExceptionMode;
    private final boolean omitAssertions;
    private final List<ResolvedJavaType> skippedExceptionTypes;
    private final boolean insertFullInfopoints;
    private final boolean trackNodeSourcePosition;
    private final boolean retainLocalVariables;
    private final Plugins plugins;
    private final boolean replaceLocalsWithConstants;

    private GraphBuilderConfiguration(boolean eagerResolving, boolean unresolvedIsError, BytecodeExceptionMode bytecodeExceptionMode, boolean omitAssertions, boolean insertFullInfopoints, boolean trackNodeSourcePosition, boolean retainLocalVariables, boolean replaceLocalsWithConstants, List<ResolvedJavaType> skippedExceptionTypes, Plugins plugins) {
        this.eagerResolving = eagerResolving;
        this.unresolvedIsError = unresolvedIsError;
        this.bytecodeExceptionMode = bytecodeExceptionMode;
        this.omitAssertions = omitAssertions;
        this.insertFullInfopoints = insertFullInfopoints;
        this.trackNodeSourcePosition = trackNodeSourcePosition;
        this.retainLocalVariables = retainLocalVariables;
        this.replaceLocalsWithConstants = replaceLocalsWithConstants;
        this.skippedExceptionTypes = skippedExceptionTypes;
        this.plugins = plugins;
    }

    public GraphBuilderConfiguration copy() {
        Plugins newPlugins = new Plugins(this.plugins);
        GraphBuilderConfiguration result = new GraphBuilderConfiguration(this.eagerResolving, this.unresolvedIsError, this.bytecodeExceptionMode, this.omitAssertions, this.insertFullInfopoints, this.trackNodeSourcePosition, this.retainLocalVariables, this.replaceLocalsWithConstants, this.skippedExceptionTypes, newPlugins);
        return result;
    }

    public GraphBuilderConfiguration withUnresolvedIsError(boolean newUnresolvedIsError) {
        return new GraphBuilderConfiguration(this.eagerResolving, newUnresolvedIsError, this.bytecodeExceptionMode, this.omitAssertions, this.insertFullInfopoints, this.trackNodeSourcePosition, this.retainLocalVariables, this.replaceLocalsWithConstants, this.skippedExceptionTypes, this.plugins);
    }

    public GraphBuilderConfiguration withEagerResolving(boolean newEagerResolving) {
        return new GraphBuilderConfiguration(newEagerResolving, this.unresolvedIsError, this.bytecodeExceptionMode, this.omitAssertions, this.insertFullInfopoints, this.trackNodeSourcePosition, this.retainLocalVariables, this.replaceLocalsWithConstants, this.skippedExceptionTypes, this.plugins);
    }

    public GraphBuilderConfiguration withSkippedExceptionTypes(ResolvedJavaType[] newSkippedExceptionTypes) {
        return new GraphBuilderConfiguration(this.eagerResolving, this.unresolvedIsError, this.bytecodeExceptionMode, this.omitAssertions, this.insertFullInfopoints, this.trackNodeSourcePosition, this.retainLocalVariables, this.replaceLocalsWithConstants, Collections.unmodifiableList(Arrays.asList(newSkippedExceptionTypes)), this.plugins);
    }

    public GraphBuilderConfiguration withBytecodeExceptionMode(BytecodeExceptionMode newBytecodeExceptionMode) {
        return new GraphBuilderConfiguration(this.eagerResolving, this.unresolvedIsError, newBytecodeExceptionMode, this.omitAssertions, this.insertFullInfopoints, this.trackNodeSourcePosition, this.retainLocalVariables, this.replaceLocalsWithConstants, this.skippedExceptionTypes, this.plugins);
    }

    public GraphBuilderConfiguration withOmitAssertions(boolean newOmitAssertions) {
        return new GraphBuilderConfiguration(this.eagerResolving, this.unresolvedIsError, this.bytecodeExceptionMode, newOmitAssertions, this.insertFullInfopoints, this.trackNodeSourcePosition, this.retainLocalVariables, this.replaceLocalsWithConstants, this.skippedExceptionTypes, this.plugins);
    }

    public GraphBuilderConfiguration withFullInfopoints(boolean newInsertFullInfopoints) {
        return new GraphBuilderConfiguration(this.eagerResolving, this.unresolvedIsError, this.bytecodeExceptionMode, this.omitAssertions, newInsertFullInfopoints, this.trackNodeSourcePosition, this.retainLocalVariables, this.replaceLocalsWithConstants, this.skippedExceptionTypes, this.plugins);
    }

    public GraphBuilderConfiguration withNodeSourcePosition(boolean newTrackNodeSourcePosition) {
        return new GraphBuilderConfiguration(this.eagerResolving, this.unresolvedIsError, this.bytecodeExceptionMode, this.omitAssertions, this.insertFullInfopoints, newTrackNodeSourcePosition, this.retainLocalVariables, this.replaceLocalsWithConstants, this.skippedExceptionTypes, this.plugins);
    }

    public GraphBuilderConfiguration withRetainLocalVariables(boolean newRetainLocalVariables) {
        return new GraphBuilderConfiguration(this.eagerResolving, this.unresolvedIsError, this.bytecodeExceptionMode, this.omitAssertions, this.insertFullInfopoints, this.trackNodeSourcePosition, newRetainLocalVariables, this.replaceLocalsWithConstants, this.skippedExceptionTypes, this.plugins);
    }

    public List<ResolvedJavaType> getSkippedExceptionTypes() {
        return this.skippedExceptionTypes;
    }

    public boolean eagerResolving() {
        return this.eagerResolving;
    }

    public BytecodeExceptionMode getBytecodeExceptionMode() {
        return this.bytecodeExceptionMode;
    }

    public boolean omitAssertions() {
        return this.omitAssertions;
    }

    public boolean trackNodeSourcePosition() {
        return this.trackNodeSourcePosition;
    }

    public boolean retainLocalVariables() {
        return this.retainLocalVariables;
    }

    public boolean insertFullInfopoints() {
        return this.insertFullInfopoints;
    }

    public boolean replaceLocalsWithConstants() {
        return this.replaceLocalsWithConstants;
    }

    public static GraphBuilderConfiguration getDefault(Plugins plugins) {
        return new GraphBuilderConfiguration(false, false, BytecodeExceptionMode.Profile, false, false, false, false, false, Collections.emptyList(), plugins);
    }

    public static GraphBuilderConfiguration getSnippetDefault(Plugins plugins) {
        return new GraphBuilderConfiguration(true, true, BytecodeExceptionMode.OmitAll, false, false, false, false, false, Collections.emptyList(), plugins);
    }

    public boolean unresolvedIsError() {
        return this.unresolvedIsError;
    }

    public Plugins getPlugins() {
        return this.plugins;
    }

    public static enum BytecodeExceptionMode {
        CheckAll,
        OmitAll,
        ExplicitOnly,
        Profile;

    }

    public static class Plugins {
        private final InvocationPlugins invocationPlugins;
        private NodePlugin[] nodePlugins;
        private ParameterPlugin[] parameterPlugins;
        private TypePlugin[] typePlugins;
        private InlineInvokePlugin[] inlineInvokePlugins;
        private ClassInitializationPlugin classInitializationPlugin;

        public Plugins(Plugins copyFrom, InvocationPlugins invocationPlugins) {
            this.invocationPlugins = invocationPlugins != null ? invocationPlugins : new InvocationPlugins(null, copyFrom.invocationPlugins);
            this.nodePlugins = copyFrom.nodePlugins;
            this.parameterPlugins = copyFrom.parameterPlugins;
            this.typePlugins = copyFrom.typePlugins;
            this.inlineInvokePlugins = copyFrom.inlineInvokePlugins;
            this.classInitializationPlugin = copyFrom.classInitializationPlugin;
        }

        public Plugins(Plugins copyFrom) {
            this(copyFrom, null);
        }

        public Plugins(InvocationPlugins invocationPlugins) {
            this.invocationPlugins = invocationPlugins;
            this.nodePlugins = new NodePlugin[0];
            this.parameterPlugins = new ParameterPlugin[0];
            this.typePlugins = new TypePlugin[0];
            this.inlineInvokePlugins = new InlineInvokePlugin[0];
        }

        public InvocationPlugins getInvocationPlugins() {
            return this.invocationPlugins;
        }

        public NodePlugin[] getNodePlugins() {
            return this.nodePlugins;
        }

        public void appendNodePlugin(NodePlugin plugin) {
            this.nodePlugins = Arrays.copyOf(this.nodePlugins, this.nodePlugins.length + 1);
            this.nodePlugins[this.nodePlugins.length - 1] = plugin;
        }

        public void prependNodePlugin(NodePlugin plugin) {
            NodePlugin[] newPlugins = new NodePlugin[this.nodePlugins.length + 1];
            System.arraycopy(this.nodePlugins, 0, newPlugins, 1, this.nodePlugins.length);
            newPlugins[0] = plugin;
            this.nodePlugins = newPlugins;
        }

        public ParameterPlugin[] getParameterPlugins() {
            return this.parameterPlugins;
        }

        public void appendParameterPlugin(ParameterPlugin plugin) {
            this.parameterPlugins = Arrays.copyOf(this.parameterPlugins, this.parameterPlugins.length + 1);
            this.parameterPlugins[this.parameterPlugins.length - 1] = plugin;
        }

        public void prependParameterPlugin(ParameterPlugin plugin) {
            ParameterPlugin[] newPlugins = new ParameterPlugin[this.parameterPlugins.length + 1];
            System.arraycopy(this.parameterPlugins, 0, newPlugins, 1, this.parameterPlugins.length);
            newPlugins[0] = plugin;
            this.parameterPlugins = newPlugins;
        }

        public TypePlugin[] getTypePlugins() {
            return this.typePlugins;
        }

        public void appendTypePlugin(TypePlugin plugin) {
            this.typePlugins = Arrays.copyOf(this.typePlugins, this.typePlugins.length + 1);
            this.typePlugins[this.typePlugins.length - 1] = plugin;
        }

        public InlineInvokePlugin[] getInlineInvokePlugins() {
            return this.inlineInvokePlugins;
        }

        public void appendInlineInvokePlugin(InlineInvokePlugin plugin) {
            this.inlineInvokePlugins = Arrays.copyOf(this.inlineInvokePlugins, this.inlineInvokePlugins.length + 1);
            this.inlineInvokePlugins[this.inlineInvokePlugins.length - 1] = plugin;
        }

        public void prependInlineInvokePlugin(InlineInvokePlugin plugin) {
            InlineInvokePlugin[] newPlugins = new InlineInvokePlugin[this.inlineInvokePlugins.length + 1];
            System.arraycopy(this.inlineInvokePlugins, 0, newPlugins, 1, this.inlineInvokePlugins.length);
            newPlugins[0] = plugin;
            this.inlineInvokePlugins = newPlugins;
        }

        public void clearInlineInvokePlugins() {
            this.inlineInvokePlugins = new InlineInvokePlugin[0];
        }

        public ClassInitializationPlugin getClassInitializationPlugin() {
            return this.classInitializationPlugin;
        }

        public void setClassInitializationPlugin(ClassInitializationPlugin plugin) {
            this.classInitializationPlugin = plugin;
        }

        public StampPair getOverridingStamp(GraphBuilderTool b, JavaType type, boolean nonNull) {
            for (TypePlugin plugin : this.getTypePlugins()) {
                StampPair stamp = plugin.interceptType(b, type, nonNull);
                if (stamp == null) continue;
                return stamp;
            }
            return null;
        }
    }
}

