/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.graphbuilderconf;

import jdk.graal.compiler.bytecode.Bytecode;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.type.AbstractPointerStamp;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.DynamicPiNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedGuardNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.Invokable;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.PluginReplacementNode;
import jdk.graal.compiler.nodes.PluginReplacementWithExceptionNode;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.calc.IntegerLessThanNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.calc.NarrowNode;
import jdk.graal.compiler.nodes.calc.SignExtendNode;
import jdk.graal.compiler.nodes.calc.ZeroExtendNode;
import jdk.graal.compiler.nodes.extended.BytecodeExceptionNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GeneratedInvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderTool;
import jdk.graal.compiler.nodes.graphbuilderconf.IntrinsicContext;
import jdk.graal.compiler.nodes.java.InstanceOfDynamicNode;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public interface GraphBuilderContext
extends GraphBuilderTool {
    public void push(JavaKind var1, ValueNode var2);

    default public ValueNode pop(JavaKind slotKind) {
        throw GraalError.unimplementedParent();
    }

    default public ValueNode[] popArguments(int argSize) {
        throw GraalError.unimplementedParent();
    }

    default public <T extends Node> T add(T value) {
        if (value.graph() != null) {
            if (!1.$assertionsDisabled && value instanceof StateSplit && ((StateSplit)((Object)value)).stateAfter() == null) {
                throw new AssertionError();
            }
            return value;
        }
        return GraphBuilderContext.setStateAfterIfNecessary(this, this.append(value));
    }

    default public Node canonicalizeAndAdd(Node value) {
        return this.add(value);
    }

    default public ValueNode addNonNullCast(ValueNode value) {
        return this.addNonNullCast(value, DeoptimizationAction.None);
    }

    default public ValueNode addNonNullCast(ValueNode value, DeoptimizationAction action) {
        AbstractPointerStamp valueStamp = (AbstractPointerStamp)value.stamp(NodeView.DEFAULT);
        if (valueStamp.nonNull()) {
            return value;
        }
        LogicNode isNull = this.add(IsNullNode.create(value));
        FixedGuardNode fixedGuard = this.add(new FixedGuardNode(isNull, DeoptimizationReason.NullCheckException, action, true));
        Stamp newStamp = valueStamp.improveWith(StampFactory.objectNonNull());
        return this.add(PiNode.create(value, newStamp, fixedGuard));
    }

    default public <T extends ValueNode> T addPush(JavaKind kind, T value) {
        T equivalentValue = value.graph() != null ? value : this.append(value);
        this.push(kind, equivalentValue);
        return GraphBuilderContext.setStateAfterIfNecessary(this, equivalentValue);
    }

    public Invokable handleReplacedInvoke(CallTargetNode.InvokeKind var1, ResolvedJavaMethod var2, ValueNode[] var3, boolean var4);

    public void handleReplacedInvoke(CallTargetNode var1, JavaKind var2);

    public void setStateAfter(StateSplit var1);

    default public void setStateAfterSkipVerification(StateSplit sideEffect) {
        this.setStateAfter(sideEffect);
    }

    public GraphBuilderContext getParent();

    default public GraphBuilderContext getNonIntrinsicAncestor() {
        GraphBuilderContext ancestor;
        for (ancestor = this.getParent(); ancestor != null && ancestor.parsingIntrinsic(); ancestor = ancestor.getParent()) {
        }
        return ancestor;
    }

    public Bytecode getCode();

    public ResolvedJavaMethod getMethod();

    public int bci();

    default public boolean bciCanBeDuplicated() {
        return false;
    }

    public CallTargetNode.InvokeKind getInvokeKind();

    public JavaType getInvokeReturnType();

    default public StampPair getInvokeReturnStamp(Assumptions assumptions) {
        JavaType returnType = this.getInvokeReturnType();
        return StampFactory.forDeclaredType(assumptions, returnType, false);
    }

    default public int getDepth() {
        int result = 0;
        for (GraphBuilderContext parent = this.getParent(); parent != null; parent = parent.getParent()) {
            ++result;
        }
        return result;
    }

    default public int recursiveInliningDepth(ResolvedJavaMethod method) {
        int result = 0;
        for (GraphBuilderContext cur = this; cur != null; cur = cur.getParent()) {
            if (!method.equals((Object)cur.getMethod())) continue;
            ++result;
        }
        return result;
    }

    @Override
    default public boolean parsingIntrinsic() {
        return this.getIntrinsic() != null;
    }

    default public boolean isPluginEnabled(GraphBuilderPlugin plugin) {
        return this.parsingIntrinsic() || !(plugin instanceof GeneratedInvocationPlugin) || !((GeneratedInvocationPlugin)plugin).isGeneratedFromFoldOrNodeIntrinsic();
    }

    public IntrinsicContext getIntrinsic();

    public boolean isParsingInvocationPlugin();

    public BailoutException bailout(String var1);

    default public ValueNode nullCheckedValue(ValueNode value) {
        return this.nullCheckedValue(value, DeoptimizationAction.InvalidateReprofile);
    }

    default public GuardingNode intrinsicRangeCheck(LogicNode condition, boolean negated) {
        if (!1.$assertionsDisabled && !this.isParsingInvocationPlugin()) {
            throw new AssertionError();
        }
        if (this.needsExplicitException()) {
            return this.emitBytecodeExceptionCheck(condition, negated, BytecodeExceptionNode.BytecodeExceptionKind.INTRINSIC_OUT_OF_BOUNDS, new ValueNode[0]);
        }
        return this.add(new FixedGuardNode(condition, DeoptimizationReason.BoundsCheckException, DeoptimizationAction.None, !negated));
    }

    default public ValueNode nullCheckedValue(ValueNode value, DeoptimizationAction action) {
        if (!StampTool.isPointerNonNull(value)) {
            LogicNode condition = this.getGraph().unique(IsNullNode.create(value));
            GuardingNode guardingNode = this.needsExplicitException() ? this.emitBytecodeExceptionCheck(condition, false, BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER, new ValueNode[0]) : (GuardingNode)this.append(new FixedGuardNode(condition, DeoptimizationReason.NullCheckException, action, true));
            return this.getGraph().addOrUniqueWithInputs(PiNode.create(value, StampFactory.objectNonNull(), guardingNode.asNode()));
        }
        return value;
    }

    default public ValueNode maybeEmitExplicitNegativeArraySizeCheck(ValueNode arrayLength, BytecodeExceptionNode.BytecodeExceptionKind exceptionKind) {
        ValueNode[] valueNodeArray;
        if (!this.needsExplicitException() || ((IntegerStamp)arrayLength.stamp(NodeView.DEFAULT)).isPositive()) {
            return arrayLength;
        }
        ConstantNode zero = ConstantNode.defaultForKind(arrayLength.getStackKind());
        LogicNode condition = this.append(IntegerLessThanNode.create(this.getConstantReflection(), this.getMetaAccess(), this.getOptions(), null, arrayLength, zero, NodeView.DEFAULT));
        if (exceptionKind.getNumArguments() == 1) {
            ValueNode[] valueNodeArray2 = new ValueNode[1];
            valueNodeArray = valueNodeArray2;
            valueNodeArray2[0] = arrayLength;
        } else {
            valueNodeArray = ValueNode.EMPTY_ARRAY;
        }
        ValueNode[] arguments = valueNodeArray;
        AbstractBeginNode guardingNode = this.emitBytecodeExceptionCheck(condition, false, exceptionKind, arguments);
        if (guardingNode == null) {
            return arrayLength;
        }
        return this.append(PiNode.create(arrayLength, StampFactory.positiveInt(), guardingNode.asNode()));
    }

    default public ValueNode maybeEmitExplicitNegativeArraySizeCheck(ValueNode arrayLength) {
        return this.maybeEmitExplicitNegativeArraySizeCheck(arrayLength, BytecodeExceptionNode.BytecodeExceptionKind.NEGATIVE_ARRAY_SIZE);
    }

    default public GuardingNode maybeEmitExplicitDivisionByZeroCheck(ValueNode divisor) {
        if (!this.needsExplicitException() || !((IntegerStamp)divisor.stamp(NodeView.DEFAULT)).contains(0L)) {
            return null;
        }
        ConstantNode zero = this.add(ConstantNode.defaultForKind(divisor.getStackKind()));
        LogicNode condition = this.add(IntegerEqualsNode.create(this.getConstantReflection(), this.getMetaAccess(), this.getOptions(), null, divisor, zero, NodeView.DEFAULT));
        return this.emitBytecodeExceptionCheck(condition, false, BytecodeExceptionNode.BytecodeExceptionKind.DIVISION_BY_ZERO, new ValueNode[0]);
    }

    default public AbstractBeginNode emitBytecodeExceptionCheck(LogicNode condition, boolean passingOnTrue, BytecodeExceptionNode.BytecodeExceptionKind exceptionKind, ValueNode ... arguments) {
        if (passingOnTrue ? condition.isTautology() : condition.isContradiction()) {
            return null;
        }
        AbstractBeginNode exceptionPath = this.genExplicitExceptionEdge(exceptionKind, arguments);
        AbstractBeginNode trueSuccessor = passingOnTrue ? null : exceptionPath;
        AbstractBeginNode falseSuccessor = passingOnTrue ? exceptionPath : null;
        boolean negate = !passingOnTrue;
        ProfileData.BranchProbabilityData probability = ProfileData.BranchProbabilityData.injected(0.999999, negate);
        IfNode ifNode = this.append(new IfNode(condition, trueSuccessor, falseSuccessor, probability));
        BeginNode passingSuccessor = this.append(new BeginNode());
        if (passingOnTrue) {
            ifNode.setTrueSuccessor(passingSuccessor);
        } else {
            ifNode.setFalseSuccessor(passingSuccessor);
        }
        return passingSuccessor;
    }

    default public void genCheckcastDynamic(ValueNode object, ValueNode javaClass) {
        LogicNode condition = InstanceOfDynamicNode.create(this.getAssumptions(), this.getConstantReflection(), javaClass, object, true);
        if (condition.isTautology()) {
            this.addPush(JavaKind.Object, object);
        } else {
            this.append(condition);
            GuardingNode guardingNode = this.needsExplicitException() ? this.emitBytecodeExceptionCheck(condition, true, BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, object, javaClass) : (GuardingNode)this.add(new FixedGuardNode(condition, DeoptimizationReason.ClassCastException, DeoptimizationAction.InvalidateReprofile, false));
            this.addPush(JavaKind.Object, DynamicPiNode.create(this.getAssumptions(), this.getConstantReflection(), object, guardingNode, javaClass));
        }
    }

    default public boolean canMergeIntrinsicReturns() {
        if (!1.$assertionsDisabled && !this.isParsingInvocationPlugin()) {
            throw new AssertionError();
        }
        return false;
    }

    default public FrameState getInvocationPluginReturnState(JavaKind returnKind, ValueNode returnValue) {
        throw new GraalError("Cannot be called on a " + this.getClass().getName() + " object");
    }

    default public FrameState getInvocationPluginBeforeState() {
        throw new GraalError("Cannot be called on a " + this.getClass().getName() + " object");
    }

    default public boolean allowDeoptInPlugins() {
        return GraalOptions.StrictDeoptInsertionChecks.getValue(this.getOptions()) == false;
    }

    default public Invoke invokeFallback(FixedWithNextNode predecessor, EndNode end) {
        throw new GraalError("Cannot be called on a " + this.getClass().getName() + " object");
    }

    default public ExternalInliningContext getExternalInliningContext() {
        return null;
    }

    default public ValueNode maskSubWordValue(ValueNode value, JavaKind kind) {
        if (kind == kind.getStackKind()) {
            return value;
        }
        ValueNode narrow = this.append(NarrowNode.create(value, kind.getBitCount(), NodeView.DEFAULT));
        if (kind.isUnsigned()) {
            return this.append(ZeroExtendNode.create(narrow, 32, NodeView.DEFAULT));
        }
        return this.append(SignExtendNode.create(narrow, 32, NodeView.DEFAULT));
    }

    default public boolean needsExplicitException() {
        return false;
    }

    default public AbstractBeginNode genExplicitExceptionEdge(BytecodeExceptionNode.BytecodeExceptionKind exceptionKind, ValueNode ... exceptionArguments) {
        throw GraalError.unimplementedParent();
    }

    default public void replacePlugin(GeneratedInvocationPlugin plugin, ResolvedJavaMethod targetMethod, ValueNode[] args, PluginReplacementNode.ReplacementFunction replacementFunction) {
        throw GraalError.unimplementedParent();
    }

    default public void replacePluginWithException(GeneratedInvocationPlugin plugin, ResolvedJavaMethod targetMethod, ValueNode[] args, PluginReplacementWithExceptionNode.ReplacementWithExceptionFunction replacementFunction) {
        throw GraalError.unimplementedParent();
    }

    public static <T extends Node> T setStateAfterIfNecessary(GraphBuilderContext b, T value) {
        if (value instanceof StateSplit) {
            StateSplit stateSplit = (StateSplit)((Object)value);
            FrameState oldState = stateSplit.stateAfter();
            if (stateSplit.stateAfter() == null && (stateSplit.hasSideEffect() || stateSplit instanceof AbstractMergeNode)) {
                b.setStateAfter(stateSplit);
            }
            FrameState newState = stateSplit.stateAfter();
            GraalError.guarantee(oldState == null || oldState.equals(newState), "graph builder changed existing state on %s from %s to %s, this indicates multiple calls to add() or addPush() for one node", (Object)stateSplit, (Object)oldState, (Object)newState);
        }
        return value;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static interface ExternalInliningContext {
        public int getInlinedDepth();
    }
}

