/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.graphbuilderconf;

import jdk.graal.compiler.bytecode.BytecodeProvider;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderPlugin;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public interface InlineInvokePlugin
extends GraphBuilderPlugin {
    default public InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
        return null;
    }

    default public void notifyBeforeInline(ResolvedJavaMethod methodToInline) {
    }

    default public void notifyAfterInline(ResolvedJavaMethod methodToInline) {
    }

    default public void notifyNotInlined(GraphBuilderContext b, ResolvedJavaMethod method, Invoke invoke) {
    }

    public static final class InlineInfo {
        public static final InlineInfo DO_NOT_INLINE_WITH_EXCEPTION = new InlineInfo();
        public static final InlineInfo DO_NOT_INLINE_NO_EXCEPTION = new InlineInfo();
        public static final InlineInfo DO_NOT_INLINE_DEOPTIMIZE_ON_EXCEPTION = new InlineInfo();
        private final ResolvedJavaMethod methodToInline;
        private final BytecodeProvider intrinsicBytecodeProvider;

        public static InlineInfo createStandardInlineInfo(ResolvedJavaMethod methodToInline) {
            return new InlineInfo(methodToInline, null);
        }

        public static InlineInfo createIntrinsicInlineInfo(ResolvedJavaMethod methodToInline, BytecodeProvider intrinsicBytecodeProvider) {
            return new InlineInfo(methodToInline, intrinsicBytecodeProvider);
        }

        private InlineInfo() {
            this(null, null);
        }

        private InlineInfo(ResolvedJavaMethod methodToInline, BytecodeProvider intrinsicBytecodeProvider) {
            this.methodToInline = methodToInline;
            this.intrinsicBytecodeProvider = intrinsicBytecodeProvider;
        }

        public ResolvedJavaMethod getMethodToInline() {
            return this.methodToInline;
        }

        public boolean allowsInlining() {
            return this.methodToInline != null;
        }

        public BytecodeProvider getIntrinsicBytecodeProvider() {
            return this.intrinsicBytecodeProvider;
        }
    }
}

