/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.java;

import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.memory.FixedAccessNode;
import jdk.graal.compiler.nodes.memory.LIRLowerableAccess;
import jdk.graal.compiler.nodes.memory.OrderedMemoryAccess;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Value, InputType.Memory})
public abstract class AbstractCompareAndSwapNode
extends FixedAccessNode
implements OrderedMemoryAccess,
StateSplit,
LIRLowerableAccess,
SingleMemoryKill {
    public static final NodeClass<AbstractCompareAndSwapNode> TYPE = NodeClass.create(AbstractCompareAndSwapNode.class);
    @Node.Input
    ValueNode expectedValue;
    @Node.Input
    ValueNode newValue;
    @Node.OptionalInput(value=InputType.State)
    FrameState stateAfter;
    protected final MemoryOrderMode memoryOrder;

    @Override
    public FrameState stateAfter() {
        return this.stateAfter;
    }

    @Override
    public void setStateAfter(FrameState x) {
        assert (x == null || x.isAlive()) : "frame state must be in a graph";
        this.updateUsages(this.stateAfter, x);
        this.stateAfter = x;
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }

    public ValueNode getExpectedValue() {
        return this.expectedValue;
    }

    public ValueNode getNewValue() {
        return this.newValue;
    }

    @Override
    public final MemoryOrderMode getMemoryOrder() {
        return this.memoryOrder;
    }

    public AbstractCompareAndSwapNode(NodeClass<? extends AbstractCompareAndSwapNode> c, AddressNode address, LocationIdentity location, ValueNode expectedValue, ValueNode newValue, BarrierType barrierType, Stamp stamp, MemoryOrderMode memoryOrder) {
        super(c, address, location, stamp, barrierType);
        assert (expectedValue.getStackKind() == newValue.getStackKind()) : Assertions.errorMessageContext("c", c, "adr", address, "loc", location, "expected", expectedValue, "newVal", newValue);
        this.expectedValue = expectedValue;
        this.newValue = newValue;
        this.memoryOrder = memoryOrder;
    }

    @Override
    public boolean canNullCheck() {
        return false;
    }

    @Override
    public Stamp getAccessStamp(NodeView view) {
        return this.expectedValue.stamp(view).meet(this.newValue.stamp(view)).unrestricted();
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return this.ordersMemoryAccesses() ? LocationIdentity.ANY_LOCATION : this.location;
    }
}

