/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.java;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.java.AccessArrayNode;
import jdk.graal.compiler.nodes.memory.MemoryAccess;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;

@NodeInfo
public abstract class AccessIndexedNode
extends AccessArrayNode
implements Lowerable,
MemoryAccess {
    public static final NodeClass<AccessIndexedNode> TYPE = NodeClass.create(AccessIndexedNode.class);
    @Node.Input
    protected ValueNode index;
    @Node.OptionalInput(value=InputType.Guard)
    private GuardingNode boundsCheck;
    protected final JavaKind elementKind;
    protected final LocationIdentity location;

    public ValueNode index() {
        return this.index;
    }

    protected AccessIndexedNode(NodeClass<? extends AccessIndexedNode> c, Stamp stamp, ValueNode array, ValueNode index, GuardingNode boundsCheck, JavaKind elementKind) {
        super(c, stamp, array);
        this.index = index;
        this.boundsCheck = boundsCheck;
        this.elementKind = elementKind;
        this.location = NamedLocationIdentity.getArrayLocation(elementKind);
    }

    public GuardingNode getBoundsCheck() {
        return this.boundsCheck;
    }

    public JavaKind elementKind() {
        return this.elementKind;
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return this.location;
    }
}

