/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.java;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.AbstractNewArrayNode;
import jdk.graal.compiler.nodes.java.NewArrayNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo
public class DynamicNewArrayNode
extends AbstractNewArrayNode
implements Canonicalizable {
    public static final NodeClass<DynamicNewArrayNode> TYPE = NodeClass.create(DynamicNewArrayNode.class);
    @Node.Input
    ValueNode elementType;
    @Node.OptionalInput
    ValueNode voidClass;
    protected final JavaKind knownElementKind;

    public DynamicNewArrayNode(ValueNode elementType, ValueNode length, boolean fillContents) {
        this(TYPE, elementType, length, fillContents, null, null, null);
    }

    public DynamicNewArrayNode(@Node.InjectedNodeParameter MetaAccessProvider metaAccess, ValueNode elementType, ValueNode length, boolean fillContents, JavaKind knownElementKind) {
        this(TYPE, elementType, length, fillContents, knownElementKind, null, metaAccess);
    }

    private static Stamp computeStamp(JavaKind knownElementKind, MetaAccessProvider metaAccess) {
        if (knownElementKind != null && metaAccess != null) {
            ResolvedJavaType arrayType = metaAccess.lookupJavaType(knownElementKind == JavaKind.Object ? Object.class : knownElementKind.toJavaClass()).getArrayClass();
            return StampFactory.objectNonNull(TypeReference.createWithoutAssumptions(arrayType));
        }
        return StampFactory.objectNonNull();
    }

    protected DynamicNewArrayNode(NodeClass<? extends DynamicNewArrayNode> c, ValueNode elementType, ValueNode length, boolean fillContents, JavaKind knownElementKind, FrameState stateBefore, MetaAccessProvider metaAccess) {
        super(c, DynamicNewArrayNode.computeStamp(knownElementKind, metaAccess), length, fillContents, stateBefore);
        this.elementType = elementType;
        this.knownElementKind = knownElementKind;
        assert (knownElementKind != JavaKind.Void && knownElementKind != JavaKind.Illegal) : Assertions.errorMessageContext("c", c, "elementType", elementType, "length", length, "knownElementType", knownElementKind);
    }

    public ValueNode getElementType() {
        return this.elementType;
    }

    public JavaKind getKnownElementKind() {
        return this.knownElementKind;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ResolvedJavaType type;
        if (this.elementType.isConstant() && (type = tool.getConstantReflection().asJavaType(this.elementType.asConstant())) != null && !DynamicNewArrayNode.throwsIllegalArgumentException(type) && tool.getMetaAccessExtensionProvider().canConstantFoldDynamicAllocation(type.getArrayClass())) {
            return this.createNewArrayNode(type);
        }
        return this;
    }

    protected NewArrayNode createNewArrayNode(ResolvedJavaType type) {
        return new NewArrayNode(type, this.length(), this.fillContents(), this.stateBefore());
    }

    public static boolean throwsIllegalArgumentException(Class<?> elementType, Class<?> voidClass) {
        return elementType == voidClass;
    }

    public static boolean throwsIllegalArgumentException(ResolvedJavaType elementType) {
        return elementType.getJavaKind() == JavaKind.Void;
    }

    @Node.NodeIntrinsic
    private static native Object newArray(Class<?> var0, int var1, @Node.ConstantNodeParameter boolean var2);

    public static Object newArray(Class<?> componentType, int length) {
        return DynamicNewArrayNode.newArray(componentType, length, true);
    }

    @Node.NodeIntrinsic
    private static native Object newArray(Class<?> var0, int var1, @Node.ConstantNodeParameter boolean var2, @Node.ConstantNodeParameter JavaKind var3);

    public static Object newArray(Class<?> componentType, int length, JavaKind knownElementKind) {
        return DynamicNewArrayNode.newArray(componentType, length, true, knownElementKind);
    }

    public static Object newUninitializedArray(Class<?> componentType, int length, JavaKind knownElementKind) {
        return DynamicNewArrayNode.newArray(componentType, length, false, knownElementKind);
    }

    public ValueNode getVoidClass() {
        return this.voidClass;
    }

    public void setVoidClass(ValueNode newVoidClass) {
        this.updateUsages(this.voidClass, newVoidClass);
        this.voidClass = newVoidClass;
    }
}

