/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.java;

import java.lang.reflect.Modifier;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.java.AbstractNewObjectNode;
import jdk.graal.compiler.nodes.java.NewInstanceNode;
import jdk.graal.compiler.nodes.java.ValidateNewInstanceClassNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo
public final class DynamicNewInstanceNode
extends AbstractNewObjectNode
implements Canonicalizable {
    public static final NodeClass<DynamicNewInstanceNode> TYPE = NodeClass.create(DynamicNewInstanceNode.class);
    @Node.Input
    ValueNode clazz;

    public static void createAndPush(GraphBuilderContext b, ValueNode clazz) {
        ResolvedJavaType constantType = DynamicNewInstanceNode.tryConvertToNonDynamic(clazz, b);
        if (constantType != null) {
            b.addPush(JavaKind.Object, new NewInstanceNode(constantType, true));
        } else {
            ValueNode clazzLegal = b.add(new ValidateNewInstanceClassNode(clazz));
            b.addPush(JavaKind.Object, new DynamicNewInstanceNode(clazzLegal, true));
        }
    }

    protected DynamicNewInstanceNode(ValueNode clazz, boolean fillContents) {
        super(TYPE, StampFactory.objectNonNull(), fillContents, null);
        this.clazz = clazz;
        assert (((ObjectStamp)clazz.stamp(NodeView.DEFAULT)).nonNull());
    }

    public ValueNode getInstanceType() {
        return this.clazz;
    }

    static ResolvedJavaType tryConvertToNonDynamic(ValueNode clazz, CoreProviders tool) {
        ResolvedJavaType type;
        if (clazz.isConstant() && (type = tool.getConstantReflection().asJavaType(clazz.asConstant())) != null && !DynamicNewInstanceNode.throwsInstantiationException(type, tool.getMetaAccess()) && tool.getMetaAccessExtensionProvider().canConstantFoldDynamicAllocation(type)) {
            return type;
        }
        return null;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ResolvedJavaType type = DynamicNewInstanceNode.tryConvertToNonDynamic(this.clazz, tool);
        if (type != null) {
            return new NewInstanceNode(type, this.fillContents(), this.stateBefore());
        }
        return this;
    }

    public static boolean throwsInstantiationExceptionInjectedProbability(double probability, Class<?> type, Class<?> classClass) {
        return BranchProbabilityNode.probability(probability, type.isPrimitive()) || BranchProbabilityNode.probability(probability, type.isArray()) || BranchProbabilityNode.probability(probability, type.isInterface()) || BranchProbabilityNode.probability(probability, Modifier.isAbstract(type.getModifiers())) || BranchProbabilityNode.probability(probability, type == classClass);
    }

    public static boolean throwsInstantiationException(ResolvedJavaType type, MetaAccessProvider metaAccess) {
        return type.isPrimitive() || type.isArray() || type.isInterface() || Modifier.isAbstract(type.getModifiers()) || type.equals((Object)metaAccess.lookupJavaType(Class.class));
    }
}

