/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.java;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.BeginStateSplitNode;
import jdk.graal.compiler.nodes.DeoptimizingNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.java.LoadExceptionObjectNode;
import jdk.graal.compiler.nodes.memory.MemoryAnchorNode;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_8)
public final class ExceptionObjectNode
extends BeginStateSplitNode
implements Lowerable,
SingleMemoryKill,
DeoptimizingNode.DeoptAfter {
    public static final NodeClass<ExceptionObjectNode> TYPE = NodeClass.create(ExceptionObjectNode.class);

    public ExceptionObjectNode(MetaAccessProvider metaAccess) {
        super((NodeClass<? extends BeginStateSplitNode>)TYPE, (Stamp)StampFactory.objectNonNull(TypeReference.createTrustedWithoutAssumptions(metaAccess.lookupJavaType(Throwable.class))));
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }

    @Override
    public void lower(LoweringTool tool) {
        if (this.isMarkerAndCanBeRemoved()) {
            this.graph().removeFixed(this);
            return;
        }
        if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.LOW_TIER) {
            BeginNode begin;
            LoadExceptionObjectNode loadException = this.graph().add(new LoadExceptionObjectNode(this.stamp(NodeView.DEFAULT)));
            GraalError.guarantee(this.graph().getGuardsStage().areFrameStatesAtDeopts(), "Should be after FSA %s", (Object)this);
            GraalError.guarantee(this.stateAfter() != null, "StateAfter must not be null for %s", (Object)this);
            loadException.setStateAfter(this.stateAfter());
            FixedWithNextNode insertAfter = begin = this.graph().add(new BeginNode());
            this.graph().addAfterFixed(this, begin);
            this.replaceAtUsages((Node)loadException, InputType.Value);
            if (this.hasUsages()) {
                MemoryAnchorNode anchor = this.graph().add(new MemoryAnchorNode(LocationIdentity.any()));
                this.graph().addAfterFixed(begin, anchor);
                this.replaceAtUsages((Node)anchor, InputType.Memory);
                insertAfter = anchor;
            }
            this.graph().addAfterFixed(insertAfter, loadException);
            this.graph().removeFixed(this);
            loadException.lower(tool);
        }
    }

    private boolean isMarkerAndCanBeRemoved() {
        if (this.predecessor() instanceof WithExceptionNode) {
            return false;
        }
        GraalError.guarantee(this.predecessor() instanceof ExceptionObjectNode || this.predecessor() instanceof MergeNode, "Unexpected predecessor of %s: %s", (Object)this, (Object)this.predecessor());
        GraalError.guarantee(ExceptionObjectNode.getExceptionValueFromState(this) == ExceptionObjectNode.getExceptionValueFromState((StateSplit)((Object)this.predecessor())), "predecessor of %s with unexpected state: %s", (Object)this, (Object)this.predecessor());
        GraalError.guarantee(this.hasNoUsages(), "Unexpected usages of %s", (Object)this);
        return true;
    }

    private static ValueNode getExceptionValueFromState(StateSplit exceptionObjectNode) {
        if (exceptionObjectNode.asNode().graph().getGraphState().getFrameStateVerification() == GraphState.FrameStateVerification.NONE) {
            return null;
        }
        GraalError.guarantee(exceptionObjectNode.stateAfter() != null, "an exception handler needs a frame state");
        GraalError.guarantee(exceptionObjectNode.stateAfter().stackSize() == 1 && exceptionObjectNode.stateAfter().stackAt(0).stamp(NodeView.DEFAULT).getStackKind() == JavaKind.Object, "an exception handler's frame state must have only the exception on the stack");
        return exceptionObjectNode.stateAfter().stackAt(0);
    }

    @Override
    public boolean verify() {
        this.assertTrue(this.graph().getGraphState().getFrameStateVerification() == GraphState.FrameStateVerification.NONE || this.stateAfter() != null, "an exception handler needs a frame state", new Object[0]);
        this.assertTrue(this.graph().getGraphState().getFrameStateVerification() == GraphState.FrameStateVerification.NONE || this.stateAfter().stackSize() == 1 && this.stateAfter().stackAt(0).stamp(NodeView.DEFAULT).getStackKind() == JavaKind.Object, "an exception handler's frame state must have only the exception on the stack", new Object[0]);
        return super.verify();
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }
}

