/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.java;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.BinaryOpLogicNode;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.TriState;

@NodeInfo(cycles=NodeCycles.CYCLES_32, size=NodeSize.SIZE_32)
public class InstanceOfDynamicNode
extends BinaryOpLogicNode
implements Canonicalizable.Binary<ValueNode>,
Lowerable {
    public static final NodeClass<InstanceOfDynamicNode> TYPE = NodeClass.create(InstanceOfDynamicNode.class);
    private final boolean allowNull;
    private final boolean exact;

    public static LogicNode create(Assumptions assumptions, ConstantReflectionProvider constantReflection, ValueNode mirror, ValueNode object, boolean allowNull, boolean exact) {
        LogicNode synonym = InstanceOfDynamicNode.findSynonym(assumptions, constantReflection, mirror, object, allowNull, exact);
        if (synonym != null) {
            return synonym;
        }
        return new InstanceOfDynamicNode(mirror, object, allowNull, exact);
    }

    public static LogicNode create(Assumptions assumptions, ConstantReflectionProvider constantReflection, ValueNode mirror, ValueNode object, boolean allowNull) {
        return InstanceOfDynamicNode.create(assumptions, constantReflection, mirror, object, allowNull, false);
    }

    public static LogicNode create(ValueNode mirror, ValueNode object) {
        return new InstanceOfDynamicNode(mirror, object, false, false);
    }

    protected InstanceOfDynamicNode(ValueNode mirror, ValueNode object, boolean allowNull, boolean exact) {
        super(TYPE, mirror, object);
        this.allowNull = allowNull;
        this.exact = exact;
        assert (mirror.getStackKind() == JavaKind.Object || mirror.getStackKind() == JavaKind.Illegal) : mirror.getStackKind();
    }

    private static LogicNode findSynonym(Assumptions assumptions, ConstantReflectionProvider constantReflection, ValueNode forMirror, ValueNode forObject, boolean allowNull, boolean exact) {
        ResolvedJavaType t;
        if (forMirror.isConstant() && (t = constantReflection.asJavaType(forMirror.asConstant())) != null) {
            TypeReference type;
            if (t.isPrimitive()) {
                if (allowNull) {
                    return IsNullNode.create(forObject);
                }
                return LogicConstantNode.contradiction();
            }
            TypeReference typeReference = type = exact ? TypeReference.createExactTrusted(t) : TypeReference.createTrusted(assumptions, t);
            if (allowNull) {
                return InstanceOfNode.createAllowNull(type, forObject, null, null);
            }
            return InstanceOfNode.create(type, forObject);
        }
        return null;
    }

    public ValueNode getMirrorOrHub() {
        return this.getX();
    }

    public ValueNode getObject() {
        return this.getY();
    }

    public LogicNode canonical(CanonicalizerTool tool, ValueNode forMirror, ValueNode forObject) {
        LogicNode result = InstanceOfDynamicNode.findSynonym(tool.getAssumptions(), tool.getConstantReflection(), forMirror, forObject, this.allowNull, this.exact);
        if (result != null) {
            return result;
        }
        return this;
    }

    public void setMirror(ValueNode newObject) {
        this.updateUsages(this.x, newObject);
        this.x = newObject;
    }

    public boolean allowsNull() {
        return this.allowNull;
    }

    public boolean isExact() {
        return this.exact;
    }

    @Override
    public Stamp getSucceedingStampForX(boolean negated, Stamp xStamp, Stamp yStamp) {
        return null;
    }

    @Override
    public Stamp getSucceedingStampForY(boolean negated, Stamp xStamp, Stamp yStamp) {
        return null;
    }

    @Override
    public TriState tryFold(Stamp xStamp, Stamp yStamp) {
        return TriState.UNKNOWN;
    }
}

