/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.java;

import java.util.Collections;
import jdk.graal.compiler.core.common.calc.CanonicalCondition;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedGuardNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.CompareNode;
import jdk.graal.compiler.nodes.java.AbstractNewArrayNode;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.nodes.spi.VirtualizableAllocation;
import jdk.graal.compiler.nodes.spi.VirtualizerTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.nodes.virtual.VirtualArrayNode;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo
public class NewArrayNode
extends AbstractNewArrayNode
implements VirtualizableAllocation,
Simplifiable {
    public static final NodeClass<NewArrayNode> TYPE = NodeClass.create(NewArrayNode.class);
    private final ResolvedJavaType elementType;

    public NewArrayNode(ResolvedJavaType elementType, ValueNode length, boolean fillContents) {
        this(elementType, length, fillContents, null);
    }

    public NewArrayNode(ResolvedJavaType elementType, ValueNode length, boolean fillContents, FrameState stateBefore) {
        this(TYPE, elementType, length, fillContents, stateBefore);
    }

    protected NewArrayNode(NodeClass<? extends NewArrayNode> c, ResolvedJavaType elementType, ValueNode length, boolean fillContents, FrameState stateBefore) {
        super(c, StampFactory.objectNonNull(TypeReference.createExactTrusted(elementType.getArrayClass())), length, fillContents, stateBefore);
        this.elementType = elementType;
    }

    @Node.NodeIntrinsic
    private static native Object newArray(@Node.ConstantNodeParameter Class<?> var0, int var1, @Node.ConstantNodeParameter boolean var2);

    public static Object newUninitializedArray(Class<?> elementType, int length) {
        return NewArrayNode.newArray(elementType, length, false);
    }

    public ResolvedJavaType elementType() {
        return this.elementType;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        int constantLength;
        ValueNode lengthAlias = tool.getAlias(this.length());
        if (lengthAlias.asConstant() != null && (constantLength = lengthAlias.asJavaConstant().asInt()) >= 0 && constantLength <= tool.getMaximumEntryCount()) {
            ValueNode[] state = new ValueNode[constantLength];
            if (constantLength > 0) {
                ConstantNode defaultForKind = ConstantNode.defaultForKind(tool.getMetaAccessExtensionProvider().getStorageKind((JavaType)this.elementType()), this.graph());
                for (int i = 0; i < constantLength; ++i) {
                    state[i] = defaultForKind;
                }
            }
            VirtualArrayNode virtualObject = new VirtualArrayNode(this.elementType(), constantLength);
            tool.createVirtualObject(virtualObject, state, Collections.emptyList(), this.getNodeSourcePosition(), false);
            tool.replaceWithVirtual(virtualObject);
        }
    }

    @Override
    public void simplify(SimplifierTool tool) {
        if (this.hasNoUsages()) {
            IntegerStamp lengthIntegerStamp;
            NodeView view = NodeView.from(tool);
            Stamp lengthStamp = this.length().stamp(view);
            if (lengthStamp instanceof IntegerStamp && (lengthIntegerStamp = (IntegerStamp)lengthStamp).isPositive()) {
                GraphUtil.removeFixedWithUnusedInputs(this);
                return;
            }
            if (this.graph().getGuardsStage().allowsFloatingGuards()) {
                try (DebugCloseable context = this.withNodeSourcePosition();){
                    LogicNode lengthNegativeCondition = CompareNode.createCompareNode(this.graph(), CanonicalCondition.LT, this.length(), ConstantNode.forInt(0, this.graph()), tool.getConstantReflection(), view);
                    FixedGuardNode guard = this.graph().add(new FixedGuardNode(lengthNegativeCondition, DeoptimizationReason.RuntimeConstraint, DeoptimizationAction.None, true));
                    this.graph().replaceFixedWithFixed(this, guard);
                }
            }
        }
    }
}

