/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.java;

import jdk.graal.compiler.core.common.type.AbstractPointerStamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.java.DynamicNewInstanceNode;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(size=NodeSize.SIZE_8, cycles=NodeCycles.CYCLES_8, cyclesRationale="Performs multiple checks.")
public final class ValidateNewInstanceClassNode
extends WithExceptionNode
implements Lowerable,
Simplifiable,
SingleMemoryKill {
    @Node.Input
    ValueNode clazz;
    @Node.OptionalInput
    ValueNode classClass;
    public static final NodeClass<ValidateNewInstanceClassNode> TYPE = NodeClass.create(ValidateNewInstanceClassNode.class);

    protected ValidateNewInstanceClassNode(ValueNode clazz) {
        super((NodeClass<? extends WithExceptionNode>)TYPE, AbstractPointerStamp.pointerNonNull(clazz.stamp(NodeView.DEFAULT)));
        this.clazz = clazz;
    }

    public ValueNode getInstanceType() {
        return this.clazz;
    }

    public ValueNode getClassClass() {
        return this.classClass;
    }

    public void setClassClass(ValueNode newClassClass) {
        this.updateUsages(this.classClass, newClassClass);
        this.classClass = newClassClass;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    @Override
    public void simplify(SimplifierTool tool) {
        if (DynamicNewInstanceNode.tryConvertToNonDynamic(this.clazz, tool) != null) {
            this.killExceptionEdge();
            tool.addToWorkList(this.usages());
            this.replaceAtUsages(this.clazz);
            this.graph().removeSplit(this, this.next());
        }
    }
}

