/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.loop;

import java.util.List;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.cfg.Loop;
import jdk.graal.compiler.core.common.util.UnsignedLong;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeBitMap;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.CompareNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.debug.ControlFlowAnchorNode;
import jdk.graal.compiler.nodes.extended.ForeignCall;
import jdk.graal.compiler.nodes.loop.CountedLoopInfo;
import jdk.graal.compiler.nodes.loop.LoopEx;
import jdk.graal.compiler.nodes.loop.LoopPolicies;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import org.graalvm.collections.EconomicMap;

public class DefaultLoopPolicies
implements LoopPolicies {
    @Override
    public boolean shouldPeel(LoopEx loop, ControlFlowGraph cfg, CoreProviders providers, int peelingIteration) {
        StructuredGraph graph;
        OptionValues options;
        if (peelingIteration > 0) {
            return false;
        }
        LoopBeginNode loopBegin = loop.loopBegin();
        double entryProbability = cfg.blockFor(loopBegin.forwardEnd()).getRelativeFrequency();
        if (entryProbability < (double)GraalOptions.MinimumPeelFrequency.getValue(options = (graph = cfg.graph).getOptions()).floatValue()) {
            return false;
        }
        if (loop.parent() != null && loop.size() > loop.parent().size() >> 1) {
            return false;
        }
        if (loop.loop().getChildren().size() > 0) {
            return false;
        }
        return loop.size() + graph.getNodeCount() <= GraalOptions.MaximumDesiredSize.getValue(options);
    }

    public FullUnrollability canFullUnroll(LoopEx loop) {
        DebugContext debug = loop.loopBegin().graph().getDebug();
        if (!(loop.isCounted() && loop.counted().isConstantMaxTripCount() && loop.counted().counterNeverOverflows())) {
            debug.log(2, "Loop %s not fully unrolled, because it is not counted", (Object)loop);
            return FullUnrollability.NOT_COUNTED;
        }
        if (!loop.canDuplicateLoop()) {
            debug.log(2, "Loop %s not fully unrolled, because it cannot be duplicated", (Object)loop);
            return FullUnrollability.MUST_NOT_DUPLICATE;
        }
        OptionValues options = loop.entryPoint().getOptions();
        CountedLoopInfo counted = loop.counted();
        UnsignedLong maxTrips = counted.constantMaxTripCount();
        if (maxTrips.equals(0L)) {
            debug.log(2, "Loop %s should be fully unrolled, because max trips equals 0", (Object)loop);
            return FullUnrollability.SHOULD_FULL_UNROLL;
        }
        if (maxTrips.isGreaterThan(Options.FullUnrollMaxIterations.getValue(options).intValue())) {
            debug.log(2, "Loop %s not fully unrolled, because of too many iterations", (Object)loop);
            return FullUnrollability.TOO_MANY_ITERATIONS;
        }
        int globalMax = GraalOptions.MaximumDesiredSize.getValue(options) - loop.loopBegin().graph().getNodeCount();
        if (globalMax <= 0) {
            debug.log(2, "Loop %s not fully unrolled, because the graph is too large: %d", (Object)loop, globalMax);
            return FullUnrollability.TOO_LARGE;
        }
        int maxNodes = counted.isExactTripCount() ? Options.ExactFullUnrollMaxNodes.getValue(options) : Options.FullUnrollMaxNodes.getValue(options);
        for (Node usage : counted.getLimitCheckedIV().valueNode().usages()) {
            CompareNode compare;
            if (!(usage instanceof CompareNode) || !(compare = (CompareNode)usage).getY().isConstant()) continue;
            maxNodes += Options.FullUnrollConstantCompareBoost.getValue(options).intValue();
        }
        maxNodes = Math.min(maxNodes, globalMax);
        int size = loop.inside().nodes().count();
        size -= 2;
        GraalError.guarantee((size -= loop.loopBegin().loopEnds().count()) >= 0, "Wrong size");
        UnsignedLong estimated = maxTrips.minus(1L).times(size);
        if (estimated.isLessOrEqualTo(maxNodes)) {
            debug.log(2, "Loop %s should be fully unrolled: estimated=%s, max=%d", (Object)loop, (Object)estimated, (Object)maxNodes);
            return FullUnrollability.SHOULD_FULL_UNROLL;
        }
        debug.log(2, "Loop %s not fully unrolled, because size increase is too large: estimated=%s, max=%d", (Object)loop, (Object)estimated, (Object)maxNodes);
        return FullUnrollability.TOO_LARGE;
    }

    @Override
    public boolean shouldFullUnroll(LoopEx loop) {
        return this.canFullUnroll(loop) == FullUnrollability.SHOULD_FULL_UNROLL;
    }

    @Override
    public boolean shouldPartiallyUnroll(LoopEx loop, CoreProviders providers) {
        LoopBeginNode loopBegin = loop.loopBegin();
        if (!loop.isCounted()) {
            loopBegin.getDebug().log(3, "shouldPartiallyUnroll %s isn't counted", (Object)loopBegin);
            return false;
        }
        OptionValues options = loop.entryPoint().getOptions();
        int maxNodes = Options.ExactPartialUnrollMaxNodes.getValue(options);
        maxNodes = Math.min(maxNodes, Math.max(0, GraalOptions.MaximumDesiredSize.getValue(options) - loop.loopBegin().graph().getNodeCount()));
        int size = Math.max(1, loop.size() - 1 - loop.loopBegin().phis().count());
        int unrollFactor = loopBegin.getUnrollFactor();
        if (unrollFactor == 1) {
            double loopFrequency = loop.localLoopFrequency();
            if (loopBegin.isSimpleLoop() && loopFrequency < 5.0) {
                loopBegin.getDebug().log(3, "shouldPartiallyUnroll %s frequency too low %s ", (Object)loopBegin, (Object)loopFrequency);
                return false;
            }
            loopBegin.setLoopOrigFrequency(loopFrequency);
        }
        int maxUnroll = Options.UnrollMaxIterations.getValue(options);
        size += size;
        if (maxUnroll == 1 && loopBegin.isSimpleLoop() || size <= maxNodes && unrollFactor < maxUnroll) {
            if ((int)loopBegin.loopOrigFrequency() < unrollFactor * 2) {
                return false;
            }
            for (Node node : loop.inside().nodes()) {
                if (node instanceof ControlFlowAnchorNode) {
                    return false;
                }
                if (!(node instanceof Invoke) && !(node instanceof ForeignCall)) continue;
                return false;
            }
            return true;
        }
        loopBegin.getDebug().log(3, "shouldPartiallyUnroll %s unrolled loop is too large %s ", (Object)loopBegin, size);
        return false;
    }

    @Override
    public boolean shouldTryUnswitch(LoopEx loop) {
        LoopBeginNode loopBegin = loop.loopBegin();
        double loopFrequency = loop.localLoopFrequency();
        if (loopFrequency <= 1.0) {
            return false;
        }
        OptionValues options = loop.entryPoint().getOptions();
        return loopBegin.unswitches() < GraalOptions.LoopMaxUnswitch.getValue(options);
    }

    private static int approxCodeSizeChange(LoopEx loop, List<ControlSplitNode> controlSplits) {
        StructuredGraph graph = loop.loopBegin().graph();
        NodeBitMap branchNodes = graph.createNodeBitMap();
        for (ControlSplitNode controlSplit : controlSplits) {
            if (controlSplit.getSuccessorCount() > Options.MaxUnswitchSuccessors.getValue(graph.getOptions())) {
                return Integer.MAX_VALUE;
            }
            for (Node successor : controlSplit.successors()) {
                AbstractBeginNode branch = (AbstractBeginNode)successor;
                loop.nodesInLoopBranch(branchNodes, branch);
            }
        }
        int inBranchTotal = branchNodes.count();
        int loopTotal = loop.size();
        int diff = loopTotal - inBranchTotal;
        ControlSplitNode firstSplit = controlSplits.get(0);
        int copies = firstSplit.successors().count() - 1;
        return diff *= copies;
    }

    private static double splitLocalLoopFrequency(LoopEx loop, List<ControlSplitNode> controlSplits) {
        int loopDepth = loop.loop().getDepth();
        double loopLocalFrequency = loop.localLoopFrequency();
        ControlFlowGraph cfg = loop.loopsData().getCFG();
        double loopRelativeFrequency = cfg.blockFor(loop.loopBegin()).getRelativeFrequency();
        double freq = 0.0;
        for (ControlSplitNode node : controlSplits) {
            HIRBlock b = cfg.blockFor(node);
            double f = b.getRelativeFrequency();
            Loop<HIRBlock> l = b.getLoop();
            while (l.getDepth() > loopDepth) {
                f /= loop.loopsData().loop(l).localLoopFrequency();
                l = l.getParent();
            }
            freq += f;
        }
        return freq / loopRelativeFrequency * loopLocalFrequency;
    }

    private static int loopMaxCodeSizeChange(LoopEx loop) {
        StructuredGraph graph = loop.loopBegin().graph();
        OptionValues options = loop.loopBegin().getOptions();
        boolean isTrusted = ProfileData.ProfileSource.isTrusted(loop.localFrequencySource());
        double loopFrequency = isTrusted ? loop.localLoopFrequency() : Options.DefaultLoopFrequency.getValue(options).doubleValue();
        int maxDiff = Options.LoopUnswitchTrivial.getValue(options) + (int)(Options.LoopUnswitchFrequencyBoost.getValue(options) * (loopFrequency - 1.0));
        maxDiff = Math.min(maxDiff, Options.LoopUnswitchMaxIncrease.getValue(options));
        int remainingGraphSpace = GraalOptions.MaximumDesiredSize.getValue(options) - graph.getNodeCount();
        return Math.min(maxDiff, remainingGraphSpace);
    }

    @Override
    public LoopPolicies.UnswitchingDecision shouldUnswitch(LoopEx loop, EconomicMap<ValueNode, List<ControlSplitNode>> controlSplits) {
        if (loop.loopBegin().unswitches() >= GraalOptions.LoopMaxUnswitch.getValue(loop.loopBegin().graph().getOptions())) {
            return LoopPolicies.UnswitchingDecision.NO;
        }
        if (!loop.canDuplicateLoop()) {
            return LoopPolicies.UnswitchingDecision.NO;
        }
        DebugContext debug = loop.loopBegin().getDebug();
        OptionValues options = debug.getOptions();
        double localLoopFrequency = loop.localLoopFrequency();
        int loopSize = loop.size();
        int loopMaxCodeSizeChange = DefaultLoopPolicies.loopMaxCodeSizeChange(loop);
        List bestSplit = null;
        double bestSplitFrequency = 0.0;
        int bestCodeSizeChange = 0;
        double bestFactor = 0.0;
        for (List split : controlSplits.getValues()) {
            double cappedFactor;
            boolean isTrusted = true;
            for (ControlSplitNode node : split) {
                isTrusted = isTrusted && ProfileData.ProfileSource.isTrusted(node.getProfileData().getProfileSource());
            }
            int approxCodeSizeChange = DefaultLoopPolicies.approxCodeSizeChange(loop, split);
            if (approxCodeSizeChange > loopMaxCodeSizeChange) {
                debug.log("control split %s discarded because the code size difference is too big, loop size=%d, loop f=%.2f, max diff=%d, diff=%d, relative code size diff=%d%%", split, (Object)loopSize, (Object)localLoopFrequency, (Object)loopMaxCodeSizeChange, (Object)approxCodeSizeChange, (Object)((int)(100.0 * (double)approxCodeSizeChange / (double)loopSize)));
                continue;
            }
            double splitFrequency = DefaultLoopPolicies.splitLocalLoopFrequency(loop, split);
            if (splitFrequency < Options.LoopUnswitchMinSplitFrequency.getValue(options)) {
                debug.log("control split %s discarded because infrequent, f=%.2f", (Object)split, (Object)splitFrequency);
                continue;
            }
            double factor = Math.pow(((ControlSplitNode)split.get(0)).getSuccessorCount(), ((ControlSplitNode)split.get(0)).getSuccessorCount() * split.size());
            if (isTrusted) {
                for (ControlSplitNode s : split) {
                    for (double p : s.successorProbabilities()) {
                        factor *= p;
                    }
                }
                assert (ProfileData.isApproximatelyInRange(factor, 0.0, 1.0)) : "factor should be between 0 and 1, but is : " + factor;
            } else {
                debug.log("control split %s has an untrusted profile source", split);
                factor = Options.DefaultUnswitchFactor.getValue(options);
            }
            if (splitFrequency < (cappedFactor = 1.0 - Math.clamp(factor, Options.LoopUnswitchFrequencyMinFactor.getValue(options), Options.LoopUnswitchFrequencyMaxFactor.getValue(options))) * localLoopFrequency) {
                debug.log("control split %s not frequenct enough with respect to factor, factor=%.2f, split f=%.2f, loop f=%.2f", split, (Object)cappedFactor, (Object)splitFrequency, (Object)localLoopFrequency);
                continue;
            }
            if (!(splitFrequency > bestSplitFrequency)) continue;
            bestSplitFrequency = splitFrequency;
            bestSplit = split;
            bestCodeSizeChange = approxCodeSizeChange;
            bestFactor = cappedFactor;
        }
        if (bestSplit != null) {
            debug.log("shouldUnswitch(%s, %s) : best=%s, loop size=%d, f=%.2f, max=%d, delta=%d, invariant f=%.2f, factor=%.2f", loop, controlSplits, bestSplit, (Object)loopSize, (Object)localLoopFrequency, (Object)loopMaxCodeSizeChange, (Object)bestCodeSizeChange, (Object)bestSplitFrequency, (Object)bestFactor);
            return LoopPolicies.UnswitchingDecision.yes(bestSplit);
        }
        return LoopPolicies.UnswitchingDecision.NO;
    }

    public static enum FullUnrollability {
        SHOULD_FULL_UNROLL,
        NOT_COUNTED,
        MUST_NOT_DUPLICATE,
        TOO_MANY_ITERATIONS,
        TOO_LARGE;

    }

    public static class Options {
        public static final OptionKey<Integer> LoopUnswitchMaxIncrease = new OptionKey<Integer>(2000);
        public static final OptionKey<Integer> LoopUnswitchTrivial = new OptionKey<Integer>(20);
        public static final OptionKey<Double> LoopUnswitchFrequencyBoost = new OptionKey<Double>(20.0);
        public static final OptionKey<Double> LoopUnswitchFrequencyMinFactor = new OptionKey<Double>(0.05);
        public static final OptionKey<Double> LoopUnswitchFrequencyMaxFactor = new OptionKey<Double>(0.95);
        public static final OptionKey<Double> LoopUnswitchMinSplitFrequency = new OptionKey<Double>(1.0);
        public static final OptionKey<Double> DefaultLoopFrequency = new OptionKey<Double>(100.0);
        public static final OptionKey<Double> DefaultUnswitchFactor = new OptionKey<Double>(0.7);
        public static final OptionKey<Integer> MaxUnswitchSuccessors = new OptionKey<Integer>(64);
        public static final OptionKey<Integer> FullUnrollMaxNodes = new OptionKey<Integer>(700);
        public static final OptionKey<Integer> FullUnrollConstantCompareBoost = new OptionKey<Integer>(15);
        public static final OptionKey<Integer> FullUnrollMaxIterations = new OptionKey<Integer>(600);
        public static final OptionKey<Integer> ExactFullUnrollMaxNodes = new OptionKey<Integer>(800);
        public static final OptionKey<Integer> ExactPartialUnrollMaxNodes = new OptionKey<Integer>(200);
        public static final OptionKey<Integer> UnrollMaxIterations = new OptionKey<Integer>(16);
    }
}

