/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.loop;

import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.core.common.cfg.Loop;
import jdk.graal.compiler.core.common.util.ReversedList;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.loop.InductionVariable;
import jdk.graal.compiler.nodes.loop.LoopEx;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;

public class LoopsData {
    private final EconomicMap<LoopBeginNode, LoopEx> loopBeginToEx;
    private final ControlFlowGraph cfg;
    private final List<LoopEx> loops;

    static LoopsData compute(StructuredGraph graph) {
        return new LoopsData(graph, null);
    }

    static LoopsData compute(ControlFlowGraph cfg) {
        return new LoopsData(cfg.graph, cfg);
    }

    protected LoopsData(ControlFlowGraph cfg, List<LoopEx> loops, EconomicMap<LoopBeginNode, LoopEx> loopBeginToEx) {
        this.cfg = cfg;
        this.loops = loops;
        this.loopBeginToEx = loopBeginToEx;
    }

    protected LoopsData(StructuredGraph graph, ControlFlowGraph preComputedCFG) {
        block11: {
            this.loopBeginToEx = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
            DebugContext debug = graph.getDebug();
            if (preComputedCFG == null) {
                try (DebugContext.Scope s = debug.scope("ControlFlowGraph");){
                    this.cfg = ControlFlowGraph.newBuilder(graph).connectBlocks(true).computeLoops(true).computeDominators(true).computePostdominators(true).computeFrequency(true).build();
                    break block11;
                }
                catch (Throwable e) {
                    throw debug.handle(e);
                }
            }
            this.cfg = preComputedCFG;
        }
        assert (LoopsData.checkLoopOrder(this.cfg.getLoops()));
        this.loops = new ArrayList<LoopEx>(this.cfg.getLoops().size());
        for (Loop loop : this.cfg.getLoops()) {
            LoopEx ex = new LoopEx(loop, this);
            this.loops.add(ex);
            this.loopBeginToEx.put((Object)ex.loopBegin(), (Object)ex);
        }
    }

    protected static boolean checkLoopOrder(Iterable<Loop<HIRBlock>> loops) {
        EconomicSet seen = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
        for (Loop<HIRBlock> loop : loops) {
            if (loop.getParent() != null && !seen.contains(loop.getParent())) {
                return false;
            }
            seen.add(loop);
        }
        return true;
    }

    public LoopEx loop(Loop<HIRBlock> loop) {
        return (LoopEx)this.loopBeginToEx.get((Object)((LoopBeginNode)loop.getHeader().getBeginNode()));
    }

    public LoopEx loop(LoopBeginNode loopBegin) {
        return (LoopEx)this.loopBeginToEx.get((Object)loopBegin);
    }

    public List<LoopEx> loops() {
        return this.loops;
    }

    public List<LoopEx> outerFirst() {
        return this.loops;
    }

    public List<LoopEx> innerFirst() {
        return ReversedList.reversed(this.loops);
    }

    public List<LoopEx> nonCountedLoops() {
        ArrayList<LoopEx> nonCounted = new ArrayList<LoopEx>();
        for (LoopEx loop : this.loops()) {
            if (loop.isCounted()) continue;
            nonCounted.add(loop);
        }
        return nonCounted;
    }

    public List<LoopEx> countedLoops() {
        ArrayList<LoopEx> counted = new ArrayList<LoopEx>();
        for (LoopEx loop : this.loops()) {
            if (!loop.isCounted()) continue;
            counted.add(loop);
        }
        return counted;
    }

    public void detectCountedLoops() {
        for (LoopEx loop : this.loops()) {
            loop.detectCounted();
        }
    }

    public ControlFlowGraph getCFG() {
        return this.cfg;
    }

    public InductionVariable getInductionVariable(ValueNode value) {
        InductionVariable match = null;
        for (LoopEx loop : this.loops()) {
            InductionVariable iv = (InductionVariable)loop.getInductionVariables().get((Object)value);
            if (iv == null) continue;
            if (match != null) {
                return null;
            }
            match = iv;
        }
        return match;
    }

    public void deleteUnusedNodes() {
        for (LoopEx loop : this.loops()) {
            loop.deleteUnusedNodes();
        }
    }
}

