/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.memory;

import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.memory.FixedAccessNode;
import jdk.graal.compiler.nodes.memory.FloatingAccessNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo
public abstract class FloatableAccessNode
extends FixedAccessNode {
    public static final NodeClass<FloatableAccessNode> TYPE = NodeClass.create(FloatableAccessNode.class);
    protected boolean forceFixed;

    protected FloatableAccessNode(NodeClass<? extends FloatableAccessNode> c, AddressNode address, LocationIdentity location, Stamp stamp) {
        super(c, address, location, stamp);
    }

    protected FloatableAccessNode(NodeClass<? extends FloatableAccessNode> c, AddressNode address, LocationIdentity location, Stamp stamp, GuardingNode guard, BarrierType barrierType) {
        super(c, address, location, stamp, guard, barrierType, false, null);
    }

    protected FloatableAccessNode(NodeClass<? extends FloatableAccessNode> c, AddressNode address, LocationIdentity location, Stamp stamp, GuardingNode guard, BarrierType barrierType, boolean usedAsNullCheck, FrameState stateBefore) {
        super(c, address, location, stamp, guard, barrierType, usedAsNullCheck, stateBefore);
    }

    public abstract FloatingAccessNode asFloatingNode();

    public void setForceFixed(boolean flag) {
        this.forceFixed = flag;
    }

    public boolean canFloat() {
        return !this.forceFixed && this.getLocationIdentity().isSingle() && (this.getBarrierType() == BarrierType.NONE || this.getBarrierType() == BarrierType.READ);
    }
}

