/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.memory;

import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryExtendKind;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.memory.FixedAccessNode;
import jdk.graal.compiler.nodes.memory.FloatingAccessNode;
import jdk.graal.compiler.nodes.memory.LIRLowerableAccess;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.nodes.memory.WriteNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.Value;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="Read#{p#location/s}", cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class FloatingReadNode
extends FloatingAccessNode
implements LIRLowerableAccess,
Canonicalizable {
    public static final NodeClass<FloatingReadNode> TYPE = NodeClass.create(FloatingReadNode.class);
    @Node.OptionalInput(value=InputType.Memory)
    MemoryKill lastLocationAccess;

    public FloatingReadNode(AddressNode address, LocationIdentity location, MemoryKill lastLocationAccess, Stamp stamp) {
        this(address, location, lastLocationAccess, stamp, null, BarrierType.NONE);
    }

    public FloatingReadNode(AddressNode address, LocationIdentity location, MemoryKill lastLocationAccess, Stamp stamp, GuardingNode guard) {
        this(address, location, lastLocationAccess, stamp, guard, BarrierType.NONE);
    }

    public FloatingReadNode(AddressNode address, LocationIdentity location, MemoryKill lastLocationAccess, Stamp stamp, GuardingNode guard, BarrierType barrierType) {
        super(TYPE, address, location, stamp, guard, barrierType);
        this.lastLocationAccess = lastLocationAccess;
        assert (guard != null || !(address.getBase().stamp(NodeView.DEFAULT) instanceof ObjectStamp) || address.getBase() instanceof ValuePhiNode || ((ObjectStamp)address.getBase().stamp(NodeView.DEFAULT)).nonNull()) : address.getBase();
        assert (barrierType == BarrierType.NONE || stamp.isObjectStamp()) : "incorrect barrier on non-object type: " + String.valueOf(location);
    }

    @Override
    public MemoryKill getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryKill newlla) {
        this.updateUsagesInterface(this.lastLocationAccess, newlla);
        this.lastLocationAccess = newlla;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        LIRKind readKind = gen.getLIRGeneratorTool().getLIRKind(this.stamp(NodeView.DEFAULT));
        if (this.getBarrierType() != BarrierType.NONE && gen.getLIRGeneratorTool().getBarrierSet() != null) {
            gen.setResult(this, (Value)gen.getLIRGeneratorTool().getBarrierSet().emitBarrieredLoad(readKind, gen.operand(this.address), null, MemoryOrderMode.PLAIN, this.getBarrierType()));
        } else {
            gen.setResult(this, (Value)gen.getLIRGeneratorTool().getArithmetic().emitLoad(readKind, gen.operand(this.address), null, MemoryOrderMode.PLAIN, MemoryExtendKind.DEFAULT));
        }
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        WriteNode write;
        ValueNode result = ReadNode.canonicalizeRead(this, this.getAddress(), this.getLocationIdentity(), tool);
        if (result != this) {
            return result;
        }
        if (tool.canonicalizeReads() && this.getAddress().hasMoreThanOneUsage() && this.lastLocationAccess instanceof WriteNode && (write = (WriteNode)this.lastLocationAccess).getAddress() == this.getAddress() && write.getAccessStamp(NodeView.DEFAULT).isCompatible(this.getAccessStamp(NodeView.DEFAULT))) {
            return write.value();
        }
        return this;
    }

    @Override
    public FixedAccessNode asFixedNode() {
        try (DebugCloseable position = this.withNodeSourcePosition();){
            ReadNode result = this.graph().add(new ReadNode(this.getAddress(), this.getLocationIdentity(), this.stamp(NodeView.DEFAULT), this.getBarrierType(), MemoryOrderMode.PLAIN));
            result.setGuard(this.getGuard());
            ReadNode readNode = result;
            return readNode;
        }
    }

    @Override
    public boolean verify() {
        MemoryKill lla = this.getLastLocationAccess();
        assert (lla != null || this.getLocationIdentity().isImmutable()) : "lastLocationAccess of " + String.valueOf(this) + " shouldn't be null for mutable location identity " + String.valueOf(this.getLocationIdentity());
        return super.verify();
    }

    @Override
    public Stamp getAccessStamp(NodeView view) {
        return this.stamp(view);
    }
}

