/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.memory;

import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.util.CompilationAlarm;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.ReinterpretNode;
import jdk.graal.compiler.nodes.gc.WriteBarrier;
import jdk.graal.compiler.nodes.java.AbstractCompareAndSwapNode;
import jdk.graal.compiler.nodes.memory.AbstractWriteNode;
import jdk.graal.compiler.nodes.memory.LIRLowerableAccess;
import jdk.graal.compiler.nodes.memory.MemoryAccess;
import jdk.graal.compiler.nodes.memory.OrderedMemoryAccess;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="Write#{p#location/s}")
public class WriteNode
extends AbstractWriteNode
implements LIRLowerableAccess,
Simplifiable {
    public static final NodeClass<WriteNode> TYPE = NodeClass.create(WriteNode.class);
    private final LocationIdentity killedLocationIdentity;
    private MemoryOrderMode memoryOrder;

    public WriteNode(AddressNode address, LocationIdentity location, ValueNode value, BarrierType barrierType, MemoryOrderMode memoryOrder) {
        this(TYPE, address, location, location, value, barrierType, memoryOrder);
    }

    protected WriteNode(NodeClass<? extends WriteNode> c, AddressNode address, LocationIdentity location, LocationIdentity killedLocationIdentity, ValueNode value, BarrierType barrierType, MemoryOrderMode memoryOrder) {
        super(c, address, location, value, barrierType);
        this.killedLocationIdentity = killedLocationIdentity;
        this.memoryOrder = memoryOrder;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        LIRKind writeKind = gen.getLIRGeneratorTool().getLIRKind(this.value().stamp(NodeView.DEFAULT));
        gen.getLIRGeneratorTool().getArithmetic().emitStore(writeKind, gen.operand(this.address), gen.operand(this.value()), gen.state(this), this.memoryOrder);
    }

    @Override
    public Stamp getAccessStamp(NodeView view) {
        return this.value().stamp(view);
    }

    @Override
    public boolean canNullCheck() {
        return true;
    }

    @Override
    public boolean hasSideEffect() {
        if (this.ordersMemoryAccesses()) {
            return true;
        }
        if (this.getLocationIdentity().equals(LocationIdentity.INIT_LOCATION)) {
            return false;
        }
        return super.hasSideEffect();
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        if (this.ordersMemoryAccesses()) {
            return LocationIdentity.any();
        }
        return this.killedLocationIdentity;
    }

    @Override
    public MemoryOrderMode getMemoryOrder() {
        return this.memoryOrder;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        if (!this.ordersMemoryAccesses()) {
            if (tool.canonicalizeReads() && this.hasExactlyOneUsage() && this.next() instanceof WriteNode) {
                WriteNode write = (WriteNode)this.next();
                if (write.lastLocationAccess == this && write.getAddress() == this.getAddress() && this.getAccessStamp(NodeView.DEFAULT).isCompatible(write.getAccessStamp(NodeView.DEFAULT))) {
                    write.setLastLocationAccess(this.getLastLocationAccess());
                    tool.addToWorkList(this.inputs());
                    tool.addToWorkList(this.next());
                    tool.addToWorkList(this.predecessor());
                    this.graph().removeFixed(this);
                }
            }
            if (this.value() instanceof ReinterpretNode) {
                tool.addToWorkList(this.value());
                tool.addToWorkList(((ReinterpretNode)this.value()).getValue());
                tool.addToWorkList(this);
                this.setValue(((ReinterpretNode)this.value()).getValue());
            }
        } else if (tool.trySinkWriteFences() && this.getMemoryOrder() == MemoryOrderMode.VOLATILE && WriteNode.followedByVolatileWrite(this)) {
            this.memoryOrder = MemoryOrderMode.RELEASE;
        }
    }

    private static boolean followedByVolatileWrite(FixedWithNextNode start) {
        FixedWithNextNode cur = start;
        while (true) {
            CompilationAlarm.checkProgress(start.graph());
            for (Node usage : cur.usages()) {
                if (usage instanceof MemoryAccess && usage instanceof FixedWithNextNode) continue;
                return false;
            }
            FixedNode nextNode = cur.next();
            while (nextNode instanceof WriteBarrier) {
                nextNode = ((WriteBarrier)nextNode).next();
            }
            if (!(nextNode instanceof OrderedMemoryAccess) || !(nextNode instanceof AbstractWriteNode) && !(nextNode instanceof AbstractCompareAndSwapNode)) break;
            if (((OrderedMemoryAccess)((Object)nextNode)).getMemoryOrder() == MemoryOrderMode.VOLATILE) {
                return true;
            }
            cur = (FixedWithNextNode)nextNode;
        }
        return false;
    }
}

