/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.memory.address;

import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(allowedUsageTypes={InputType.Association})
public class IndexAddressNode
extends AddressNode
implements Lowerable {
    public static final NodeClass<IndexAddressNode> TYPE = NodeClass.create(IndexAddressNode.class);
    @Node.Input
    ValueNode array;
    @Node.Input
    ValueNode index;
    private final JavaKind arrayKind;
    private final JavaKind elementKind;

    public IndexAddressNode(ValueNode array, ValueNode index, JavaKind elementKind) {
        this(array, index, elementKind, elementKind);
    }

    public IndexAddressNode(ValueNode array, ValueNode index, JavaKind arrayKind, JavaKind elementKind) {
        this(TYPE, array, index, arrayKind, elementKind);
    }

    protected IndexAddressNode(NodeClass<? extends IndexAddressNode> c, ValueNode array, ValueNode index, JavaKind arrayKind, JavaKind elementKind) {
        super((NodeClass<? extends AddressNode>)c);
        this.array = array;
        this.index = index;
        this.arrayKind = arrayKind;
        this.elementKind = elementKind;
    }

    @Override
    public ValueNode getBase() {
        return this.array;
    }

    public ValueNode getArray() {
        return this.array;
    }

    @Override
    public ValueNode getIndex() {
        return this.index;
    }

    @Override
    public long getMaxConstantDisplacement() {
        return Long.MAX_VALUE;
    }

    public JavaKind getArrayKind() {
        return this.arrayKind;
    }

    public JavaKind getElementKind() {
        return this.elementKind;
    }
}

