/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.virtual;

import java.nio.ByteOrder;
import jdk.graal.compiler.core.common.spi.MetaAccessExtensionProvider;
import jdk.graal.compiler.core.common.type.PrimitiveStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.Verbosity;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.ArrayLengthProvider;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.spi.VirtualizerTool;
import jdk.graal.compiler.nodes.virtual.AllocatedObjectNode;
import jdk.graal.compiler.nodes.virtual.LockState;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo(nameTemplate="VirtualArray({p#objectId}) {p#componentType/s}[{p#length}]")
public class VirtualArrayNode
extends VirtualObjectNode
implements ArrayLengthProvider {
    public static final NodeClass<VirtualArrayNode> TYPE = NodeClass.create(VirtualArrayNode.class);
    protected final ResolvedJavaType componentType;
    protected final int length;

    public VirtualArrayNode(ResolvedJavaType componentType, int length) {
        this(TYPE, componentType, length);
    }

    protected VirtualArrayNode(NodeClass<? extends VirtualObjectNode> c, ResolvedJavaType componentType, int length) {
        super(c, componentType.getArrayClass(), true);
        this.componentType = componentType;
        this.length = length;
    }

    @Override
    public ResolvedJavaType type() {
        return this.componentType.getArrayClass();
    }

    public ResolvedJavaType componentType() {
        return this.componentType;
    }

    @Override
    public int entryCount() {
        return this.length;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
    }

    @Override
    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Name) {
            return super.toString(Verbosity.Name) + "(" + this.getObjectId() + ") " + this.componentType.getName() + "[" + this.length + "]";
        }
        return super.toString(verbosity);
    }

    @Override
    public String entryName(int index) {
        return "[" + index + "]";
    }

    @Override
    public int entryIndexForOffset(MetaAccessProvider metaAccess, long constantOffset, JavaKind expectedEntryKind) {
        return VirtualArrayNode.entryIndexForOffset(metaAccess, constantOffset, expectedEntryKind, this.componentType, this.length);
    }

    public static int entryIndexForOffset(MetaAccessProvider metaAccess, long constantOffset, JavaKind expectedEntryKind, ResolvedJavaType componentType, int length) {
        long offset;
        int baseOffset = metaAccess.getArrayBaseOffset(componentType.getJavaKind());
        int indexScale = metaAccess.getArrayIndexScale(componentType.getJavaKind());
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN && componentType.isPrimitive()) {
            int componentByteCount = componentType.getJavaKind().getByteCount();
            offset = constantOffset - (long)(componentByteCount - Math.min(componentByteCount, 4 + expectedEntryKind.getByteCount()));
        } else {
            offset = constantOffset;
        }
        long index = offset - (long)baseOffset;
        if (index % (long)indexScale != 0L) {
            return -1;
        }
        long elementIndex = index / (long)indexScale;
        if (elementIndex < 0L || elementIndex >= (long)length) {
            return -1;
        }
        return (int)elementIndex;
    }

    @Override
    public JavaKind entryKind(MetaAccessExtensionProvider metaAccessExtensionProvider, int index) {
        assert (index >= 0 && index < this.length) : index + " " + this.length;
        return metaAccessExtensionProvider.getStorageKind((JavaType)this.componentType);
    }

    @Override
    public VirtualArrayNode duplicate() {
        VirtualArrayNode node = new VirtualArrayNode(this.componentType, this.length);
        node.setNodeSourcePosition(this.getNodeSourcePosition());
        return node;
    }

    @Override
    public ValueNode getMaterializedRepresentation(FixedNode fixed, ValueNode[] entries, LockState locks) {
        AllocatedObjectNode node = new AllocatedObjectNode(this);
        node.setNodeSourcePosition(this.getNodeSourcePosition());
        return node;
    }

    @Override
    public ValueNode findLength(ArrayLengthProvider.FindLengthMode mode, ConstantReflectionProvider constantReflection) {
        return ConstantNode.forInt(this.length);
    }

    public int byteArrayEntryByteCount(int index, VirtualizerTool tool) {
        int i;
        for (i = index + 1; i < this.entryCount() && tool.getEntry(this, i).isIllegalConstant(); ++i) {
        }
        return i - index;
    }

    public static ValueNode virtualizeByteArrayRead(ValueNode entry, JavaKind accessKind, Stamp targetStamp) {
        assert (!entry.isIllegalConstant());
        assert (targetStamp.getStackKind().isPrimitive());
        assert (accessKind.getBitCount() <= PrimitiveStamp.getBits(targetStamp)) : Assertions.errorMessageContext("entry", entry, "accessKind", accessKind, "targetStamp", targetStamp);
        return entry;
    }
}

