/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases;

import java.util.Optional;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.phases.BasePhase;
import jdk.vm.ci.meta.MetaAccessProvider;

public abstract class VerifyPhase<C>
extends BasePhase<C> {
    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    @Override
    protected final void run(StructuredGraph graph, C context) {
        this.verify(graph, context);
    }

    protected abstract void verify(StructuredGraph var1, C var2);

    public void verifyClass(Class<?> clazz, MetaAccessProvider metaAccess) {
    }

    public static class VerificationError
    extends AssertionError {
        public VerificationError(String format, Object ... args) {
            super((Object)String.format(format, args));
        }

        public VerificationError(String message, Throwable cause) {
            super(message, cause);
        }

        public VerificationError(Invoke invoke, String format, Object ... args) {
            this(String.format("In %s: %s", invoke.asNode().graph().method().asStackTraceElement(invoke.bci()), format), args);
        }

        public VerificationError(CallTargetNode target, String format, Object ... args) {
            this(target.invoke(), format, args);
        }
    }
}

