/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.Optional;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.GuardPhiNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ShortCircuitOrNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AbstractNormalizeCompareNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.PostRunCanonicalizationPhase;

public class ExpandLogicPhase
extends PostRunCanonicalizationPhase<CoreProviders> {
    private static final double EPSILON = 1.0E-6;

    public ExpandLogicPhase(CanonicalizerPhase canonicalizer) {
        super(canonicalizer);
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(super.notApplicableTo(graphState), BasePhase.NotApplicable.ifApplied(this, GraphState.StageFlag.EXPAND_LOGIC, graphState), BasePhase.NotApplicable.unlessRunAfter(this, GraphState.StageFlag.LOW_TIER_LOWERING, graphState));
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        ExpandLogicPhase.expandLogic(graph);
    }

    public static void expandLogic(StructuredGraph graph) {
        for (ShortCircuitOrNode shortCircuitOrNode : graph.getNodes(ShortCircuitOrNode.TYPE)) {
            ExpandLogicPhase.expandBinary(shortCircuitOrNode);
        }
        assert (graph.getNodes(ShortCircuitOrNode.TYPE).isEmpty());
        for (AbstractNormalizeCompareNode abstractNormalizeCompareNode : graph.getNodes(AbstractNormalizeCompareNode.TYPE)) {
            DebugCloseable s = abstractNormalizeCompareNode.withNodeSourcePosition();
            try {
                ExpandLogicPhase.processNormalizeCompareNode(abstractNormalizeCompareNode);
            }
            finally {
                if (s == null) continue;
                s.close();
            }
        }
    }

    @Override
    public void updateGraphState(GraphState graphState) {
        super.updateGraphState(graphState);
        graphState.setAfterStage(GraphState.StageFlag.EXPAND_LOGIC);
    }

    private static void processNormalizeCompareNode(AbstractNormalizeCompareNode normalize) {
        StructuredGraph graph = normalize.graph();
        LogicNode equalComp = graph.addOrUniqueWithInputs(normalize.createEqualComparison());
        LogicNode lessComp = graph.addOrUniqueWithInputs(normalize.createLowerComparison());
        Stamp stamp = normalize.stamp(NodeView.DEFAULT);
        ConditionalNode equalValue = graph.unique(new ConditionalNode(equalComp, ConstantNode.forIntegerStamp(stamp, 0L, graph), ConstantNode.forIntegerStamp(stamp, 1L, graph)));
        ConditionalNode value = graph.unique(new ConditionalNode(lessComp, ConstantNode.forIntegerStamp(stamp, -1L, graph), equalValue));
        normalize.replaceAtUsagesAndDelete(value);
    }

    private static void expandBinary(ShortCircuitOrNode binary) {
        while (binary.usages().isNotEmpty()) {
            Node usage = binary.usages().first();
            DebugCloseable nsp = usage.withNodeSourcePosition();
            try {
                if (usage instanceof ShortCircuitOrNode) {
                    ExpandLogicPhase.expandBinary((ShortCircuitOrNode)usage);
                    continue;
                }
                if (usage instanceof IfNode) {
                    ExpandLogicPhase.processIf(binary.getX(), binary.isXNegated(), binary.getY(), binary.isYNegated(), (IfNode)usage, binary.getShortCircuitProbability().getDesignatedSuccessorProbability());
                    continue;
                }
                if (usage instanceof ConditionalNode) {
                    ExpandLogicPhase.processConditional(binary.getX(), binary.isXNegated(), binary.getY(), binary.isYNegated(), (ConditionalNode)usage);
                    continue;
                }
                throw GraalError.shouldNotReachHereUnexpectedValue(usage);
            }
            finally {
                if (nsp == null) continue;
                nsp.close();
            }
        }
        binary.safeDelete();
    }

    private static void processIf(LogicNode x, boolean xNegated, LogicNode y, boolean yNegated, IfNode ifNode, double shortCircuitProbability) {
        ExpandLogicPhase.processIf(x, xNegated, y, yNegated, ifNode, shortCircuitProbability, false);
    }

    public static GuardPhiNode processIf(LogicNode x, boolean xNegated, LogicNode y, boolean yNegated, IfNode ifNode, double shortCircuitProbability, boolean createGuardPhi) {
        AbstractBeginNode trueTarget = ifNode.trueSuccessor();
        AbstractBeginNode falseTarget = ifNode.falseSuccessor();
        GuardPhiNode guardPhi = null;
        double firstIfTrueProbability = shortCircuitProbability;
        double secondIfTrueProbability = ExpandLogicPhase.sanitizeProbability((ifNode.getTrueSuccessorProbability() - shortCircuitProbability) / (1.0 - shortCircuitProbability));
        double expectedOriginalIfTrueProbability = firstIfTrueProbability + (1.0 - firstIfTrueProbability) * secondIfTrueProbability;
        if (!ExpandLogicPhase.doubleEquals(ifNode.getTrueSuccessorProbability(), expectedOriginalIfTrueProbability)) {
            firstIfTrueProbability = ifNode.getTrueSuccessorProbability() * shortCircuitProbability;
            secondIfTrueProbability = ExpandLogicPhase.sanitizeProbability(1.0 - ifNode.probability(falseTarget) / (1.0 - firstIfTrueProbability));
        }
        ifNode.clearSuccessors();
        StructuredGraph graph = ifNode.graph();
        AbstractMergeNode trueTargetMerge = graph.add(new MergeNode());
        trueTargetMerge.setNext(trueTarget);
        EndNode firstTrueEnd = graph.add(new EndNode());
        EndNode secondTrueEnd = graph.add(new EndNode());
        trueTargetMerge.addForwardEnd(firstTrueEnd);
        trueTargetMerge.addForwardEnd(secondTrueEnd);
        AbstractBeginNode firstTrueTarget = BeginNode.begin(firstTrueEnd);
        firstTrueTarget.setNodeSourcePosition(trueTarget.getNodeSourcePosition());
        AbstractBeginNode secondTrueTarget = BeginNode.begin(secondTrueEnd);
        secondTrueTarget.setNodeSourcePosition(trueTarget.getNodeSourcePosition());
        if (yNegated) {
            secondIfTrueProbability = 1.0 - secondIfTrueProbability;
        }
        if (xNegated) {
            firstIfTrueProbability = 1.0 - firstIfTrueProbability;
        }
        IfNode secondIf = new IfNode(y, yNegated ? falseTarget : secondTrueTarget, yNegated ? secondTrueTarget : falseTarget, ifNode.getProfileData().copy(secondIfTrueProbability));
        secondIf.setNodeSourcePosition(ifNode.getNodeSourcePosition());
        AbstractBeginNode secondIfBegin = BeginNode.begin(graph.add(secondIf));
        secondIfBegin.setNodeSourcePosition(falseTarget.getNodeSourcePosition());
        IfNode firstIf = graph.add(new IfNode(x, xNegated ? secondIfBegin : firstTrueTarget, xNegated ? firstTrueTarget : secondIfBegin, ifNode.getProfileData().copy(firstIfTrueProbability)));
        firstIf.setNodeSourcePosition(ifNode.getNodeSourcePosition());
        ifNode.replaceAtPredecessor(firstIf);
        ifNode.safeDelete();
        graph.getDebug().dump(5, (Object)graph, "After processing if %s", ifNode);
        if (createGuardPhi) {
            guardPhi = graph.addWithoutUnique(new GuardPhiNode(trueTargetMerge));
            guardPhi.addInput(firstIf.trueSuccessor());
            guardPhi.addInput(secondIf.trueSuccessor());
        }
        return guardPhi;
    }

    private static boolean doubleEquals(double a, double b) {
        assert (!(Double.isNaN(a) || Double.isNaN(b) || Double.isInfinite(a) || Double.isInfinite(b))) : a + " " + b;
        return a - 1.0E-6 < b && a + 1.0E-6 > b;
    }

    private static double sanitizeProbability(double value) {
        double newValue = Math.min(1.0, Math.max(0.0, value));
        if (Double.isNaN(newValue)) {
            newValue = 0.5;
        }
        return newValue;
    }

    private static void processConditional(LogicNode x, boolean xNegated, LogicNode y, boolean yNegated, ConditionalNode conditional) {
        try (DebugCloseable context = conditional.withNodeSourcePosition();){
            ValueNode trueTarget = conditional.trueValue();
            ValueNode falseTarget = conditional.falseValue();
            StructuredGraph graph = conditional.graph();
            ConditionalNode secondConditional = graph.unique(new ConditionalNode(y, yNegated ? falseTarget : trueTarget, yNegated ? trueTarget : falseTarget));
            ConditionalNode firstConditional = graph.unique(new ConditionalNode(x, xNegated ? secondConditional : trueTarget, xNegated ? trueTarget : secondConditional));
            conditional.replaceAndDelete(firstConditional);
            graph.getDebug().dump(5, (Object)graph, "After processing conditional %s", conditional);
        }
    }

    @Override
    public boolean checkContract() {
        return false;
    }
}

