/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.ListIterator;
import java.util.Optional;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.GuardNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.FloatingGuardPhase;
import jdk.graal.compiler.phases.graph.ScheduledNodeIterator;
import jdk.graal.compiler.phases.schedule.SchedulePhase;

public class GuardLoweringPhase
extends BasePhase<CoreProviders>
implements FloatingGuardPhase {
    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(BasePhase.NotApplicable.ifApplied(this, GraphState.StageFlag.GUARD_LOWERING, graphState), BasePhase.NotApplicable.when(!graphState.getGuardsStage().allowsFloatingGuards(), "Floating guards must be allowed"));
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        SchedulePhase.runWithoutContextOptimizations(graph, SchedulePhase.SchedulingStrategy.EARLIEST_WITH_GUARD_ORDER);
        StructuredGraph.ScheduleResult schedule = graph.getLastSchedule();
        for (HIRBlock block : schedule.getCFG().getBlocks()) {
            GuardLoweringPhase.processBlock(block, schedule);
        }
        assert (GuardLoweringPhase.assertNoGuardsLeft(graph));
    }

    @Override
    public void updateGraphState(GraphState graphState) {
        super.updateGraphState(graphState);
        graphState.setAfterStage(GraphState.StageFlag.GUARD_LOWERING);
        graphState.setGuardsStage(GraphState.GuardsStage.FIXED_DEOPTS);
    }

    private static boolean assertNoGuardsLeft(StructuredGraph graph) {
        assert (graph.getNodes(GuardNode.TYPE).isEmpty());
        return true;
    }

    private static void processBlock(HIRBlock block, StructuredGraph.ScheduleResult schedule) {
        DebugContext debug = block.getBeginNode().getDebug();
        new LowerGuards(debug.isDumpEnabledForMethod() || debug.isLogEnabledForMethod()).processNodes(block, schedule);
    }

    private static class LowerGuards
    extends ScheduledNodeIterator {
        private boolean useGuardIdAsDebugId;

        LowerGuards(boolean useGuardIdAsDebugId) {
            this.useGuardIdAsDebugId = useGuardIdAsDebugId;
        }

        @Override
        protected void processNode(Node node, HIRBlock block, StructuredGraph.ScheduleResult schedule, ListIterator<Node> iter) {
            if (node instanceof GuardNode) {
                GuardNode guard = (GuardNode)node;
                FixedWithNextNode lowered = guard.lowerGuard();
                if (lowered != null) {
                    this.replaceCurrent(lowered);
                } else {
                    this.lowerToIf(guard);
                }
            }
        }

        private void lowerToIf(GuardNode guard) {
            try (DebugCloseable position = guard.withNodeSourcePosition();){
                AbstractBeginNode falseSuccessor;
                AbstractBeginNode trueSuccessor;
                StructuredGraph graph = guard.graph();
                AbstractBeginNode fastPath = graph.add(new BeginNode());
                fastPath.setNodeSourcePosition(guard.getNoDeoptSuccessorPosition());
                int debugId = this.useGuardIdAsDebugId ? guard.getId() : 0;
                DeoptimizeNode deopt = graph.add(new DeoptimizeNode(guard.getAction(), guard.getReason(), debugId, guard.getSpeculation(), null));
                AbstractBeginNode deoptBranch = BeginNode.begin(deopt);
                if (guard.isNegated()) {
                    trueSuccessor = deoptBranch;
                    falseSuccessor = fastPath;
                } else {
                    trueSuccessor = fastPath;
                    falseSuccessor = deoptBranch;
                }
                IfNode ifNode = graph.add(new IfNode(guard.getCondition(), trueSuccessor, falseSuccessor, trueSuccessor == fastPath ? BranchProbabilityNode.ALWAYS_TAKEN_PROFILE : BranchProbabilityNode.NEVER_TAKEN_PROFILE));
                guard.replaceAndDelete(fastPath);
                this.insert(ifNode, fastPath);
                graph.getDebug().dump(5, (Object)graph, "After lowering guard %s", guard);
            }
        }
    }
}

