/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.EnumSet;
import java.util.Optional;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeWorkList;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.util.EconomicSetNodeEventListener;

public class IncrementalCanonicalizerPhase
extends CanonicalizerPhase {
    private final StructuredGraph initialGraph;
    private final CanonicalizerPhase.Tool theTool;

    IncrementalCanonicalizerPhase(EnumSet<CanonicalizerPhase.CanonicalizerFeature> features, CanonicalizerPhase.CustomSimplification customSimplification, StructuredGraph graph, CoreProviders context, Graph.Mark newNodesMark) {
        this(features, customSimplification, graph, context, graph.getNewNodes(newNodesMark));
    }

    IncrementalCanonicalizerPhase(EnumSet<CanonicalizerPhase.CanonicalizerFeature> features, CanonicalizerPhase.CustomSimplification customSimplification, StructuredGraph graph, CoreProviders context, Iterable<? extends Node> workingSet) {
        super(customSimplification, features);
        this.initialGraph = graph;
        NodeWorkList workList = graph.createIterativeNodeWorkList(false, 10);
        workList.addAll(workingSet);
        this.theTool = new CanonicalizerPhase.Tool(graph, context, workList);
    }

    @Override
    public boolean checkContract() {
        return false;
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        GraalError.guarantee(!this.theTool.finalCanonicalization(), "Final canonicalization must not be incremental");
        return super.notApplicableTo(graphState);
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        GraalError.guarantee(graph == this.initialGraph, "Canonicalizer instances contain graph-specific state, they must be applied to the graph used during construction.");
        this.processWorkSet(graph, this.theTool);
    }

    public static class Apply
    implements BasePhase.ApplyScope {
        private final EconomicSetNodeEventListener listener;
        private final StructuredGraph graph;
        private final CoreProviders context;
        private final CanonicalizerPhase canonicalizer;
        private final Graph.NodeEventScope scope;

        public Apply(StructuredGraph graph, CoreProviders context, CanonicalizerPhase canonicalizer) {
            assert (canonicalizer != null);
            this.graph = graph;
            this.context = context;
            this.canonicalizer = canonicalizer;
            this.listener = new EconomicSetNodeEventListener();
            this.scope = graph.trackNodeEvents(this.listener);
            if (graph.getDebug().isDumpEnabled(3) && !graph.getDebug().isDumpEnabled(4)) {
                graph.getDebug().dump(3, (Object)graph, "Before subphase %s", canonicalizer.getName());
            }
        }

        @Override
        public void close(Throwable throwable) {
            this.scope.close();
            if (throwable == null && !this.listener.getNodes().isEmpty()) {
                this.canonicalizer.applyIncremental(this.graph, this.context, (Iterable<? extends Node>)this.listener.getNodes());
            }
        }
    }
}

