/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.Optional;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.GuardNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.extended.AnchoringNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.extended.OSRMonitorEnterNode;
import jdk.graal.compiler.nodes.java.AccessMonitorNode;
import jdk.graal.compiler.nodes.java.MonitorEnterNode;
import jdk.graal.compiler.nodes.java.MonitorExitNode;
import jdk.graal.compiler.nodes.java.MonitorIdNode;
import jdk.graal.compiler.nodes.spi.ValueProxy;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.Phase;

public class LockEliminationPhase
extends Phase {
    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.when(graphState.isAfterStage(GraphState.StageFlag.FLOATING_READS) && graphState.isBeforeStage(GraphState.StageFlag.FIXED_READS), "This phase must not be applied while reads are floating");
    }

    @Override
    protected void run(StructuredGraph graph) {
        ControlFlowGraph cfg = ControlFlowGraph.newBuilder(graph).connectBlocks(true).computeLoops(true).computeDominators(true).computeFrequency(true).build();
        for (MonitorExitNode monitorExitNode : graph.getNodes(MonitorExitNode.TYPE)) {
            MonitorIdNode exitId;
            FixedNode next = monitorExitNode.next();
            if (!(next instanceof MonitorEnterNode)) continue;
            assert (!(next instanceof OSRMonitorEnterNode)) : Assertions.errorMessageContext("next", next);
            AccessMonitorNode monitorEnterNode = (AccessMonitorNode)next;
            if (!LockEliminationPhase.isCompatibleLock(monitorEnterNode, monitorExitNode, true, cfg)) continue;
            MonitorIdNode enterId = monitorEnterNode.getMonitorId();
            if (enterId != (exitId = monitorExitNode.getMonitorId())) {
                enterId.replaceAndDelete(exitId);
            }
            GraphUtil.removeFixedWithUnusedInputs(monitorEnterNode);
            GraphUtil.removeFixedWithUnusedInputs(monitorExitNode);
            graph.getOptimizationLog().report(this.getClass(), "LockCoarsening", monitorEnterNode);
        }
    }

    public static boolean isCompatibleLock(AccessMonitorNode a, AccessMonitorNode b, boolean aDominatesB, ControlFlowGraph cfg) {
        ValueNode objectB;
        ValueNode objectA = GraphUtil.unproxify(a.object());
        if (objectA == (objectB = GraphUtil.unproxify(b.object())) && a.getMonitorId().getLockDepth() == b.getMonitorId().getLockDepth() && a.getMonitorId().isMultipleEntry() == b.getMonitorId().isMultipleEntry()) {
            HIRBlock lowestBlockA = LockEliminationPhase.lowestGuardedInputBlock(b, cfg);
            HIRBlock lowestBlockB = null;
            if (lowestBlockA != null) {
                lowestBlockB = LockEliminationPhase.lowestGuardedInputBlock(b, cfg);
            }
            if (lowestBlockA == null || lowestBlockB == null) {
                return true;
            }
            if (aDominatesB) {
                return lowestBlockA.dominates(lowestBlockB);
            }
            return lowestBlockB.dominates(lowestBlockA);
        }
        return false;
    }

    public static HIRBlock lowestGuardedInputBlock(AccessMonitorNode monitorNode, ControlFlowGraph cfg) {
        return LockEliminationPhase.lowestGuardedInputBlock(LockEliminationPhase.unproxifyHighestGuard(monitorNode.object()), LockEliminationPhase.unproxifyHighestGuard(monitorNode.getObjectData()), cfg);
    }

    public static HIRBlock lowestGuardedInputBlock(GuardingNode g1, GuardingNode g2, ControlFlowGraph cfg) {
        HIRBlock b1 = LockEliminationPhase.getGuardingBlock(g1, cfg);
        HIRBlock b2 = LockEliminationPhase.getGuardingBlock(g2, cfg);
        if (b1 == null) {
            return b2;
        }
        if (b2 == null) {
            return b1;
        }
        if (b1.dominates(b2)) {
            return b2;
        }
        return b1;
    }

    public static HIRBlock getGuardingBlock(GuardingNode g1, ControlFlowGraph cfg) {
        HIRBlock b1 = null;
        if (g1 != null) {
            AnchoringNode a;
            if (g1 instanceof FixedNode) {
                b1 = cfg.blockFor((Node)((Object)g1));
            } else if (g1 instanceof GuardNode && (a = ((GuardNode)g1).getAnchor()) instanceof FixedNode) {
                b1 = cfg.blockFor((FixedNode)((Object)a));
            }
        }
        return b1;
    }

    public static GuardingNode unproxifyHighestGuard(ValueNode value) {
        if (value != null) {
            ValueNode result = value;
            GuardingNode highestGuard = null;
            while (result instanceof ValueProxy) {
                GuardingNode curGuard = ((ValueProxy)((Object)result)).getGuard();
                if (curGuard != null) {
                    highestGuard = curGuard;
                }
                result = ((ValueProxy)((Object)result)).getOriginalNode();
            }
            return highestGuard;
        }
        return null;
    }
}

