/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.Optional;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopEndNode;
import jdk.graal.compiler.nodes.SafepointNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.tiers.MidTierContext;

public class LoopSafepointInsertionPhase
extends BasePhase<MidTierContext> {
    @Override
    public boolean checkContract() {
        return false;
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(BasePhase.NotApplicable.ifApplied(this, GraphState.StageFlag.SAFEPOINTS_INSERTION, graphState), BasePhase.NotApplicable.unlessRunBefore(this, GraphState.StageFlag.FSA, graphState));
    }

    @Override
    protected void run(StructuredGraph graph, MidTierContext context) {
        if (GraalOptions.GenLoopSafepoints.getValue(graph.getOptions()).booleanValue()) {
            for (LoopBeginNode loopBeginNode : graph.getNodes(LoopBeginNode.TYPE)) {
                for (LoopEndNode loopEndNode : loopBeginNode.loopEnds()) {
                    if (!loopEndNode.canSafepoint()) continue;
                    DebugCloseable s = loopEndNode.withNodeSourcePosition();
                    try {
                        SafepointNode safepointNode = graph.add(new SafepointNode());
                        graph.addBeforeFixed(loopEndNode, safepointNode);
                    }
                    finally {
                        if (s == null) continue;
                        s.close();
                    }
                }
            }
        }
    }

    @Override
    public void updateGraphState(GraphState graphState) {
        super.updateGraphState(graphState);
        graphState.setAfterStage(GraphState.StageFlag.SAFEPOINTS_INSERTION);
    }
}

