/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import jdk.graal.compiler.core.common.cfg.Loop;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.ReturnNode;
import jdk.graal.compiler.nodes.SafepointNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.VirtualState;
import jdk.graal.compiler.nodes.calc.BinaryNode;
import jdk.graal.compiler.nodes.calc.ConvertNode;
import jdk.graal.compiler.nodes.calc.FloatDivNode;
import jdk.graal.compiler.nodes.calc.IntegerDivRemNode;
import jdk.graal.compiler.nodes.calc.MulNode;
import jdk.graal.compiler.nodes.calc.NotNode;
import jdk.graal.compiler.nodes.calc.ReinterpretNode;
import jdk.graal.compiler.nodes.calc.RemNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.debug.DynamicCounterNode;
import jdk.graal.compiler.nodes.extended.SwitchNode;
import jdk.graal.compiler.nodes.java.AbstractNewObjectNode;
import jdk.graal.compiler.nodes.java.AccessMonitorNode;
import jdk.graal.compiler.nodes.java.MonitorIdNode;
import jdk.graal.compiler.nodes.memory.FloatingReadNode;
import jdk.graal.compiler.nodes.spi.ValueProxy;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.Phase;
import jdk.graal.compiler.phases.schedule.SchedulePhase;
import jdk.vm.ci.services.Services;

public class ProfileCompiledMethodsPhase
extends Phase {
    private static final String GROUP_NAME = "~profiled weight";
    private static final String GROUP_NAME_WITHOUT = "~profiled weight (invoke-free sections)";
    private static final String GROUP_NAME_INVOKES = "~profiled invokes";
    private static final boolean WITH_SECTION_HEADER = Boolean.parseBoolean(Services.getSavedProperty((String)"ProfileCompiledMethodsPhase.WITH_SECTION_HEADER", (String)"false"));
    private static final boolean WITH_INVOKE_FREE_SECTIONS = Boolean.parseBoolean(Services.getSavedProperty((String)"ProfileCompiledMethodsPhase.WITH_FREE_SECTIONS", (String)"false"));
    private static final boolean WITH_INVOKES = Boolean.parseBoolean(Services.getSavedProperty((String)"ProfileCompiledMethodsPhase.WITH_INVOKES", (String)"true"));

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    @Override
    protected void run(StructuredGraph graph) {
        SchedulePhase.runWithoutContextOptimizations(graph, SchedulePhase.getDefaultStrategy(graph.getOptions()), true);
        ControlFlowGraph cfg = graph.getLastSchedule().getCFG();
        for (Loop loop : cfg.getLoops()) {
            double loopProbability = cfg.blockFor(((HIRBlock)loop.getHeader()).getBeginNode()).getRelativeFrequency();
            if (!(loopProbability > 4.656612875245797E-10)) continue;
            ProfileCompiledMethodsPhase.addSectionCounters(((HIRBlock)loop.getHeader()).getBeginNode(), loop.getBlocks(), loop.getChildren(), graph.getLastSchedule(), cfg);
        }
        FixedWithNextNode current = graph.start();
        while (current.next() instanceof FixedWithNextNode) {
            current = (FixedWithNextNode)current.next();
        }
        ProfileCompiledMethodsPhase.addSectionCounters(current, Arrays.asList(cfg.getBlocks()), cfg.getLoops(), graph.getLastSchedule(), cfg);
        if (WITH_INVOKES) {
            for (Node node : graph.getNodes()) {
                if (!(node instanceof Invoke)) continue;
                Invoke invoke = (Invoke)((Object)node);
                DynamicCounterNode.addCounterBefore(GROUP_NAME_INVOKES, invoke.callTarget().targetName(), 1L, true, invoke.asFixedNode());
            }
        }
    }

    private static void addSectionCounters(FixedWithNextNode start, Collection<HIRBlock> sectionBlocks, Collection<Loop<HIRBlock>> childLoops, StructuredGraph.ScheduleResult schedule, ControlFlowGraph cfg) {
        HashSet<HIRBlock> blocks = new HashSet<HIRBlock>(sectionBlocks);
        for (Loop<HIRBlock> loop : childLoops) {
            blocks.removeAll(loop.getBlocks());
        }
        long increment = DynamicCounterNode.clampIncrement((long)(ProfileCompiledMethodsPhase.getSectionWeight(schedule, blocks) / cfg.blockFor(start).getRelativeFrequency()));
        DynamicCounterNode.addCounterBefore(GROUP_NAME, ProfileCompiledMethodsPhase.sectionHead(start), increment, true, start.next());
        if (WITH_INVOKE_FREE_SECTIONS && !ProfileCompiledMethodsPhase.hasInvoke(blocks)) {
            DynamicCounterNode.addCounterBefore(GROUP_NAME_WITHOUT, ProfileCompiledMethodsPhase.sectionHead(start), increment, true, start.next());
        }
    }

    private static String sectionHead(Node node) {
        if (WITH_SECTION_HEADER) {
            return node.toString();
        }
        return "";
    }

    private static double getSectionWeight(StructuredGraph.ScheduleResult schedule, Collection<HIRBlock> blocks) {
        double count = 0.0;
        for (HIRBlock block : blocks) {
            double blockProbability = block.getRelativeFrequency();
            for (Node node : schedule.getBlockToNodesMap().get(block)) {
                count += blockProbability * ProfileCompiledMethodsPhase.getNodeWeight(node);
            }
        }
        return count;
    }

    private static double getNodeWeight(Node node) {
        if (node instanceof AbstractMergeNode) {
            return ((AbstractMergeNode)node).phiPredecessorCount();
        }
        if (node instanceof AbstractBeginNode || node instanceof AbstractEndNode || node instanceof MonitorIdNode || node instanceof ConstantNode || node instanceof ParameterNode || node instanceof CallTargetNode || node instanceof ValueProxy || node instanceof VirtualObjectNode || node instanceof ReinterpretNode) {
            return 0.0;
        }
        if (node instanceof AccessMonitorNode) {
            return 10.0;
        }
        if (node instanceof FloatingReadNode) {
            return 2.0;
        }
        if (node instanceof LogicNode || node instanceof ConvertNode || node instanceof NotNode) {
            return 1.0;
        }
        if (node instanceof IntegerDivRemNode || node instanceof FloatDivNode || node instanceof RemNode) {
            return 10.0;
        }
        if (node instanceof MulNode) {
            return 3.0;
        }
        if (node instanceof Invoke) {
            return 5.0;
        }
        if (node instanceof IfNode || node instanceof SafepointNode || node instanceof BinaryNode) {
            return 1.0;
        }
        if (node instanceof SwitchNode) {
            return node.successors().count();
        }
        if (node instanceof ReturnNode || node instanceof UnwindNode || node instanceof DeoptimizeNode) {
            return node.successors().count();
        }
        if (node instanceof AbstractNewObjectNode) {
            return 10.0;
        }
        if (node instanceof VirtualState) {
            return 0.0;
        }
        return 2.0;
    }

    private static boolean hasInvoke(Collection<HIRBlock> blocks) {
        boolean hasInvoke = false;
        for (HIRBlock block : blocks) {
            for (FixedNode fixed : block.getNodes()) {
                if (!(fixed instanceof Invoke)) continue;
                hasInvoke = true;
            }
        }
        return hasInvoke;
    }

    @Override
    public boolean checkContract() {
        return false;
    }
}

