/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.EnumSet;
import java.util.Optional;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeBitMap;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.LeftShiftNode;
import jdk.graal.compiler.nodes.calc.MulNode;
import jdk.graal.compiler.nodes.calc.SubNode;
import jdk.graal.compiler.nodes.loop.LoopEx;
import jdk.graal.compiler.nodes.loop.LoopsData;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.util.EconomicSetNodeEventListener;
import jdk.vm.ci.meta.PrimitiveConstant;

public class ReassociationPhase
extends BasePhase<CoreProviders> {
    private final CanonicalizerPhase canonicalizer;

    public ReassociationPhase(CanonicalizerPhase canonicalizer) {
        this.canonicalizer = canonicalizer;
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return this.canonicalizer.notApplicableTo(graphState);
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        EconomicSetNodeEventListener changedNodes = new EconomicSetNodeEventListener(EnumSet.of(Graph.NodeEvent.NODE_ADDED));
        try (Graph.NodeEventScope news = graph.trackNodeEvents(changedNodes);){
            ReassociationPhase.prepareGraphForReassociation(graph);
            ReassociationPhase.reassociateConstants(graph, context);
            ReassociationPhase.reassociateInvariants(graph, context);
        }
        this.canonicalizer.applyIncremental(graph, context, (Iterable<? extends Node>)changedNodes.getNodes());
    }

    private static void reassociateInvariants(StructuredGraph graph, CoreProviders context) {
        DebugContext debug = graph.getDebug();
        LoopsData loopsData = context.getLoopsDataProvider().getLoopsData(graph);
        int iterations = 0;
        try (DebugContext.Scope s = debug.scope("ReassociateInvariants");){
            boolean changed = true;
            while (changed && iterations < 32) {
                changed = false;
                for (LoopEx loop : loopsData.loops()) {
                    changed |= loop.reassociateInvariants();
                }
                loopsData.deleteUnusedNodes();
                debug.dump(5, (Object)graph, "Reassociation: after iteration %d", ++iterations);
            }
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
    }

    private static void reassociateConstants(StructuredGraph graph, CoreProviders context) {
        LoopsData loopsData = context.getLoopsDataProvider().getLoopsData(graph);
        NodeBitMap loopNodes = graph.createNodeBitMap();
        for (LoopEx loop : loopsData.loops()) {
            loopNodes.union(loop.whole().nodes());
        }
        DebugContext debug = graph.getDebug();
        try (DebugContext.Scope s = debug.scope("ReassociateConstants");){
            for (BinaryArithmeticNode binary : graph.getNodes().filter(BinaryArithmeticNode.class)) {
                ValueNode result;
                if (!binary.mayReassociate() || !loopNodes.isNew(binary) && loopNodes.contains(binary) || (result = BinaryArithmeticNode.reassociateUnmatchedValues(binary, ValueNode.isConstantPredicate(), NodeView.DEFAULT)) == binary) continue;
                if (!result.isAlive()) {
                    assert (!result.isDeleted());
                    result = graph.addOrUniqueWithInputs(result);
                }
                binary.replaceAtUsages(result);
                graph.getOptimizationLog().report(ReassociationPhase.class, "ConstantReassociation", binary);
                GraphUtil.killWithUnusedFloatingInputs(binary);
            }
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
    }

    private static void prepareGraphForReassociation(StructuredGraph graph) {
        DebugContext debug = graph.getDebug();
        EconomicSetNodeEventListener nev = new EconomicSetNodeEventListener(EnumSet.of(Graph.NodeEvent.NODE_ADDED));
        try (Graph.NodeEventScope news = graph.trackNodeEvents(nev);){
            for (LeftShiftNode l : graph.getNodes().filter(LeftShiftNode.class)) {
                if (!l.tryReplaceWithMulNode()) continue;
                graph.getOptimizationLog().withLazyProperty("replacedNodeClass", () -> l.getNodeClass().shortName()).report(ReassociationPhase.class, "ArithmeticWithMulReplacement", l);
            }
        }
        debug.dump(5, graph, "Reassociation: after creating mul nodes from shifts");
        for (Node newNode : nev.getNodes()) {
            if (!(newNode instanceof MulNode)) continue;
            assert (((MulNode)newNode).getY().isConstant());
            MulNode mul = (MulNode)newNode;
            for (Node usage : newNode.usages()) {
                boolean replaced = false;
                if (usage instanceof AddNode) {
                    if (((BinaryArithmeticNode)usage).getX() == mul.getX() && ((BinaryArithmeticNode)usage).getY() == mul || ((BinaryArithmeticNode)usage).getY() == mul.getX() && ((BinaryArithmeticNode)usage).getX() == mul) {
                        i = ((PrimitiveConstant)mul.getY().asConstant()).asLong();
                        newMul = graph.addOrUnique(new MulNode(mul.getX(), ConstantNode.forIntegerStamp(mul.getY().stamp(NodeView.DEFAULT), i + 1L, graph)));
                        usage.replaceAtUsages(newMul);
                        replaced = true;
                    }
                } else if (usage instanceof SubNode && ((BinaryArithmeticNode)usage).getX() == mul && ((BinaryArithmeticNode)usage).getY() == mul.getX()) {
                    i = ((PrimitiveConstant)mul.getY().asConstant()).asLong();
                    newMul = graph.addOrUnique(new MulNode(mul.getX(), ConstantNode.forIntegerStamp(mul.getY().stamp(NodeView.DEFAULT), i - 1L, graph)));
                    usage.replaceAtUsages(newMul);
                    replaced = true;
                }
                if (!replaced) continue;
                graph.getOptimizationLog().withLazyProperty("replacedNodeClass", () -> usage.getNodeClass().shortName()).report(ReassociationPhase.class, "ArithmeticWithMulReplacement", usage);
            }
        }
        debug.dump(5, graph, "Reassociation: after creating mul from add/sub");
    }

    @Override
    public float codeSizeIncrease() {
        return 2.0f;
    }
}

