/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common.inlining.info;

import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.inlining.InliningUtil;
import jdk.graal.compiler.phases.common.inlining.info.InlineInfo;
import jdk.graal.compiler.phases.common.inlining.info.elem.Inlineable;
import jdk.graal.compiler.phases.common.inlining.info.elem.InlineableGraph;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicSet;

public abstract class AbstractInlineInfo
implements InlineInfo {
    protected final Invoke invoke;

    public AbstractInlineInfo(Invoke invoke) {
        this.invoke = invoke;
    }

    @Override
    public StructuredGraph graph() {
        return this.invoke.asNode().graph();
    }

    @Override
    public Invoke invoke() {
        return this.invoke;
    }

    protected static EconomicSet<Node> inline(Invoke invoke, ResolvedJavaMethod concrete, Inlineable inlineable, boolean receiverNullCheck, String reason) {
        assert (inlineable instanceof InlineableGraph) : inlineable;
        StructuredGraph calleeGraph = ((InlineableGraph)inlineable).getGraph();
        return InliningUtil.inlineForCanonicalization(invoke, calleeGraph, receiverNullCheck, concrete, reason, "InliningPhase");
    }

    @Override
    public final void populateInlinableElements(HighTierContext context, StructuredGraph caller, CanonicalizerPhase canonicalizer, OptionValues options) {
        for (int i = 0; i < this.numberOfMethods(); ++i) {
            Inlineable elem = Inlineable.getInlineableElement(this.methodAt(i), this.invoke, context, canonicalizer, caller.trackNodeSourcePosition());
            this.setInlinableElement(i, elem);
        }
    }

    @Override
    public final int determineNodeCount() {
        int nodes = 0;
        for (int i = 0; i < this.numberOfMethods(); ++i) {
            Inlineable elem = this.inlineableElementAt(i);
            if (elem == null) continue;
            nodes += elem.getNodeCount();
        }
        return nodes;
    }
}

