/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common.inlining.info;

import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.common.inlining.info.AbstractInlineInfo;
import jdk.graal.compiler.phases.common.inlining.info.elem.Inlineable;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicSet;

public class ExactInlineInfo
extends AbstractInlineInfo {
    protected final ResolvedJavaMethod concrete;
    private Inlineable inlineableElement;

    public ExactInlineInfo(Invoke invoke, ResolvedJavaMethod concrete) {
        super(invoke);
        this.concrete = concrete;
        assert (concrete != null);
    }

    @Override
    public EconomicSet<Node> inline(CoreProviders providers, String reason) {
        return ExactInlineInfo.inline(this.invoke, this.concrete, this.inlineableElement, true, reason);
    }

    @Override
    public void tryToDevirtualizeInvoke(Providers providers) {
    }

    @Override
    public int numberOfMethods() {
        return 1;
    }

    @Override
    public ResolvedJavaMethod methodAt(int index) {
        assert (index == 0) : index;
        return this.concrete;
    }

    @Override
    public double probabilityAt(int index) {
        assert (index == 0) : index;
        return 1.0;
    }

    @Override
    public double relevanceAt(int index) {
        assert (index == 0) : index;
        return 1.0;
    }

    public String toString() {
        return "exact " + this.concrete.format("%H.%n(%p):%r");
    }

    @Override
    public Inlineable inlineableElementAt(int index) {
        assert (index == 0) : index;
        return this.inlineableElement;
    }

    @Override
    public void setInlinableElement(int index, Inlineable inlineableElement) {
        assert (index == 0) : index;
        this.inlineableElement = inlineableElement;
    }

    @Override
    public boolean shouldInline() {
        return this.concrete.shouldBeInlined();
    }
}

