/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common.inlining.policy;

import java.util.Map;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.debug.CounterKey;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.spi.Replacements;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.common.inlining.InliningUtil;
import jdk.graal.compiler.phases.common.inlining.info.InlineInfo;
import jdk.graal.compiler.phases.common.inlining.policy.AbstractInliningPolicy;
import jdk.graal.compiler.phases.common.inlining.policy.InliningPolicy;
import jdk.graal.compiler.phases.common.inlining.walker.MethodInvocation;

public class GreedyInliningPolicy
extends AbstractInliningPolicy {
    private static final CounterKey inliningStoppedByMaxDesiredSizeCounter = DebugContext.counter("InliningStoppedByMaxDesiredSize");

    public GreedyInliningPolicy(Map<Invoke, Double> hints) {
        super(hints);
    }

    @Override
    public boolean continueInlining(StructuredGraph currentGraph) {
        if (InliningUtil.getNodeCount(currentGraph) >= GraalOptions.MaximumDesiredSize.getValue(currentGraph.getOptions())) {
            DebugContext debug = currentGraph.getDebug();
            InliningUtil.logInliningDecision(debug, "inlining is cut off by MaximumDesiredSize", new Object[0]);
            inliningStoppedByMaxDesiredSizeCounter.increment(debug);
            return false;
        }
        return true;
    }

    protected static boolean hasSubstitution(Replacements replacements, InlineInfo info) {
        for (int i = 0; i < info.numberOfMethods(); ++i) {
            if (!replacements.hasSubstitution(info.methodAt(i), info.graph().getOptions())) continue;
            return true;
        }
        return false;
    }

    @Override
    public InliningPolicy.Decision isWorthInlining(Replacements replacements, MethodInvocation invocation, InlineInfo calleeInfo, int inliningDepth, boolean fullyProcessed) {
        OptionValues options = calleeInfo.graph().getOptions();
        boolean isTracing = GraalOptions.TraceInlining.getValue(options) != false || calleeInfo.graph().getDebug().hasCompilationListener();
        InlineInfo info = invocation.callee();
        double probability = invocation.probability();
        double relevance = invocation.relevance();
        if (GraalOptions.InlineEverything.getValue(options).booleanValue()) {
            InliningUtil.traceInlinedMethod(info, inliningDepth, fullyProcessed, "inline everything", new Object[0]);
            return InliningPolicy.Decision.YES.withReason(isTracing, "inline everything");
        }
        if (this.isIntrinsic(replacements, info)) {
            InliningUtil.traceInlinedMethod(info, inliningDepth, fullyProcessed, "intrinsic", new Object[0]);
            return InliningPolicy.Decision.YES.withReason(isTracing, "intrinsic");
        }
        if (info.shouldInline()) {
            InliningUtil.traceInlinedMethod(info, inliningDepth, fullyProcessed, "forced inlining", new Object[0]);
            return InliningPolicy.Decision.YES.withReason(isTracing, "forced inlining");
        }
        double inliningBonus = this.getInliningBonus(info);
        int nodes = info.determineNodeCount();
        int lowLevelGraphSize = this.previousLowLevelGraphSize(info);
        if (GraalOptions.SmallCompiledLowLevelGraphSize.getValue(options) > 0 && (double)lowLevelGraphSize > (double)GraalOptions.SmallCompiledLowLevelGraphSize.getValue(options).intValue() * inliningBonus && !GreedyInliningPolicy.hasSubstitution(replacements, info)) {
            InliningUtil.traceNotInlinedMethod(info, inliningDepth, "too large previous low-level graph (low-level-nodes: %d, relevance=%f, probability=%f, bonus=%f, nodes=%d)", lowLevelGraphSize, relevance, probability, inliningBonus, nodes);
            return InliningPolicy.Decision.NO.withReason(isTracing, "too large previous low-level graph (low-level-nodes: %d, relevance=%f, probability=%f, bonus=%f, nodes=%d)", lowLevelGraphSize, relevance, probability, inliningBonus, nodes);
        }
        if ((double)nodes < (double)GraalOptions.TrivialInliningSize.getValue(options).intValue() * inliningBonus) {
            InliningUtil.traceInlinedMethod(info, inliningDepth, fullyProcessed, "trivial (relevance=%f, probability=%f, bonus=%f, nodes=%d)", relevance, probability, inliningBonus, nodes);
            return InliningPolicy.Decision.YES.withReason(isTracing, "trivial (relevance=%f, probability=%f, bonus=%f, nodes=%d)", relevance, probability, inliningBonus, nodes);
        }
        double invokes = this.determineInvokeProbability(info);
        if (GraalOptions.LimitInlinedInvokes.getValue(options) > 0.0 && fullyProcessed && invokes > GraalOptions.LimitInlinedInvokes.getValue(options) * inliningBonus) {
            InliningUtil.traceNotInlinedMethod(info, inliningDepth, "callee invoke probability is too high (invokeP=%f, relevance=%f, probability=%f, bonus=%f, nodes=%d)", invokes, relevance, probability, inliningBonus, nodes);
            return InliningPolicy.Decision.NO.withReason(isTracing, "callee invoke probability is too high (invokeP=%f, relevance=%f, probability=%f, bonus=%f, nodes=%d)", invokes, relevance, probability, inliningBonus, nodes);
        }
        double maximumNodes = this.computeMaximumSize(relevance, (int)((double)GraalOptions.MaximumInliningSize.getValue(options).intValue() * inliningBonus));
        if ((double)nodes <= maximumNodes) {
            InliningUtil.traceInlinedMethod(info, inliningDepth, fullyProcessed, "relevance-based (relevance=%f, probability=%f, bonus=%f, nodes=%d <= %f)", relevance, probability, inliningBonus, nodes, maximumNodes);
            return InliningPolicy.Decision.YES.withReason(isTracing, "relevance-based (relevance=%f, probability=%f, bonus=%f, nodes=%d <= %f)", relevance, probability, inliningBonus, nodes, maximumNodes);
        }
        InliningUtil.traceNotInlinedMethod(info, inliningDepth, "relevance-based (relevance=%f, probability=%f, bonus=%f, nodes=%d > %f)", relevance, probability, inliningBonus, nodes, maximumNodes);
        return InliningPolicy.Decision.NO.withReason(isTracing, "relevance-based (relevance=%f, probability=%f, bonus=%f, nodes=%d > %f)", relevance, probability, inliningBonus, nodes, maximumNodes);
    }
}

