/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common.inlining.policy;

import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.PermanentBailoutException;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.spi.Replacements;
import jdk.graal.compiler.phases.common.inlining.InliningUtil;
import jdk.graal.compiler.phases.common.inlining.info.InlineInfo;
import jdk.graal.compiler.phases.common.inlining.policy.InliningPolicy;
import jdk.graal.compiler.phases.common.inlining.walker.MethodInvocation;

public class InlineEverythingPolicy
implements InliningPolicy {
    @Override
    public boolean continueInlining(StructuredGraph graph) {
        if (InliningUtil.getNodeCount(graph) >= GraalOptions.MaximumDesiredSize.getValue(graph.getOptions())) {
            throw new PermanentBailoutException("Inline all calls failed. The resulting graph is too large.");
        }
        return true;
    }

    @Override
    public InliningPolicy.Decision isWorthInlining(Replacements replacements, MethodInvocation invocation, InlineInfo calleeInfo, int inliningDepth, boolean fullyProcessed) {
        boolean isTracing = GraalOptions.TraceInlining.getValue(calleeInfo.graph().getOptions()) != false || calleeInfo.graph().getDebug().hasCompilationListener();
        return InliningPolicy.Decision.YES.withReason(isTracing, "inline everything");
    }
}

