/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common.inlining.policy;

import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.spi.Replacements;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.common.inlining.info.InlineInfo;
import jdk.graal.compiler.phases.common.inlining.policy.InlineEverythingPolicy;
import jdk.graal.compiler.phases.common.inlining.policy.InliningPolicy;
import jdk.graal.compiler.phases.common.inlining.walker.MethodInvocation;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public final class InlineMethodSubstitutionsPolicy
extends InlineEverythingPolicy {
    @Override
    public InliningPolicy.Decision isWorthInlining(Replacements replacements, MethodInvocation invocation, InlineInfo calleeInfo, int inliningDepth, boolean fullyProcessed) {
        ResolvedJavaMethod calleeMethod;
        OptionValues options = calleeInfo.graph().getOptions();
        boolean isTracing = GraalOptions.TraceInlining.getValue(options) != false || calleeInfo.graph().getDebug().hasCompilationListener();
        CallTargetNode callTarget = invocation.callee().invoke().callTarget();
        if (callTarget instanceof MethodCallTargetNode && replacements.hasSubstitution(calleeMethod = callTarget.targetMethod(), options)) {
            return InliningPolicy.Decision.YES.withReason(isTracing, "has a method subtitution");
        }
        return InliningPolicy.Decision.NO.withReason(isTracing, "does not have a method substitution");
    }
}

