/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common.inlining.walker;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.CounterKey;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.AbstractNewObjectNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.virtual.AllocatedObjectNode;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.inlining.InliningUtil;
import jdk.graal.compiler.phases.common.inlining.info.AssumptionInlineInfo;
import jdk.graal.compiler.phases.common.inlining.info.ExactInlineInfo;
import jdk.graal.compiler.phases.common.inlining.info.InlineInfo;
import jdk.graal.compiler.phases.common.inlining.info.MultiTypeGuardInlineInfo;
import jdk.graal.compiler.phases.common.inlining.info.TypeGuardInlineInfo;
import jdk.graal.compiler.phases.common.inlining.info.elem.Inlineable;
import jdk.graal.compiler.phases.common.inlining.info.elem.InlineableGraph;
import jdk.graal.compiler.phases.common.inlining.policy.InliningPolicy;
import jdk.graal.compiler.phases.common.inlining.walker.CallsiteHolder;
import jdk.graal.compiler.phases.common.inlining.walker.CallsiteHolderExplorable;
import jdk.graal.compiler.phases.common.inlining.walker.MethodInvocation;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;

public class InliningData {
    private static final CounterKey counterInliningPerformed = DebugContext.counter("InliningPerformed");
    private static final CounterKey counterInliningRuns = DebugContext.counter("InliningRuns");
    private static final CounterKey counterInliningConsidered = DebugContext.counter("InliningConsidered");
    private final ArrayDeque<CallsiteHolder> graphQueue = new ArrayDeque();
    private final ArrayDeque<MethodInvocation> invocationQueue = new ArrayDeque();
    private final HighTierContext context;
    private final int maxMethodPerInlining;
    private final CanonicalizerPhase canonicalizer;
    private final InliningPolicy inliningPolicy;
    private final StructuredGraph rootGraph;
    private final DebugContext debug;
    private int maxGraphs;
    private static final Object[] NO_CONTEXT = new Object[0];

    public InliningData(StructuredGraph rootGraph, HighTierContext context, int maxMethodPerInlining, CanonicalizerPhase canonicalizer, InliningPolicy inliningPolicy, LinkedList<Invoke> rootInvokes) {
        assert (rootGraph != null);
        this.context = context;
        this.maxMethodPerInlining = maxMethodPerInlining;
        this.canonicalizer = canonicalizer;
        this.inliningPolicy = inliningPolicy;
        this.maxGraphs = 1;
        this.rootGraph = rootGraph;
        this.debug = rootGraph.getDebug();
        this.invocationQueue.push(new MethodInvocation(null, 1.0, 1.0, null));
        this.graphQueue.push(new CallsiteHolderExplorable(rootGraph, 1.0, 1.0, null, rootInvokes));
    }

    public static boolean isFreshInstantiation(ValueNode arg) {
        return arg instanceof AbstractNewObjectNode || arg instanceof AllocatedObjectNode || arg instanceof VirtualObjectNode;
    }

    private String checkTargetConditionsHelper(ResolvedJavaMethod method, Invoke invoke) {
        OptionValues options = this.rootGraph.getOptions();
        if (method == null) {
            return "the method is not resolved";
        }
        if (method.isNative() && (!GraalOptions.Intrinsify.getValue(options).booleanValue() || this.context.getReplacements().getInlineSubstitution(method, invoke.bci(), invoke.getInlineControl(), this.rootGraph.trackNodeSourcePosition(), null, this.rootGraph.allowAssumptions(), options) == null)) {
            return "it is a non-intrinsic native method";
        }
        if (method.isAbstract()) {
            return "it is an abstract method";
        }
        if (!method.getDeclaringClass().isInitialized()) {
            return "the method's class is not initialized";
        }
        if (!method.canBeInlined()) {
            return "it is marked non-inlinable";
        }
        if (this.countRecursiveInlining(method) > GraalOptions.MaximumRecursiveInlining.getValue(options)) {
            return "it exceeds the maximum recursive inlining depth";
        }
        if (new OptimisticOptimizations(this.rootGraph.getProfilingInfo(method), options).lessOptimisticThan(this.context.getOptimisticOptimizations())) {
            return "the callee uses less optimistic optimizations than caller";
        }
        return null;
    }

    private boolean checkTargetConditions(Invoke invoke, ResolvedJavaMethod method) {
        String failureMessage = this.checkTargetConditionsHelper(method, invoke);
        if (failureMessage == null) {
            return true;
        }
        InliningUtil.traceNotInlinedMethod(invoke, this.inliningDepth(), method, failureMessage, new Object[0]);
        invoke.asNode().graph().notifyInliningDecision(invoke, false, "InliningPhase", null, null, null, invoke.getTargetMethod(), failureMessage, new Object[0]);
        return false;
    }

    private InlineInfo getInlineInfo(Invoke invoke) {
        ResolvedJavaMethod resolvedMethod;
        ResolvedJavaMethod resolvedMethod2;
        ResolvedJavaType receiverType;
        String failureMessage = InliningUtil.checkInvokeConditions(invoke);
        if (failureMessage != null) {
            InliningUtil.logNotInlinedMethod(invoke, failureMessage);
            return null;
        }
        MethodCallTargetNode callTarget = (MethodCallTargetNode)invoke.callTarget();
        ResolvedJavaMethod targetMethod = callTarget.targetMethod();
        CallTargetNode.InvokeKind invokeKind = callTarget.invokeKind();
        if (invokeKind == CallTargetNode.InvokeKind.Special || invokeKind == CallTargetNode.InvokeKind.Static || targetMethod.canBeStaticallyBound()) {
            return this.getExactInlineInfo(invoke, targetMethod);
        }
        assert (invokeKind.isIndirect());
        ResolvedJavaType holder = targetMethod.getDeclaringClass();
        if (!(callTarget.receiver().stamp(NodeView.DEFAULT) instanceof ObjectStamp)) {
            return null;
        }
        ObjectStamp receiverStamp = (ObjectStamp)callTarget.receiver().stamp(NodeView.DEFAULT);
        if (receiverStamp.alwaysNull()) {
            return null;
        }
        ResolvedJavaType contextType = invoke.getContextType();
        if (receiverStamp.type() != null && (receiverType = receiverStamp.type()) != null && holder.isAssignableFrom(receiverType)) {
            holder = receiverType;
            if (receiverStamp.isExactType()) {
                assert (targetMethod.getDeclaringClass().isAssignableFrom(holder)) : String.valueOf(holder) + " subtype of " + String.valueOf(targetMethod.getDeclaringClass()) + " for " + String.valueOf(targetMethod);
                resolvedMethod2 = holder.resolveConcreteMethod(targetMethod, contextType);
                if (resolvedMethod2 != null) {
                    return this.getExactInlineInfo(invoke, resolvedMethod2);
                }
            }
        }
        if (holder.isArray() && (resolvedMethod = holder.resolveConcreteMethod(targetMethod, contextType)) != null) {
            return this.getExactInlineInfo(invoke, resolvedMethod);
        }
        if (invokeKind != CallTargetNode.InvokeKind.Interface) {
            Assumptions.AssumptionResult leafConcreteSubtype = holder.findLeafConcreteSubtype();
            if (leafConcreteSubtype != null && (resolvedMethod2 = ((ResolvedJavaType)leafConcreteSubtype.getResult()).resolveConcreteMethod(targetMethod, contextType)) != null && leafConcreteSubtype.canRecordTo(callTarget.graph().getAssumptions())) {
                return this.getAssumptionInlineInfo(invoke, resolvedMethod2, leafConcreteSubtype);
            }
            Assumptions.AssumptionResult concrete = holder.findUniqueConcreteMethod(targetMethod);
            if (concrete != null && concrete.canRecordTo(callTarget.graph().getAssumptions())) {
                return this.getAssumptionInlineInfo(invoke, (ResolvedJavaMethod)concrete.getResult(), concrete);
            }
        }
        return this.getTypeCheckedInlineInfo(invoke, targetMethod);
    }

    private InlineInfo getTypeCheckedInlineInfo(Invoke invoke, ResolvedJavaMethod targetMethod) {
        StructuredGraph graph = invoke.asNode().graph();
        JavaTypeProfile typeProfile = ((MethodCallTargetNode)invoke.callTarget()).getTypeProfile();
        if (typeProfile == null) {
            InliningUtil.traceNotInlinedMethod(invoke, this.inliningDepth(), targetMethod, "no type profile exists", new Object[0]);
            graph.notifyInliningDecision(invoke, false, "InliningPhase", null, null, null, invoke.getTargetMethod(), "no type profile exists", new Object[0]);
            return null;
        }
        JavaTypeProfile.ProfiledType[] ptypes = typeProfile.getTypes();
        if (ptypes == null || ptypes.length <= 0) {
            InliningUtil.traceNotInlinedMethod(invoke, this.inliningDepth(), targetMethod, "no types in profile", new Object[0]);
            graph.notifyInliningDecision(invoke, false, "InliningPhase", null, null, null, invoke.getTargetMethod(), "no types in profile", new Object[0]);
            return null;
        }
        ResolvedJavaType contextType = invoke.getContextType();
        double notRecordedTypeProbability = typeProfile.getNotRecordedProbability();
        OptimisticOptimizations optimisticOpts = this.context.getOptimisticOptimizations();
        OptionValues options = invoke.asNode().getOptions();
        boolean speculationFailed = false;
        SpeculationLog speculationLog = graph.getSpeculationLog();
        SpeculationLog.Speculation speculation = SpeculationLog.NO_SPECULATION;
        if (speculationLog != null && notRecordedTypeProbability == 0.0) {
            SpeculationLog.SpeculationReason speculationReason = InliningUtil.createSpeculation(invoke, typeProfile);
            if (speculationLog.maySpeculate(speculationReason)) {
                speculation = speculationLog.speculate(speculationReason);
            } else {
                speculationFailed = true;
            }
        }
        if (ptypes.length == 1 && notRecordedTypeProbability == 0.0 && !speculationFailed) {
            if (!optimisticOpts.inlineMonomorphicCalls(options)) {
                InliningUtil.traceNotInlinedMethod(invoke, this.inliningDepth(), targetMethod, "inlining monomorphic calls is disabled", new Object[0]);
                graph.notifyInliningDecision(invoke, false, "InliningPhase", null, null, null, invoke.getTargetMethod(), "inlining monomorphic calls is disabled", new Object[0]);
                return null;
            }
            ResolvedJavaType type = ptypes[0].getType();
            assert (type.isArray() || type.isConcrete());
            ResolvedJavaMethod concrete = type.resolveConcreteMethod(targetMethod, contextType);
            if (!this.checkTargetConditions(invoke, concrete)) {
                return null;
            }
            return new TypeGuardInlineInfo(invoke, concrete, type, speculation);
        }
        invoke.setPolymorphic(true);
        if (!optimisticOpts.inlinePolymorphicCalls(options) && notRecordedTypeProbability == 0.0) {
            InliningUtil.traceNotInlinedMethod(invoke, this.inliningDepth(), targetMethod, "inlining polymorphic calls is disabled (%d types)", ptypes.length);
            graph.notifyInliningDecision(invoke, false, "InliningPhase", null, null, null, invoke.getTargetMethod(), "inlining polymorphic calls is disabled (%d types)", ptypes.length);
            return null;
        }
        if (!optimisticOpts.inlineMegamorphicCalls(options) && notRecordedTypeProbability > 0.0) {
            InliningUtil.traceNotInlinedMethod(invoke, this.inliningDepth(), targetMethod, "inlining megamorphic calls is disabled (%d types, %f %% not recorded types)", ptypes.length, notRecordedTypeProbability * 100.0);
            graph.notifyInliningDecision(invoke, false, "InliningPhase", null, null, null, invoke.getTargetMethod(), "inlining megamorphic calls is disabled (%d types, %f %% not recorded types)", ptypes.length, notRecordedTypeProbability);
            return null;
        }
        ArrayList<ResolvedJavaMethod> concreteMethods = new ArrayList<ResolvedJavaMethod>();
        ArrayList<Double> concreteMethodsProbabilities = new ArrayList<Double>();
        for (int i = 0; i < ptypes.length; ++i) {
            ResolvedJavaMethod concrete = ptypes[i].getType().resolveConcreteMethod(targetMethod, contextType);
            if (concrete == null) {
                InliningUtil.traceNotInlinedMethod(invoke, this.inliningDepth(), targetMethod, "could not resolve method", new Object[0]);
                graph.notifyInliningDecision(invoke, false, "InliningPhase", null, null, null, invoke.getTargetMethod(), "could not resolve method", new Object[0]);
                return null;
            }
            int index = concreteMethods.indexOf(concrete);
            double curProbability = ptypes[i].getProbability();
            if (index < 0) {
                index = concreteMethods.size();
                concreteMethods.add(concrete);
                concreteMethodsProbabilities.add(curProbability);
                continue;
            }
            concreteMethodsProbabilities.set(index, (Double)concreteMethodsProbabilities.get(index) + curProbability);
        }
        if (notRecordedTypeProbability > 0.0) {
            ArrayList<ResolvedJavaMethod> newConcreteMethods = new ArrayList<ResolvedJavaMethod>();
            ArrayList<Double> newConcreteMethodsProbabilities = new ArrayList<Double>();
            for (int i = 0; i < concreteMethods.size(); ++i) {
                if (!((Double)concreteMethodsProbabilities.get(i) >= GraalOptions.MegamorphicInliningMinMethodProbability.getValue(options))) continue;
                newConcreteMethods.add((ResolvedJavaMethod)concreteMethods.get(i));
                newConcreteMethodsProbabilities.add((Double)concreteMethodsProbabilities.get(i));
            }
            if (newConcreteMethods.isEmpty()) {
                InliningUtil.traceNotInlinedMethod(invoke, this.inliningDepth(), targetMethod, "no methods remaining after filtering less frequent methods (%d methods previously)", concreteMethods.size());
                graph.notifyInliningDecision(invoke, false, "InliningPhase", null, null, null, invoke.getTargetMethod(), "no methods remaining after filtering less frequent methods (%d methods previously)", concreteMethods.size());
                return null;
            }
            concreteMethods = newConcreteMethods;
            concreteMethodsProbabilities = newConcreteMethodsProbabilities;
        }
        if (concreteMethods.size() > this.maxMethodPerInlining) {
            InliningUtil.traceNotInlinedMethod(invoke, this.inliningDepth(), targetMethod, "polymorphic call with more than %d target methods", this.maxMethodPerInlining);
            graph.notifyInliningDecision(invoke, false, "InliningPhase", null, null, null, invoke.getTargetMethod(), "polymorphic call with more than %d target methods", this.maxMethodPerInlining);
            return null;
        }
        ArrayList<JavaTypeProfile.ProfiledType> usedTypes = new ArrayList<JavaTypeProfile.ProfiledType>();
        ArrayList<Integer> typesToConcretes = new ArrayList<Integer>();
        for (JavaTypeProfile.ProfiledType type : ptypes) {
            ResolvedJavaMethod concrete = type.getType().resolveConcreteMethod(targetMethod, contextType);
            int index = concreteMethods.indexOf(concrete);
            if (index == -1) {
                notRecordedTypeProbability += type.getProbability();
                continue;
            }
            assert (type.getType().isArray() || !type.getType().isAbstract()) : String.valueOf(type) + " " + String.valueOf(concrete);
            usedTypes.add(type);
            typesToConcretes.add(index);
        }
        if (usedTypes.isEmpty()) {
            InliningUtil.traceNotInlinedMethod(invoke, this.inliningDepth(), targetMethod, "no types remaining after filtering less frequent types (%d types previously)", ptypes.length);
            graph.notifyInliningDecision(invoke, false, "InliningPhase", null, null, null, invoke.getTargetMethod(), "no types remaining after filtering less frequent types (%d types previously)", ptypes.length);
            return null;
        }
        for (ResolvedJavaMethod concrete : concreteMethods) {
            if (this.checkTargetConditions(invoke, concrete)) continue;
            InliningUtil.traceNotInlinedMethod(invoke, this.inliningDepth(), targetMethod, "it is a polymorphic method call and at least one invoked method cannot be inlined", new Object[0]);
            graph.notifyInliningDecision(invoke, false, "InliningPhase", null, null, null, invoke.getTargetMethod(), "it is a polymorphic method call and at least one invoked method cannot be inlined", new Object[0]);
            return null;
        }
        return new MultiTypeGuardInlineInfo(invoke, concreteMethods, usedTypes, typesToConcretes, notRecordedTypeProbability, speculationFailed, speculation);
    }

    private InlineInfo getAssumptionInlineInfo(Invoke invoke, ResolvedJavaMethod concrete, Assumptions.AssumptionResult<?> takenAssumption) {
        assert (concrete.isConcrete());
        if (this.checkTargetConditions(invoke, concrete)) {
            return new AssumptionInlineInfo(invoke, concrete, takenAssumption);
        }
        return null;
    }

    private InlineInfo getExactInlineInfo(Invoke invoke, ResolvedJavaMethod targetMethod) {
        assert (targetMethod.isConcrete());
        if (this.checkTargetConditions(invoke, targetMethod)) {
            return new ExactInlineInfo(invoke, targetMethod);
        }
        return null;
    }

    private void doInline(CallsiteHolderExplorable callerCallsiteHolder, MethodInvocation calleeInvocation, String reason) {
        StructuredGraph callerGraph = callerCallsiteHolder.graph();
        InlineInfo calleeInfo = calleeInvocation.callee();
        try (DebugContext.Scope scope = this.debug.scope((Object)"doInline", callerGraph);){
            EconomicSet canonicalizedNodes = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
            canonicalizedNodes.addAll(calleeInfo.invoke().asNode().usages());
            EconomicSet<Node> parameterUsages = calleeInfo.inline(this.context.getProviders(), reason);
            canonicalizedNodes.addAll(parameterUsages);
            counterInliningRuns.increment(this.debug);
            this.debug.dump(4, (Object)callerGraph, "after %s", calleeInfo);
            Graph.Mark markBeforeCanonicalization = callerGraph.getMark();
            this.canonicalizer.applyIncremental(callerGraph, (CoreProviders)this.context, (Iterable<? extends Node>)canonicalizedNodes);
            for (Node newNode : callerGraph.getNewNodes(markBeforeCanonicalization)) {
                if (!(newNode instanceof Invoke)) continue;
                callerCallsiteHolder.pushInvoke((Invoke)((Object)newNode));
            }
            callerCallsiteHolder.computeProbabilities();
            counterInliningPerformed.increment(this.debug);
        }
        catch (BailoutException bailout) {
            throw bailout;
        }
        catch (AssertionError | RuntimeException e) {
            throw new GraalError((Throwable)e).addContext(calleeInfo.toString());
        }
        catch (GraalError e) {
            throw e.addContext(calleeInfo.toString());
        }
        catch (Throwable e) {
            throw this.debug.handle(e);
        }
    }

    private boolean tryToInline(MethodInvocation calleeInvocation, int inliningDepth) {
        CallsiteHolderExplorable callerCallsiteHolder = (CallsiteHolderExplorable)this.currentGraph();
        InlineInfo calleeInfo = calleeInvocation.callee();
        assert (callerCallsiteHolder.containsInvoke(calleeInfo.invoke()));
        counterInliningConsidered.increment(this.debug);
        InliningPolicy.Decision decision = this.inliningPolicy.isWorthInlining(this.context.getReplacements(), calleeInvocation, calleeInfo, inliningDepth, true);
        if (decision.shouldInline()) {
            this.doInline(callerCallsiteHolder, calleeInvocation, decision.getReason());
            return true;
        }
        if (this.context.getOptimisticOptimizations().devirtualizeInvokes(calleeInfo.graph().getOptions())) {
            calleeInfo.tryToDevirtualizeInvoke(this.context.getProviders());
        }
        return false;
    }

    private void processNextInvoke() {
        CallsiteHolderExplorable callsiteHolder = (CallsiteHolderExplorable)this.currentGraph();
        Invoke invoke = callsiteHolder.popInvoke();
        InlineInfo info = this.getInlineInfo(invoke);
        if (info != null) {
            info.populateInlinableElements(this.context, this.currentGraph().graph(), this.canonicalizer, this.rootGraph.getOptions());
            double invokeProbability = callsiteHolder.invokeProbability(invoke);
            double invokeRelevance = callsiteHolder.invokeRelevance(invoke);
            MethodInvocation methodInvocation = new MethodInvocation(info, invokeProbability, invokeRelevance, InliningData.freshlyInstantiatedArguments(invoke, callsiteHolder.getFixedParams()));
            this.pushInvocationAndGraphs(methodInvocation);
        }
    }

    public static BitSet freshlyInstantiatedArguments(Invoke invoke, EconomicSet<ParameterNode> fixedParams) {
        assert (fixedParams != null);
        assert (InliningData.paramsAndInvokeAreInSameGraph(invoke, fixedParams));
        BitSet result = null;
        int argIdx = 0;
        for (ValueNode arg : invoke.callTarget().arguments()) {
            assert (arg != null);
            if (InliningData.isFreshInstantiation(arg) || arg instanceof ParameterNode && fixedParams.contains((Object)((ParameterNode)arg))) {
                if (result == null) {
                    result = new BitSet();
                }
                result.set(argIdx);
            }
            ++argIdx;
        }
        return result;
    }

    private static boolean paramsAndInvokeAreInSameGraph(Invoke invoke, EconomicSet<ParameterNode> fixedParams) {
        if (fixedParams.isEmpty()) {
            return true;
        }
        for (ParameterNode p : fixedParams) {
            if (p.graph() == invoke.asNode().graph()) continue;
            return false;
        }
        return true;
    }

    public int graphCount() {
        return this.graphQueue.size();
    }

    public boolean hasUnprocessedGraphs() {
        return !this.graphQueue.isEmpty();
    }

    private CallsiteHolder currentGraph() {
        return this.graphQueue.peek();
    }

    private void popGraph() {
        this.graphQueue.pop();
        assert (this.graphQueue.size() <= this.maxGraphs) : Assertions.errorMessageContext("graphQueue", this.graphQueue, "maxGraphs", this.maxGraphs);
    }

    private void popGraphs(int count) {
        assert (NumUtil.assertNonNegativeInt(count));
        for (int i = 0; i < count; ++i) {
            this.graphQueue.pop();
        }
    }

    private Object[] inliningContext() {
        if (!this.debug.isDumpEnabled(2)) {
            return NO_CONTEXT;
        }
        Object[] result = new Object[this.graphQueue.size()];
        int i = 0;
        for (CallsiteHolder g : this.graphQueue) {
            result[i++] = g.method();
        }
        return result;
    }

    private MethodInvocation currentInvocation() {
        return this.invocationQueue.peekFirst();
    }

    private void pushInvocationAndGraphs(MethodInvocation methodInvocation) {
        this.invocationQueue.addFirst(methodInvocation);
        InlineInfo info = methodInvocation.callee();
        this.maxGraphs += info.numberOfMethods();
        assert (this.graphQueue.size() <= this.maxGraphs) : Assertions.errorMessageContext("graphQueue", this.graphQueue, "maxGraphs", this.maxGraphs);
        for (int i = 0; i < info.numberOfMethods(); ++i) {
            CallsiteHolder ch = methodInvocation.buildCallsiteHolderForElement(i);
            assert (!this.contains(ch.graph()));
            this.graphQueue.push(ch);
            assert (this.graphQueue.size() <= this.maxGraphs) : Assertions.errorMessageContext("graphQueue", this.graphQueue, "maxGraphs", this.maxGraphs);
        }
    }

    private void popInvocation() {
        this.maxGraphs -= this.invocationQueue.peekFirst().callee().numberOfMethods();
        assert (this.graphQueue.size() <= this.maxGraphs) : Assertions.errorMessageContext("graphQueue", this.graphQueue, "maxGraphs", this.maxGraphs);
        this.invocationQueue.removeFirst();
    }

    public int countRecursiveInlining(ResolvedJavaMethod method) {
        int count = 0;
        for (CallsiteHolder callsiteHolder : this.graphQueue) {
            if (!method.equals((Object)callsiteHolder.method())) continue;
            ++count;
        }
        return count;
    }

    public int inliningDepth() {
        assert (this.invocationQueue.size() > 0) : this;
        return this.invocationQueue.size() - 1;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("Invocations: ");
        for (MethodInvocation invocation : this.invocationQueue) {
            if (invocation.callee() == null) continue;
            result.append(invocation.callee().numberOfMethods());
            result.append("x ");
            result.append(invocation.callee().invoke());
            result.append("; ");
        }
        result.append("\nGraphs: ");
        for (CallsiteHolder graph : this.graphQueue) {
            result.append(graph.graph());
            result.append("; ");
        }
        return result.toString();
    }

    private boolean contains(StructuredGraph graph) {
        assert (graph != null);
        for (CallsiteHolder info : this.graphQueue) {
            if (info.graph() != graph) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean moveForward() {
        boolean delve;
        boolean backtrack;
        MethodInvocation currentInvocation = this.currentInvocation();
        boolean bl = backtrack = !currentInvocation.isRoot() && !this.inliningPolicy.isWorthInlining(this.context.getReplacements(), currentInvocation, currentInvocation.callee(), this.inliningDepth(), false).shouldInline();
        if (backtrack) {
            int remainingGraphs = currentInvocation.totalGraphs() - currentInvocation.processedGraphs();
            assert (NumUtil.assertPositiveInt(remainingGraphs));
            this.popGraphs(remainingGraphs);
            this.popInvocation();
            return false;
        }
        boolean bl2 = delve = this.currentGraph().hasRemainingInvokes() && this.inliningPolicy.continueInlining(this.currentGraph().graph());
        if (delve) {
            this.processNextInvoke();
            return false;
        }
        this.popGraph();
        if (currentInvocation.isRoot()) {
            return false;
        }
        assert (currentInvocation.callee().invoke().asNode().isAlive());
        currentInvocation.incrementProcessedGraphs();
        if (currentInvocation.processedGraphs() != currentInvocation.totalGraphs()) return false;
        this.popInvocation();
        try (DebugContext.Scope s = this.debug.scope((Object)"Inlining", this.inliningContext());){
            if (this.tryToInline(currentInvocation, this.inliningDepth() + 1)) {
                boolean bl3 = this.currentGraph().graph() == this.rootGraph;
                return bl3;
            }
            boolean bl5 = false;
            return bl5;
        }
        catch (Throwable e) {
            throw this.debug.handle(e);
        }
    }

    private boolean topGraphsForTopInvocation() {
        if (this.invocationQueue.isEmpty()) {
            assert (this.graphQueue.isEmpty());
            return true;
        }
        if (this.currentInvocation().isRoot()) {
            if (!this.graphQueue.isEmpty()) assert (this.graphQueue.size() == 1) : this.graphQueue;
            return true;
        }
        int remainingGraphs = this.currentInvocation().totalGraphs() - this.currentInvocation().processedGraphs();
        Iterator<CallsiteHolder> iter = this.graphQueue.iterator();
        for (int i = remainingGraphs - 1; i >= 0; --i) {
            if (!iter.hasNext()) {
                assert (false);
                return false;
            }
            CallsiteHolder queuedTargetCH = iter.next();
            Inlineable targetIE = this.currentInvocation().callee().inlineableElementAt(i);
            InlineableGraph targetIG = (InlineableGraph)targetIE;
            assert (queuedTargetCH.method().equals((Object)targetIG.getGraph().method()));
        }
        return true;
    }

    public boolean repOK() {
        assert (this.topGraphsForTopInvocation());
        return true;
    }
}

