/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common.util;

import java.util.EnumSet;
import java.util.Set;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;

public class EconomicSetNodeEventListener
extends Graph.NodeEventListener {
    private final EconomicSet<Node> nodes = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
    private final Set<Graph.NodeEvent> filter;

    public EconomicSetNodeEventListener() {
        this.filter = EnumSet.of(Graph.NodeEvent.INPUT_CHANGED, Graph.NodeEvent.NODE_ADDED, Graph.NodeEvent.ZERO_USAGES);
    }

    public EconomicSetNodeEventListener(Set<Graph.NodeEvent> filter) {
        this.filter = filter;
    }

    public EconomicSetNodeEventListener exclude(Graph.NodeEvent e) {
        this.filter.remove((Object)e);
        return this;
    }

    @Override
    public void changed(Graph.NodeEvent e, Node node) {
        if (this.filter.contains((Object)e)) {
            this.add(node);
            if (node instanceof Node.IndirectCanonicalization) {
                for (Node usage : node.usages()) {
                    this.add(usage);
                }
            }
            if (node instanceof AbstractBeginNode) {
                AbstractBeginNode abstractBeginNode = (AbstractBeginNode)node;
                this.add(abstractBeginNode.predecessor());
            }
        }
    }

    private void add(Node n) {
        if (n != null) {
            this.nodes.add((Object)n);
        }
    }

    public EconomicSet<Node> getNodes() {
        return this.nodes;
    }
}

