/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.contract;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.function.Predicate;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.phases.VerifyPhase;

public class VerifyNodeCosts {
    static boolean gr30893IsResolved = false;

    public static void verifyNodeClass(Class<?> clazz) {
        if (Node.class.isAssignableFrom(clazz)) {
            NodeInfo nodeInfo = clazz.getAnnotation(NodeInfo.class);
            if (nodeInfo == null) {
                throw new VerifyPhase.VerificationError("%s extends %s but does not specify a %s annotation.", clazz.getName(), Node.class.getName(), NodeInfo.class.getName());
            }
            ArrayList<String> errors = new ArrayList<String>();
            if (gr30893IsResolved && nodeInfo.cycles() == NodeCycles.CYCLES_UNKNOWN && nodeInfo.cyclesRationale().isEmpty()) {
                errors.add(String.format("Requires a non-empty value for cyclesRationale since its cycles value is %s.", new Object[]{NodeCycles.CYCLES_UNKNOWN}));
            }
            if (gr30893IsResolved && nodeInfo.size() == NodeSize.SIZE_UNKNOWN && nodeInfo.sizeRationale().isEmpty()) {
                errors.add(String.format("Requires a non-empty value for sizeRationale since its size value is %s.", new Object[]{NodeSize.SIZE_UNKNOWN}));
            }
            if (!Modifier.isAbstract(clazz.getModifiers())) {
                NodeClass<?> clazzType = NodeClass.get(clazz);
                boolean cyclesSet = VerifyNodeCosts.walkCHUntil(clazzType, Node.TYPE, cur -> cur.cycles() != NodeCycles.CYCLES_UNSET);
                boolean sizeSet = VerifyNodeCosts.walkCHUntil(clazzType, Node.TYPE, cur -> cur.size() != NodeSize.SIZE_UNSET);
                if (!cyclesSet) {
                    errors.add(String.format("Does not specify a %s value in its class hierarchy.", NodeCycles.class.getSimpleName()));
                }
                if (!sizeSet) {
                    errors.add(String.format("Does not specify a %s value in its class hierarchy.", NodeSize.class.getSimpleName()));
                }
            }
            if (!errors.isEmpty()) {
                throw new VerifyPhase.VerificationError("Errors for " + clazz.getName() + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), errors), new Object[0]);
            }
        }
    }

    private static boolean walkCHUntil(NodeClass<?> start, NodeClass<?> until, Predicate<NodeClass<?>> p) {
        for (NodeClass<?> cur = start; cur != until && cur != null; cur = cur.getSuperNodeClass()) {
            if (!p.test(cur)) continue;
            return true;
        }
        return false;
    }
}

