/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.graph;

import java.util.ListIterator;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;

public abstract class ScheduledNodeIterator {
    private FixedWithNextNode lastFixed;
    private FixedWithNextNode reconnect;
    private ListIterator<Node> iterator;

    public void processNodes(HIRBlock block, StructuredGraph.ScheduleResult schedule) {
        this.lastFixed = block.getBeginNode();
        assert (this.lastFixed != null);
        this.reconnect = null;
        this.iterator = schedule.nodesFor(block).listIterator();
        while (this.iterator.hasNext()) {
            Node node = this.iterator.next();
            if (!node.isAlive()) continue;
            if (this.reconnect != null && node instanceof FixedNode) {
                this.reconnect.setNext((FixedNode)node);
                this.reconnect = null;
            }
            if (node instanceof FixedWithNextNode) {
                this.lastFixed = (FixedWithNextNode)node;
            }
            this.processNode(node, block, schedule, this.iterator);
        }
        if (this.reconnect != null) {
            assert (block.getSuccessorCount() == 1) : Assertions.errorMessage(block);
            this.reconnect.setNext(block.getFirstSuccessor().getBeginNode());
        }
    }

    protected void insert(FixedNode start, FixedWithNextNode end) {
        this.lastFixed.setNext(start);
        this.lastFixed = end;
        this.reconnect = end;
    }

    protected void replaceCurrent(FixedWithNextNode newNode) {
        Node current = this.iterator.previous();
        this.iterator.next();
        current.replaceAndDelete(newNode);
        this.insert(newNode, newNode);
        this.iterator.set(newNode);
    }

    protected abstract void processNode(Node var1, HIRBlock var2, StructuredGraph.ScheduleResult var3, ListIterator<Node> var4);
}

