/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.schedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.graal.compiler.core.common.cfg.AbstractControlFlowGraph;
import jdk.graal.compiler.core.common.cfg.BlockMap;
import jdk.graal.compiler.core.common.util.CompilationAlarm;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeBitMap;
import jdk.graal.compiler.graph.NodeMap;
import jdk.graal.compiler.graph.NodeStack;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.ControlSinkNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.GuardNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ProxyNode;
import jdk.graal.compiler.nodes.StartNode;
import jdk.graal.compiler.nodes.StaticDeoptimizingNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.VirtualState;
import jdk.graal.compiler.nodes.calc.ConvertNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.cfg.HIRLoop;
import jdk.graal.compiler.nodes.cfg.LocationSet;
import jdk.graal.compiler.nodes.memory.FloatingReadNode;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.memory.MultiMemoryKill;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.ValueProxy;
import jdk.graal.compiler.nodes.virtual.AllocatedObjectNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.schedule.ScheduleVerification;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.word.LocationIdentity;

public final class SchedulePhase
extends BasePhase<CoreProviders> {
    private final SchedulingStrategy selectedStrategy;
    private final boolean immutableGraph;

    public SchedulePhase(OptionValues options) {
        this(false, options);
    }

    public SchedulePhase(boolean immutableGraph, OptionValues options) {
        this(SchedulePhase.getDefaultStrategy(options), immutableGraph);
    }

    public SchedulePhase(SchedulingStrategy strategy) {
        this(strategy, false);
    }

    public SchedulePhase(SchedulingStrategy strategy, boolean immutableGraph) {
        this.selectedStrategy = strategy;
        this.immutableGraph = immutableGraph;
    }

    public static SchedulingStrategy getDefaultStrategy(OptionValues options) {
        return GraalOptions.OptScheduleOutOfLoops.getValue(options) != false ? SchedulingStrategy.LATEST_OUT_OF_LOOPS : SchedulingStrategy.LATEST;
    }

    private Graph.NodeEventScope verifyImmutableGraph(StructuredGraph graph) {
        if (this.immutableGraph && Assertions.assertionsEnabled()) {
            return graph.trackNodeEvents(new Graph.NodeEventListener(this){

                @Override
                public void changed(Graph.NodeEvent e, Node node) {
                    assert (false) : "graph changed: " + String.valueOf((Object)e) + " on node " + String.valueOf(node);
                }
            });
        }
        return null;
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        try (Graph.NodeEventScope scope = this.verifyImmutableGraph(graph);){
            Instance inst = new Instance(context.getLowerer().supportsImplicitNullChecks());
            inst.run(graph, this.selectedStrategy, this.immutableGraph);
        }
    }

    public static void runWithoutContextOptimizations(StructuredGraph graph) {
        SchedulePhase.runWithoutContextOptimizations(graph, SchedulePhase.getDefaultStrategy(graph.getOptions()));
    }

    public static void runWithoutContextOptimizations(StructuredGraph graph, SchedulingStrategy strategy) {
        SchedulePhase.runWithoutContextOptimizations(graph, strategy, ControlFlowGraph.computeForSchedule(graph), false);
    }

    public static void runWithoutContextOptimizations(StructuredGraph graph, SchedulingStrategy strategy, boolean immutable) {
        SchedulePhase.runWithoutContextOptimizations(graph, strategy, ControlFlowGraph.computeForSchedule(graph), immutable);
    }

    public static void runWithoutContextOptimizations(StructuredGraph graph, SchedulingStrategy strategy, ControlFlowGraph cfg, boolean immutable) {
        Instance inst = new Instance(cfg, false);
        inst.run(graph, strategy, immutable);
    }

    public static void run(StructuredGraph graph, SchedulingStrategy strategy, ControlFlowGraph cfg, CoreProviders context, boolean immutable) {
        Instance inst = new Instance(cfg, context.getLowerer().supportsImplicitNullChecks());
        inst.run(graph, strategy, immutable);
    }

    public static enum SchedulingStrategy {
        EARLIEST_WITH_GUARD_ORDER,
        EARLIEST,
        LATEST,
        LATEST_OUT_OF_LOOPS,
        LATEST_OUT_OF_LOOPS_IMPLICIT_NULL_CHECKS;


        public boolean isEarliest() {
            return this == EARLIEST || this == EARLIEST_WITH_GUARD_ORDER;
        }

        public boolean isLatest() {
            return !this.isEarliest();
        }

        public boolean scheduleOutOfLoops() {
            return this == LATEST_OUT_OF_LOOPS || this == LATEST_OUT_OF_LOOPS_IMPLICIT_NULL_CHECKS;
        }

        public boolean considerImplicitNullChecks() {
            return this == LATEST_OUT_OF_LOOPS_IMPLICIT_NULL_CHECKS;
        }
    }

    public static class Instance {
        private static final double IMPLICIT_NULL_CHECK_OPPORTUNITY_PROBABILITY_FACTOR = 2.0;
        protected ControlFlowGraph cfg;
        protected BlockMap<List<Node>> blockToNodesMap;
        protected NodeMap<HIRBlock> nodeToBlockMap;
        protected boolean supportsImplicitNullChecks;

        public Instance(boolean supportsImplicitNullChecks) {
            this(null, supportsImplicitNullChecks);
        }

        public Instance(ControlFlowGraph cfg, boolean supportsImplicitNullChecks) {
            this.cfg = cfg;
            this.supportsImplicitNullChecks = supportsImplicitNullChecks;
        }

        public void run(StructuredGraph graph, SchedulingStrategy selectedStrategy, boolean immutableGraph) {
            if (this.cfg == null) {
                this.cfg = ControlFlowGraph.computeForSchedule(graph);
            }
            NodeMap<HIRBlock> currentNodeMap = graph.createNodeMap();
            NodeBitMap visited = graph.createNodeBitMap();
            BlockMap<List<Node>> earliestBlockToNodesMap = new BlockMap<List<Node>>(this.cfg);
            this.nodeToBlockMap = currentNodeMap;
            this.blockToNodesMap = earliestBlockToNodesMap;
            this.scheduleEarliestIterative(earliestBlockToNodesMap, currentNodeMap, visited, graph, immutableGraph, selectedStrategy == SchedulingStrategy.EARLIEST_WITH_GUARD_ORDER);
            if (!selectedStrategy.isEarliest()) {
                BlockMap<List<Node>> latestBlockToNodesMap = new BlockMap<List<Node>>(this.cfg);
                for (HIRBlock b : this.cfg.getBlocks()) {
                    latestBlockToNodesMap.put(b, new ArrayList());
                }
                BlockMap<ArrayList<FloatingReadNode>> watchListMap = this.calcLatestBlocks(selectedStrategy, currentNodeMap, earliestBlockToNodesMap, visited, latestBlockToNodesMap, immutableGraph);
                Instance.sortNodesLatestWithinBlock(this.cfg, earliestBlockToNodesMap, latestBlockToNodesMap, currentNodeMap, watchListMap, visited, this.supportsImplicitNullChecks);
                assert (Instance.verifySchedule(this.cfg, latestBlockToNodesMap, currentNodeMap));
                assert (!Assertions.detailedAssertionsEnabled(graph.getOptions()) || ScheduleVerification.check(this.cfg.getStartBlock(), latestBlockToNodesMap, currentNodeMap));
                this.blockToNodesMap = latestBlockToNodesMap;
            }
            this.cfg.setNodeToBlock(currentNodeMap);
            graph.setLastSchedule(new StructuredGraph.ScheduleResult(this.cfg, this.nodeToBlockMap, this.blockToNodesMap));
        }

        @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="false positive found by findbugs")
        private BlockMap<ArrayList<FloatingReadNode>> calcLatestBlocks(SchedulingStrategy strategy, NodeMap<HIRBlock> currentNodeMap, BlockMap<List<Node>> earliestBlockToNodesMap, NodeBitMap visited, BlockMap<List<Node>> latestBlockToNodesMap, boolean immutableGraph) {
            BlockMap<ArrayList<FloatingReadNode>> watchListMap = new BlockMap<ArrayList<FloatingReadNode>>(this.cfg);
            HIRBlock[] reversePostOrder = this.cfg.reversePostOrder();
            NodeBitMap moveInputsIntoDominator = this.cfg.graph.createNodeBitMap();
            for (int j = reversePostOrder.length - 1; j >= 0; --j) {
                HIRBlock currentBlock = reversePostOrder[j];
                List<Node> blockToNodes = earliestBlockToNodesMap.get(currentBlock);
                LocationSet killed = null;
                int previousIndex = blockToNodes.size();
                for (int i = blockToNodes.size() - 1; i >= 0; --i) {
                    FloatingReadNode floatingReadNode;
                    LocationIdentity location;
                    Node currentNode = blockToNodes.get(i);
                    assert (currentNodeMap.get(currentNode) == currentBlock) : Assertions.errorMessageContext("currentNodeMap", currentNodeMap, "currentBlock", currentBlock);
                    assert (!(currentNode instanceof PhiNode) && !(currentNode instanceof ProxyNode)) : currentNode;
                    assert (visited.isMarked(currentNode)) : Assertions.errorMessageContext("visited", visited, "currentNode", currentNode);
                    if (currentNode instanceof FixedNode) continue;
                    HIRBlock latestBlock = null;
                    if (currentBlock.getFirstDominated() == null && !(currentNode instanceof VirtualState)) {
                        latestBlock = currentBlock;
                    }
                    if (currentNode instanceof AllocatedObjectNode) {
                        latestBlock = currentBlock;
                    }
                    LocationIdentity constrainingLocation = null;
                    if (latestBlock == null && currentNode instanceof FloatingReadNode && (location = (floatingReadNode = (FloatingReadNode)currentNode).getLocationIdentity()).isMutable()) {
                        constrainingLocation = location;
                        if (currentBlock.canKill(location)) {
                            if (killed == null) {
                                killed = new LocationSet();
                            }
                            Instance.fillKillSet(killed, blockToNodes.subList(i + 1, previousIndex));
                            previousIndex = i;
                            if (killed.contains(location)) {
                                latestBlock = currentBlock;
                            }
                        }
                    }
                    if (latestBlock == null) {
                        this.calcLatestBlock(currentBlock, strategy, currentNode, currentNodeMap, constrainingLocation, watchListMap, latestBlockToNodesMap, visited, immutableGraph, moveInputsIntoDominator);
                        continue;
                    }
                    Instance.selectLatestBlock(currentNode, currentBlock, latestBlock, currentNodeMap, watchListMap, constrainingLocation, latestBlockToNodesMap);
                }
            }
            return watchListMap;
        }

        protected static void selectLatestBlock(Node currentNode, HIRBlock currentBlock, HIRBlock latestBlock, NodeMap<HIRBlock> currentNodeMap, BlockMap<ArrayList<FloatingReadNode>> watchListMap, LocationIdentity constrainingLocation, BlockMap<List<Node>> latestBlockToNodesMap) {
            if (currentBlock != latestBlock) {
                Instance.checkLatestEarliestRelation(currentNode, currentBlock, latestBlock, null);
                currentNodeMap.setAndGrow(currentNode, latestBlock);
                if (constrainingLocation != null && latestBlock.canKill(constrainingLocation)) {
                    if (watchListMap.get(latestBlock) == null) {
                        watchListMap.put(latestBlock, new ArrayList());
                    }
                    watchListMap.get(latestBlock).add((FloatingReadNode)currentNode);
                }
            }
            latestBlockToNodesMap.get(latestBlock).add(currentNode);
        }

        private static void checkLatestEarliestRelation(Node currentNode, HIRBlock earliestBlock, HIRBlock latestBlock, Node currentUsage) {
            GraalError.guarantee(earliestBlock.dominates(latestBlock) || currentNode instanceof FrameState && latestBlock == earliestBlock.getDominator(), "%s earliest block %s (%s) does not dominate latest block %s (%s), added usage %s", (Object)currentNode, (Object)earliestBlock, (Object)earliestBlock.getBeginNode(), (Object)latestBlock, (Object)latestBlock.getBeginNode(), (Object)currentUsage);
        }

        private static boolean verifySchedule(ControlFlowGraph cfg, BlockMap<List<Node>> blockToNodesMap, NodeMap<HIRBlock> nodeMap) {
            for (HIRBlock b : cfg.getBlocks()) {
                List<Node> nodes = blockToNodesMap.get(b);
                for (Node n : nodes) {
                    assert (n.isAlive());
                    assert (nodeMap.get(n) == b) : Assertions.errorMessage(n, b);
                    StructuredGraph g = (StructuredGraph)n.graph();
                    if (g.hasLoops() && g.getGuardsStage() == GraphState.GuardsStage.AFTER_FSA && n instanceof DeoptimizeNode) assert (b.getLoopDepth() == 0) : n;
                }
            }
            return true;
        }

        public static HIRBlock checkKillsBetween(HIRBlock earliestBlock, HIRBlock latestBlock, LocationIdentity location) {
            HIRBlock currentBlock;
            assert (earliestBlock.strictlyDominates(latestBlock));
            ArrayList<HIRBlock> dominatorChain = new ArrayList<HIRBlock>();
            dominatorChain.add(latestBlock);
            for (HIRBlock current = (HIRBlock)latestBlock.getDominator(); current != earliestBlock; current = (HIRBlock)current.getDominator()) {
                assert (earliestBlock.strictlyDominates(current)) : Assertions.errorMessageContext("earliestBlock", earliestBlock, "current", current);
                assert (current.strictlyDominates(latestBlock)) : Assertions.errorMessageContext("latestBlock", latestBlock, "current", current);
                if (current.canKill(location)) {
                    dominatorChain.clear();
                }
                dominatorChain.add(current);
            }
            assert (dominatorChain.size() >= 1) : Assertions.errorMessageContext("dominatorChain", dominatorChain);
            HIRBlock dominator = (HIRBlock)((HIRBlock)dominatorChain.get(dominatorChain.size() - 1)).getDominator();
            assert (dominator == earliestBlock) : Assertions.errorMessageContext("dominator", dominator, "earliestBlock", earliestBlock);
            HIRBlock lastBlock = earliestBlock;
            for (int i = dominatorChain.size() - 1; !(i < 0 || (currentBlock = (HIRBlock)dominatorChain.get(i)).getLoopDepth() > lastBlock.getLoopDepth() && currentBlock.getLoop() != null && ((HIRLoop)currentBlock.getLoop()).canKill(location) || currentBlock.canKillBetweenThisAndDominator(location)); --i) {
                lastBlock = currentBlock;
            }
            return lastBlock;
        }

        private static void fillKillSet(LocationSet killed, List<Node> subList) {
            if (!killed.isAny()) {
                for (Node n : subList) {
                    if (MemoryKill.isSingleMemoryKill(n)) {
                        LocationIdentity identity = ((SingleMemoryKill)((Object)n)).getKilledLocationIdentity();
                        killed.add(identity);
                        if (!killed.isAny()) continue;
                        return;
                    }
                    if (!MemoryKill.isMultiMemoryKill(n)) continue;
                    for (LocationIdentity identity : ((MultiMemoryKill)((Object)n)).getKilledLocationIdentities()) {
                        killed.add(identity);
                        if (!killed.isAny()) continue;
                        return;
                    }
                }
            }
        }

        private static void sortNodesLatestWithinBlock(ControlFlowGraph cfg, BlockMap<List<Node>> earliestBlockToNodesMap, BlockMap<List<Node>> latestBlockToNodesMap, NodeMap<HIRBlock> currentNodeMap, BlockMap<ArrayList<FloatingReadNode>> watchListMap, NodeBitMap visited, boolean supportsImplicitNullChecks) {
            for (HIRBlock b : cfg.getBlocks()) {
                Instance.sortNodesLatestWithinBlock(b, earliestBlockToNodesMap, latestBlockToNodesMap, currentNodeMap, watchListMap, visited, supportsImplicitNullChecks);
            }
        }

        private static void sortNodesLatestWithinBlock(HIRBlock b, BlockMap<List<Node>> earliestBlockToNodesMap, BlockMap<List<Node>> latestBlockToNodesMap, NodeMap<HIRBlock> nodeMap, BlockMap<ArrayList<FloatingReadNode>> watchListMap, NodeBitMap unprocessed, boolean supportsImplicitNullChecks) {
            AbstractBeginNode beginNode;
            List<Node> earliestSorting = earliestBlockToNodesMap.get(b);
            ArrayList<Node> result = new ArrayList<Node>(earliestSorting.size());
            ArrayList<FloatingReadNode> watchList = null;
            if (watchListMap != null) {
                watchList = watchListMap.get(b);
                assert (watchList == null || !b.getKillLocations().isEmpty());
            }
            if ((beginNode = b.getBeginNode()) instanceof LoopExitNode) {
                LoopExitNode loopExitNode = (LoopExitNode)beginNode;
                for (ProxyNode proxy : loopExitNode.proxies()) {
                    unprocessed.clear(proxy);
                    ValueNode value = proxy.value();
                    if (value == null || nodeMap.get(value) != b || !unprocessed.isMarked(value)) continue;
                    Instance.sortIntoList(value, b, result, nodeMap, unprocessed, null);
                }
            }
            FixedNode endNode = b.getEndNode();
            FixedNode fixedEndNode = null;
            if (Instance.isFixedEnd(endNode)) {
                fixedEndNode = endNode;
            }
            for (Node n : earliestSorting) {
                if (n == fixedEndNode) continue;
                if (n instanceof FixedNode) {
                    assert (nodeMap.get(n) == b) : Assertions.errorMessageContext("n", n, "b", b);
                    Instance.checkWatchList(b, nodeMap, unprocessed, result, watchList, n);
                    Instance.sortIntoList(n, b, result, nodeMap, unprocessed, null);
                    continue;
                }
                if (nodeMap.get(n) != b || !(n instanceof FloatingReadNode)) continue;
                FloatingReadNode floatingReadNode = (FloatingReadNode)n;
                if (Instance.isImplicitNullOpportunity(floatingReadNode, b, supportsImplicitNullChecks)) {
                    Instance.sortIntoList(floatingReadNode, b, result, nodeMap, unprocessed, null);
                    continue;
                }
                LocationIdentity location = floatingReadNode.getLocationIdentity();
                if (!b.canKill(location)) continue;
                if (watchList == null) {
                    watchList = new ArrayList();
                }
                watchList.add(floatingReadNode);
            }
            for (Node n : latestBlockToNodesMap.get(b)) {
                assert (nodeMap.get(n) == b) : n;
                assert (!(n instanceof FixedNode)) : n;
                if (!unprocessed.isMarked(n)) continue;
                Instance.sortIntoList(n, b, result, nodeMap, unprocessed, fixedEndNode);
            }
            if (endNode != null && unprocessed.isMarked(endNode)) {
                Instance.sortIntoList(endNode, b, result, nodeMap, unprocessed, null);
            }
            latestBlockToNodesMap.put(b, result);
        }

        private static void checkWatchList(HIRBlock b, NodeMap<HIRBlock> nodeMap, NodeBitMap unprocessed, ArrayList<Node> result, ArrayList<FloatingReadNode> watchList, Node n) {
            if (watchList != null && !watchList.isEmpty()) {
                if (MemoryKill.isSingleMemoryKill(n)) {
                    LocationIdentity identity = ((SingleMemoryKill)((Object)n)).getKilledLocationIdentity();
                    Instance.checkWatchList(watchList, identity, b, result, nodeMap, unprocessed);
                } else if (MemoryKill.isMultiMemoryKill(n)) {
                    for (LocationIdentity identity : ((MultiMemoryKill)((Object)n)).getKilledLocationIdentities()) {
                        Instance.checkWatchList(watchList, identity, b, result, nodeMap, unprocessed);
                    }
                }
            }
        }

        private static void checkWatchList(ArrayList<FloatingReadNode> watchList, LocationIdentity identity, HIRBlock b, ArrayList<Node> result, NodeMap<HIRBlock> nodeMap, NodeBitMap unprocessed) {
            if (!identity.isImmutable()) {
                if (identity.isAny()) {
                    for (FloatingReadNode r : watchList) {
                        if (!unprocessed.isMarked(r)) continue;
                        Instance.sortIntoList(r, b, result, nodeMap, unprocessed, null);
                    }
                    watchList.clear();
                } else {
                    int index = 0;
                    while (index < watchList.size()) {
                        FloatingReadNode r = watchList.get(index);
                        LocationIdentity locationIdentity = r.getLocationIdentity();
                        assert (locationIdentity.isMutable());
                        if (unprocessed.isMarked(r)) {
                            if (identity.overlaps(locationIdentity)) {
                                Instance.sortIntoList(r, b, result, nodeMap, unprocessed, null);
                            } else {
                                ++index;
                                continue;
                            }
                        }
                        int lastIndex = watchList.size() - 1;
                        watchList.set(index, watchList.get(lastIndex));
                        watchList.remove(lastIndex);
                    }
                }
            }
        }

        private static void sortIntoList(Node n, HIRBlock b, ArrayList<Node> result, NodeMap<HIRBlock> nodeMap, NodeBitMap unprocessed, Node excludeNode) {
            assert (unprocessed.isMarked(n)) : Assertions.errorMessage(n);
            assert (nodeMap.get(n) == b) : Assertions.errorMessage(n);
            if (n instanceof PhiNode) {
                return;
            }
            unprocessed.clear(n);
            for (Node input : n.inputs()) {
                if (nodeMap.get(input) != b || !unprocessed.isMarked(input) || input == excludeNode) continue;
                Instance.sortIntoList(input, b, result, nodeMap, unprocessed, excludeNode);
            }
            if (!(n instanceof ProxyNode)) {
                result.add(n);
            }
        }

        protected void calcLatestBlock(HIRBlock earliestBlock, SchedulingStrategy strategy, Node currentNode, NodeMap<HIRBlock> currentNodeMap, LocationIdentity constrainingLocation, BlockMap<ArrayList<FloatingReadNode>> watchListMap, BlockMap<List<Node>> latestBlockToNodesMap, NodeBitMap visited, boolean immutableGraph, NodeBitMap moveInputsIntoDominator) {
            HIRBlock latestBlock = null;
            if (!currentNode.hasUsages()) {
                assert (currentNode instanceof GuardNode) : Assertions.errorMessage(currentNode);
                latestBlock = earliestBlock;
            } else {
                assert (currentNode.hasUsages());
                for (Node usage : currentNode.usages()) {
                    if (immutableGraph && !visited.contains(usage)) continue;
                    latestBlock = Instance.calcLatestBlockForUsage(currentNode, usage, earliestBlock, latestBlock, currentNodeMap, moveInputsIntoDominator);
                    Instance.checkLatestEarliestRelation(currentNode, earliestBlock, latestBlock, usage);
                }
                assert (latestBlock != null) : currentNode;
                if (strategy.scheduleOutOfLoops()) {
                    for (HIRBlock currentBlock = latestBlock; currentBlock.getLoopDepth() > earliestBlock.getLoopDepth() && currentBlock != earliestBlock.getDominator(); currentBlock = (HIRBlock)currentBlock.getDominator()) {
                        HIRBlock previousCurrentBlock = currentBlock;
                        if (!previousCurrentBlock.isLoopHeader() || Instance.compareRelativeFrequencies(currentBlock.getRelativeFrequency(), latestBlock.getRelativeFrequency()) > 0 && !((StructuredGraph)currentNode.graph()).isBeforeStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL)) continue;
                        latestBlock = currentBlock;
                    }
                }
                if (latestBlock != earliestBlock && latestBlock != earliestBlock.getDominator() && constrainingLocation != null) {
                    latestBlock = Instance.checkKillsBetween(earliestBlock, latestBlock, constrainingLocation);
                }
            }
            if (latestBlock != earliestBlock && strategy.considerImplicitNullChecks() && Instance.isImplicitNullOpportunity(currentNode, earliestBlock, this.supportsImplicitNullChecks) && earliestBlock.getRelativeFrequency() < latestBlock.getRelativeFrequency() * 2.0) {
                latestBlock = earliestBlock;
            }
            if (currentNode instanceof VirtualState) {
                for (Node usage : currentNode.usages()) {
                    if ((moveInputsIntoDominator.isNew(usage) || !moveInputsIntoDominator.isMarked(usage)) && (!(usage instanceof AbstractBeginNode) || usage instanceof StartNode) || currentNodeMap.get(usage) != latestBlock) continue;
                    moveInputsIntoDominator.mark(currentNode);
                    break;
                }
            }
            Instance.selectLatestBlock(currentNode, earliestBlock, latestBlock, currentNodeMap, watchListMap, constrainingLocation, latestBlockToNodesMap);
        }

        public static int compareRelativeFrequencies(double f1, double f2) {
            double res = f1 - f2;
            double delta = 0.01;
            if (res > delta) {
                return 1;
            }
            if (res < -delta) {
                return -1;
            }
            return 0;
        }

        protected static boolean isImplicitNullOpportunity(Node currentNode, HIRBlock block, boolean supportsImplicitNullChecks) {
            if (!supportsImplicitNullChecks) {
                return false;
            }
            if (currentNode instanceof FloatingReadNode) {
                IfNode ifNode;
                FloatingReadNode floatingReadNode = (FloatingReadNode)currentNode;
                Node pred = block.getBeginNode().predecessor();
                if (pred instanceof IfNode && (ifNode = (IfNode)pred).condition() instanceof IsNullNode && ifNode.getTrueSuccessorProbability() == 0.0) {
                    IsNullNode isNullNode = (IsNullNode)ifNode.condition();
                    if (Instance.getUnproxifiedUncompressed(floatingReadNode.getAddress().getBase()) == Instance.getUnproxifiedUncompressed(isNullNode.getValue())) {
                        return true;
                    }
                }
            }
            return false;
        }

        private static Node getUnproxifiedUncompressed(Node node) {
            Node result = node;
            while (true) {
                ConvertNode convertNode;
                CompilationAlarm.checkProgress(node.graph());
                if (result instanceof ValueProxy) {
                    ValueProxy valueProxy = (ValueProxy)((Object)result);
                    result = valueProxy.getOriginalNode();
                    continue;
                }
                if (!(result instanceof ConvertNode) || !(convertNode = (ConvertNode)((Object)result)).mayNullCheckSkipConversion()) break;
                result = convertNode.getValue();
            }
            return result;
        }

        private static HIRBlock calcLatestBlockForUsage(Node node, Node usage, HIRBlock earliestBlock, HIRBlock initialLatestBlock, NodeMap<HIRBlock> currentNodeMap, NodeBitMap moveInputsToDominator) {
            assert (!(node instanceof PhiNode)) : node;
            HIRBlock currentBlock = initialLatestBlock;
            if (usage instanceof PhiNode) {
                PhiNode phi = (PhiNode)usage;
                AbstractMergeNode merge = phi.merge();
                HIRBlock mergeBlock = currentNodeMap.get(merge);
                for (int i = 0; i < phi.valueCount(); ++i) {
                    if (phi.valueAt(i) != node) continue;
                    HIRBlock otherBlock = (HIRBlock)mergeBlock.getPredecessorAt(i);
                    currentBlock = AbstractControlFlowGraph.commonDominatorTyped(currentBlock, otherBlock);
                }
            } else {
                HIRBlock otherBlock = currentNodeMap.get(usage);
                if (usage instanceof ProxyNode) {
                    ProxyNode proxyNode = (ProxyNode)usage;
                    otherBlock = currentNodeMap.get(proxyNode.proxyPoint());
                }
                if (!(node instanceof VirtualState) && !moveInputsToDominator.isNew(usage) && moveInputsToDominator.isMarked(usage)) {
                    HIRBlock dominator = (HIRBlock)otherBlock.getDominator();
                    if (AbstractControlFlowGraph.dominates(earliestBlock, dominator)) {
                        otherBlock = dominator;
                    }
                    GraalError.guarantee(otherBlock != null, "Dominators need to be computed in the CFG");
                }
                currentBlock = AbstractControlFlowGraph.commonDominatorTyped(currentBlock, otherBlock);
            }
            return currentBlock;
        }

        private void scheduleEarliestIterative(BlockMap<List<Node>> blockToNodes, NodeMap<HIRBlock> nodeToBlock, NodeBitMap visited, StructuredGraph graph, boolean immutableGraph, boolean withGuardOrder) {
            NodeMap<MicroBlock> entries = graph.createNodeMap();
            NodeStack stack = new NodeStack();
            MicroBlock startBlock = null;
            int nextId = 1;
            HIRBlock[] hIRBlockArray = this.cfg.reversePostOrder();
            int n = hIRBlockArray.length;
            for (int i = 0; i < n; ++i) {
                HIRBlock b = hIRBlockArray[i];
                for (FixedNode current : b.getBeginNode().getBlockNodes()) {
                    MicroBlock microBlock = new MicroBlock(nextId++);
                    entries.set(current, microBlock);
                    boolean isNew = visited.checkAndMarkInc(current);
                    assert (isNew);
                    if (startBlock != null) continue;
                    startBlock = microBlock;
                }
            }
            if (graph.getGuardsStage().allowsFloatingGuards() && graph.getNodes(GuardNode.TYPE).isNotEmpty()) {
                if (GraalOptions.GuardPriorities.getValue(graph.getOptions()).booleanValue() && withGuardOrder) {
                    EnumMap guardsByPriority = new EnumMap(StaticDeoptimizingNode.GuardPriority.class);
                    for (GuardNode guard : graph.getNodes(GuardNode.TYPE)) {
                        guardsByPriority.computeIfAbsent(guard.computePriority(), p -> new ArrayList()).add(guard);
                    }
                    for (List guards : guardsByPriority.values()) {
                        Instance.processNodes(visited, entries, stack, startBlock, guards);
                    }
                    GuardOrder.resortGuards(graph, entries, stack);
                } else {
                    Instance.processNodes(visited, entries, stack, startBlock, graph.getNodes(GuardNode.TYPE));
                }
            } else assert (graph.getNodes(GuardNode.TYPE).isEmpty());
            for (HIRBlock b : this.cfg.reversePostOrder()) {
                for (FixedNode current : b.getBeginNode().getBlockNodes()) {
                    Instance.processNodes(visited, entries, stack, startBlock, current.inputs());
                }
            }
            if (visited.getCounter() < graph.getNodeCount()) {
                boolean changed;
                boolean unmarkedPhi;
                do {
                    changed = false;
                    unmarkedPhi = false;
                    for (LoopBeginNode loopBegin : graph.getNodes(LoopBeginNode.TYPE)) {
                        for (PhiNode phi : loopBegin.phis()) {
                            if (visited.isMarked(phi)) {
                                for (int i = 0; i < loopBegin.getLoopEndCount(); ++i) {
                                    ValueNode node = phi.valueAt(i + loopBegin.forwardEndCount());
                                    if (node == null || entries.get(node) != null) continue;
                                    changed = true;
                                    Instance.processStack(node, startBlock, entries, visited, stack);
                                }
                                continue;
                            }
                            unmarkedPhi = true;
                        }
                    }
                } while (unmarkedPhi && changed);
            }
            if (!immutableGraph && visited.getCounter() < graph.getNodeCount()) {
                for (Node n2 : graph.getNodes()) {
                    if (visited.isMarked(n2)) continue;
                    n2.clearInputs();
                    n2.markDeleted();
                }
            }
            for (HIRBlock b : this.cfg.reversePostOrder()) {
                FixedNode fixedNode = b.getEndNode();
                if (!(fixedNode instanceof ControlSplitNode)) continue;
                ControlSplitNode controlSplitNode = (ControlSplitNode)fixedNode;
                MicroBlock endBlock = entries.get(fixedNode);
                AbstractBeginNode primarySuccessor = controlSplitNode.getPrimarySuccessor();
                if (primarySuccessor != null) {
                    endBlock.prependChildrenTo(entries.get(primarySuccessor));
                    continue;
                }
                assert (endBlock.tail == null);
            }
            for (HIRBlock b : this.cfg.reversePostOrder()) {
                int totalCount = 0;
                for (FixedNode current : b.getBeginNode().getBlockNodes()) {
                    MicroBlock microBlock = entries.get(current);
                    totalCount += microBlock.getNodeCount() + 1;
                }
                ArrayList<Node> nodes = new ArrayList<Node>(totalCount);
                blockToNodes.put(b, nodes);
                for (FixedNode current : b.getBeginNode().getBlockNodes()) {
                    MicroBlock microBlock = entries.get(current);
                    nodeToBlock.set(current, b);
                    nodes.add(current);
                    for (NodeEntry next = microBlock.getFirstNode(); next != null; next = next.getNext()) {
                        Node nextNode = next.getNode();
                        nodeToBlock.set(nextNode, b);
                        nodes.add(nextNode);
                    }
                }
            }
            assert (!Assertions.detailedAssertionsEnabled(this.cfg.graph.getOptions()) || ScheduleVerification.check(this.cfg.getStartBlock(), blockToNodes, nodeToBlock));
        }

        private static void processNodes(NodeBitMap visited, NodeMap<MicroBlock> entries, NodeStack stack, MicroBlock startBlock, Iterable<? extends Node> nodes) {
            for (Node node : nodes) {
                if (entries.get(node) != null) continue;
                Instance.processStack(node, startBlock, entries, visited, stack);
            }
        }

        private static void processStackPhi(NodeStack stack, PhiNode phiNode, NodeMap<MicroBlock> nodeToBlock, NodeBitMap visited) {
            stack.pop();
            if (visited.checkAndMarkInc(phiNode)) {
                MicroBlock mergeBlock = nodeToBlock.get(phiNode.merge());
                assert (mergeBlock != null) : phiNode;
                nodeToBlock.set(phiNode, mergeBlock);
                AbstractMergeNode merge = phiNode.merge();
                for (int i = 0; i < merge.forwardEndCount(); ++i) {
                    ValueNode input = phiNode.valueAt(i);
                    if (input == null || nodeToBlock.get(input) != null) continue;
                    stack.push(input);
                }
            }
        }

        private static void processStackProxy(NodeStack stack, ProxyNode proxyNode, NodeMap<MicroBlock> nodeToBlock, NodeBitMap visited) {
            stack.pop();
            if (visited.checkAndMarkInc(proxyNode)) {
                nodeToBlock.set(proxyNode, nodeToBlock.get(proxyNode.proxyPoint()));
                ValueNode input = proxyNode.value();
                if (input != null && nodeToBlock.get(input) == null) {
                    stack.push(input);
                }
            }
        }

        private static void processStack(Node first, MicroBlock startBlock, NodeMap<MicroBlock> nodeToMicroBlock, NodeBitMap visited, NodeStack stack) {
            assert (stack.isEmpty());
            assert (!visited.isMarked(first));
            stack.push(first);
            Node current = first;
            while (true) {
                CompilationAlarm.checkProgress(first.graph());
                if (current instanceof PhiNode) {
                    Instance.processStackPhi(stack, (PhiNode)current, nodeToMicroBlock, visited);
                } else if (current instanceof ProxyNode) {
                    Instance.processStackProxy(stack, (ProxyNode)current, nodeToMicroBlock, visited);
                } else {
                    MicroBlock currentBlock = nodeToMicroBlock.get(current);
                    if (currentBlock == null) {
                        MicroBlock earliestBlock = Instance.processInputs(nodeToMicroBlock, stack, startBlock, current);
                        if (earliestBlock != null) {
                            stack.pop();
                            visited.checkAndMarkInc(current);
                            nodeToMicroBlock.set(current, earliestBlock);
                            earliestBlock.add(current);
                        }
                    } else {
                        stack.pop();
                    }
                }
                if (stack.isEmpty()) break;
                current = stack.peek();
            }
        }

        private static MicroBlock processInputs(NodeMap<MicroBlock> nodeToBlock, NodeStack stack, MicroBlock startBlock, Node current) {
            if (current.getNodeClass().isLeafNode()) {
                return startBlock;
            }
            MicroBlock earliestBlock = startBlock;
            for (Node input : current.inputs()) {
                GraalError.guarantee(input != current, "Cannot have direct cycles on schedulable nodes %s", (Object)current);
                MicroBlock inputBlock = nodeToBlock.get(input);
                if (inputBlock == null) {
                    earliestBlock = null;
                    stack.push(input);
                    continue;
                }
                if (earliestBlock == null || inputBlock.getId() <= earliestBlock.getId()) continue;
                earliestBlock = inputBlock;
            }
            return earliestBlock;
        }

        private static boolean isFixedEnd(FixedNode endNode) {
            return endNode instanceof ControlSplitNode || endNode instanceof ControlSinkNode || endNode instanceof AbstractEndNode;
        }

        public String printScheduleHelper(String desc) {
            Formatter buf = new Formatter();
            buf.format("=== %s / %s ===%n", this.getCFG().getStartBlock().getBeginNode().graph(), desc);
            for (HIRBlock b : this.getCFG().getBlocks()) {
                buf.format("==== b: %s (loopDepth: %s). ", b, b.getLoopDepth());
                buf.format("dom: %s. ", b.getDominator());
                int predCount = b.getPredecessorCount();
                Object[] pred = new HIRBlock[predCount];
                for (int i = 0; i < predCount; ++i) {
                    pred[i] = (HIRBlock)b.getPredecessorAt(i);
                }
                int succCount = b.getSuccessorCount();
                Object[] succ = new HIRBlock[succCount];
                for (int i = 0; i < succCount; ++i) {
                    succ[i] = (HIRBlock)b.getSuccessorAt(i);
                }
                buf.format("preds: %s. ", Arrays.toString(pred));
                buf.format("succs: %s ====%n", Arrays.toString(succ));
                if (this.blockToNodesMap.get(b) != null) {
                    for (Node node : this.nodesFor(b)) {
                        Instance.printNode(node);
                    }
                    continue;
                }
                for (Node node : b.getNodes()) {
                    Instance.printNode(node);
                }
            }
            buf.format("%n", new Object[0]);
            return buf.toString();
        }

        private static void printNode(Node n) {
            Formatter buf = new Formatter();
            buf.format("%s", n);
            if (MemoryKill.isSingleMemoryKill(n)) {
                buf.format(" // kills %s", ((SingleMemoryKill)((Object)n)).getKilledLocationIdentity());
            } else if (MemoryKill.isMultiMemoryKill(n)) {
                buf.format(" // kills ", new Object[0]);
                for (LocationIdentity locid : ((MultiMemoryKill)((Object)n)).getKilledLocationIdentities()) {
                    buf.format("%s, ", locid);
                }
            } else if (n instanceof FloatingReadNode) {
                FloatingReadNode frn = (FloatingReadNode)n;
                buf.format(" // from %s", frn.getLocationIdentity());
                buf.format(", lastAccess: %s", frn.getLastLocationAccess());
                buf.format(", address: %s", frn.getAddress());
            } else if (n instanceof GuardNode) {
                buf.format(", anchor: %s", ((GuardNode)n).getAnchor());
            }
            n.getDebug().log("%s", buf);
        }

        public ControlFlowGraph getCFG() {
            return this.cfg;
        }

        public List<Node> nodesFor(HIRBlock block) {
            return this.blockToNodesMap.get(block);
        }

        private static class MicroBlock {
            private final int id;
            private int nodeCount;
            private NodeEntry head;
            private NodeEntry tail;

            MicroBlock(int id) {
                this.id = id;
            }

            public void add(Node node) {
                assert (!(node instanceof FixedNode)) : node;
                NodeEntry newTail = new NodeEntry(node);
                if (this.tail == null) {
                    this.tail = this.head = newTail;
                } else {
                    this.tail.next = newTail;
                    this.tail = newTail;
                }
                ++this.nodeCount;
            }

            public int getNodeCount() {
                assert (this.getActualNodeCount() == this.nodeCount) : this.getActualNodeCount() + " != " + this.nodeCount;
                return this.nodeCount;
            }

            private int getActualNodeCount() {
                int count = 0;
                NodeEntry e = this.head;
                while (e != null) {
                    ++count;
                    e = e.next;
                }
                return count;
            }

            public int getId() {
                return this.id;
            }

            public NodeEntry getFirstNode() {
                return this.head;
            }

            public void prependChildrenTo(MicroBlock newBlock) {
                if (this.tail != null) {
                    assert (this.head != null);
                    this.tail.next = newBlock.head;
                    newBlock.head = this.head;
                    this.tail = null;
                    this.head = null;
                    newBlock.nodeCount += this.nodeCount;
                    this.nodeCount = 0;
                }
            }

            public String toString() {
                return String.format("MicroBlock[id=%d]", this.id);
            }

            public int hashCode() {
                return this.id;
            }
        }

        private static class GuardOrder {
            private GuardOrder() {
            }

            private static void resortGuards(StructuredGraph graph, NodeMap<MicroBlock> entries, NodeStack stack) {
                assert (stack.isEmpty());
                EconomicSet blocksWithGuards = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
                for (GuardNode guard : graph.getNodes(GuardNode.TYPE)) {
                    MicroBlock block = entries.get(guard);
                    assert (block != null) : String.valueOf(guard) + "should already be scheduled to a micro-block";
                    blocksWithGuards.add((Object)block);
                }
                assert (!blocksWithGuards.isEmpty());
                NodeMap<StaticDeoptimizingNode.GuardPriority> priorities = graph.createNodeMap();
                NodeBitMap blockNodes = graph.createNodeBitMap();
                for (MicroBlock block : blocksWithGuards) {
                    MicroBlock newBlock = GuardOrder.resortGuards(block, stack, blockNodes, priorities);
                    assert (stack.isEmpty());
                    assert (blockNodes.isEmpty());
                    if (newBlock == null) continue;
                    assert (block.getNodeCount() == newBlock.getNodeCount()) : Assertions.errorMessage(block, newBlock);
                    block.head = newBlock.head;
                    block.tail = newBlock.tail;
                }
            }

            private static MicroBlock resortGuards(MicroBlock block, NodeStack stack, NodeBitMap blockNodes, NodeMap<StaticDeoptimizingNode.GuardPriority> priorities) {
                if (!GuardOrder.propagatePriority(block, stack, priorities, blockNodes)) {
                    return null;
                }
                Function<GuardNode, StaticDeoptimizingNode.GuardPriority> transitiveGuardPriorityGetter = priorities::get;
                Comparator<GuardNode> globalGuardPriorityComparator = Comparator.comparing(transitiveGuardPriorityGetter).thenComparing(StaticDeoptimizingNode::computePriority).thenComparingInt(Node::hashCode);
                TreeSet<GuardNode> availableGuards = new TreeSet<GuardNode>(globalGuardPriorityComparator);
                MicroBlock newBlock = new MicroBlock(block.getId());
                NodeBitMap sorted = blockNodes;
                sorted.invert();
                NodeEntry e = block.head;
                while (e != null) {
                    GuardOrder.checkIfAvailable(e.node, stack, sorted, newBlock, availableGuards, false);
                    e = e.next;
                }
                while (true) {
                    if (!stack.isEmpty()) {
                        GuardOrder.checkIfAvailable(stack.pop(), stack, sorted, newBlock, availableGuards, true);
                        continue;
                    }
                    Iterator iterator = availableGuards.iterator();
                    if (iterator.hasNext()) {
                        GuardOrder.addNodeToResort((Node)iterator.next(), stack, sorted, newBlock, true);
                        iterator.remove();
                    }
                    if (stack.isEmpty() && availableGuards.isEmpty()) break;
                }
                blockNodes.clearAll();
                return newBlock;
            }

            private static void checkIfAvailable(Node n, NodeStack stack, NodeBitMap sorted, MicroBlock newBlock, SortedSet<GuardNode> availableGuardNodes, boolean pushUsages) {
                if (sorted.isMarked(n)) {
                    return;
                }
                for (Node in : n.inputs()) {
                    if (sorted.isMarked(in)) continue;
                    return;
                }
                if (n instanceof GuardNode) {
                    availableGuardNodes.add((GuardNode)n);
                } else {
                    GuardOrder.addNodeToResort(n, stack, sorted, newBlock, pushUsages);
                }
            }

            private static void addNodeToResort(Node n, NodeStack stack, NodeBitMap sorted, MicroBlock newBlock, boolean pushUsages) {
                sorted.mark(n);
                newBlock.add(n);
                if (pushUsages) {
                    for (Node u : n.usages()) {
                        if (sorted.isMarked(u)) continue;
                        stack.push(u);
                    }
                }
            }

            private static boolean propagatePriority(MicroBlock block, NodeStack stack, NodeMap<StaticDeoptimizingNode.GuardPriority> priorities, NodeBitMap blockNodes) {
                assert (stack.isEmpty());
                assert (blockNodes.isEmpty());
                StaticDeoptimizingNode.GuardPriority lowestPriority = StaticDeoptimizingNode.GuardPriority.highest();
                NodeEntry e = block.head;
                while (e != null) {
                    blockNodes.mark(e.node);
                    if (e.node instanceof GuardNode) {
                        GuardNode guard = (GuardNode)e.node;
                        StaticDeoptimizingNode.GuardPriority priority = guard.computePriority();
                        if (lowestPriority != null) {
                            if (priority.isLowerPriorityThan(lowestPriority)) {
                                lowestPriority = priority;
                            } else if (priority.isHigherPriorityThan(lowestPriority)) {
                                lowestPriority = null;
                            }
                        }
                        stack.push(guard);
                        priorities.set(guard, priority);
                    }
                    e = e.next;
                }
                if (lowestPriority != null) {
                    stack.clear();
                    blockNodes.clearAll();
                    return false;
                }
                do {
                    Node current = stack.pop();
                    assert (blockNodes.isMarked(current));
                    StaticDeoptimizingNode.GuardPriority priority = priorities.get(current);
                    for (Node input : current.inputs()) {
                        StaticDeoptimizingNode.GuardPriority inputPriority;
                        if (!blockNodes.isMarked(input) || (inputPriority = priorities.get(input)) != null && !inputPriority.isLowerPriorityThan(priority)) continue;
                        priorities.set(input, priority);
                        stack.push(input);
                    }
                } while (!stack.isEmpty());
                return true;
            }
        }

        private static class NodeEntry {
            private final Node node;
            private NodeEntry next;

            NodeEntry(Node node) {
                this.node = node;
                this.next = null;
            }

            public NodeEntry getNext() {
                return this.next;
            }

            public Node getNode() {
                return this.node;
            }
        }
    }
}

