/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.util;

import java.util.List;
import java.util.function.Function;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.ControlSinkNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ReturnNode;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;

public class ValueMergeUtil {
    public static ValueNode mergeReturns(AbstractMergeNode merge, List<? extends ReturnNode> returnNodes) {
        return ValueMergeUtil.mergeValueProducers(merge, returnNodes, null, returnNode -> returnNode.result());
    }

    public static ValueNode mergeUnwindExceptions(AbstractMergeNode merge, List<? extends UnwindNode> unwindNodes) {
        return ValueMergeUtil.mergeValueProducers(merge, unwindNodes, null, UnwindNode::exception);
    }

    public static <T> ValueNode mergeValueProducers(AbstractMergeNode merge, List<? extends T> valueProducers, Function<T, FixedWithNextNode> lastInstrFunction, Function<T, ValueNode> valueFunction) {
        ValueNode singleResult = null;
        PhiNode phiResult = null;
        for (T valueProducer : valueProducers) {
            ValueNode result = valueFunction.apply(valueProducer);
            if (result != null) {
                if (phiResult == null && (singleResult == null || singleResult == result)) {
                    singleResult = result;
                } else if (phiResult == null) {
                    phiResult = merge.graph().addWithoutUnique(new ValuePhiNode(result.stamp(NodeView.DEFAULT).unrestricted(), merge));
                    for (int i = 0; i < merge.forwardEndCount(); ++i) {
                        phiResult.addInput(singleResult);
                    }
                    phiResult.addInput(result);
                } else {
                    phiResult.addInput(result);
                }
            }
            EndNode endNode = merge.graph().add(new EndNode());
            merge.addForwardEnd(endNode);
            if (lastInstrFunction == null) {
                assert (valueProducer instanceof ReturnNode || valueProducer instanceof UnwindNode) : Assertions.errorMessage(valueProducer);
                ((ControlSinkNode)valueProducer).replaceAndDelete(endNode);
                continue;
            }
            FixedWithNextNode lastInstr = lastInstrFunction.apply(valueProducer);
            lastInstr.setNext(endNode);
        }
        if (phiResult != null) {
            assert (phiResult.verify());
            phiResult.inferStamp();
            return phiResult;
        }
        return singleResult;
    }
}

