/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.printer;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.code.DisassemblerProvider;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.core.gen.NodeLIRBuilder;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugDumpHandler;
import jdk.graal.compiler.debug.DebugDumpScope;
import jdk.graal.compiler.debug.DebugOptions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.PathUtilities;
import jdk.graal.compiler.debug.TTY;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.debug.IntervalDumper;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.printer.CFGPrinter;
import jdk.graal.compiler.serviceprovider.GraalServices;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.services.Services;

public class CFGPrinterObserver
implements DebugDumpHandler {
    private CFGPrinter cfgPrinter;
    private String cfgFile;
    private JavaMethod curMethod;
    private CompilationIdentifier curCompilation;
    private List<String> curDecorators = Collections.emptyList();
    private LIR lastLIR = null;
    private IntervalDumper delayedIntervals = null;

    @Override
    public void dump(Object object, DebugContext debug, boolean forced, String format, Object ... arguments) {
        String message = String.format(format, arguments);
        try {
            this.dumpSandboxed(debug, object, forced, message);
        }
        catch (Throwable ex) {
            TTY.println("CFGPrinter: Exception during output of " + message + ": " + String.valueOf(ex));
            ex.printStackTrace();
        }
    }

    private boolean checkMethodScope(DebugContext debug) {
        JavaMethod method = null;
        Object compilation = null;
        ArrayList<String> decorators = new ArrayList<String>();
        for (Object o : debug.context()) {
            if (o instanceof JavaMethod) {
                method = (JavaMethod)o;
                decorators.clear();
                continue;
            }
            if (o instanceof StructuredGraph) {
                StructuredGraph graph = (StructuredGraph)o;
                if (graph.method() == null) continue;
                method = graph.method();
                decorators.clear();
                compilation = graph.compilationId();
                continue;
            }
            if (o instanceof DebugDumpScope) {
                DebugDumpScope debugDumpScope = (DebugDumpScope)o;
                if (!debugDumpScope.decorator) continue;
                decorators.add(debugDumpScope.name);
                continue;
            }
            if (!(o instanceof CompilationResult)) continue;
            CompilationResult compilationResult = (CompilationResult)o;
            compilation = compilationResult.getCompilationId();
        }
        if (method == null && compilation == null) {
            return false;
        }
        if (compilation != null) {
            if (!compilation.equals(this.curCompilation) || !this.curDecorators.equals(decorators)) {
                this.cfgPrinter.printCompilation((CompilationIdentifier)compilation);
            }
        } else if (!method.equals((Object)this.curMethod) || !this.curDecorators.equals(decorators)) {
            this.cfgPrinter.printCompilation(method);
        }
        this.curCompilation = compilation;
        this.curMethod = method;
        this.curDecorators = decorators;
        return true;
    }

    public void dumpSandboxed(DebugContext debug, Object object, boolean forced, String message) {
        if (!this.shouldDump(debug, forced)) {
            return;
        }
        this.dumpSandboxed(debug, object, message);
    }

    boolean shouldDump(DebugContext debug, boolean forced) {
        OptionValues options = debug.getOptions();
        if (DebugOptions.PrintBackendCFG.getValue(options).booleanValue() || forced) {
            return true;
        }
        String dump = DebugOptions.Dump.getValue(options);
        return dump != null && (dump.contains("CodeGen") || dump.contains("CodeInstall"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpSandboxed(DebugContext debug, Object object, String message) {
        OptionValues options = debug.getOptions();
        if (this.cfgPrinter == null) {
            try {
                String dumpFile;
                this.cfgFile = dumpFile = debug.getDumpPath(".cfg", false);
                BufferedOutputStream out = new BufferedOutputStream(PathUtilities.openOutputStream(this.cfgFile));
                this.cfgPrinter = new CFGPrinter(out);
            }
            catch (IOException e) {
                throw (GraalError)new GraalError("Could not open %s", this.cfgFile == null ? "[null]" : PathUtilities.getAbsolutePath(this.cfgFile)).initCause(e);
            }
        }
        if (!this.checkMethodScope(debug)) {
            return;
        }
        try {
            if (this.curMethod instanceof ResolvedJavaMethod) {
                this.cfgPrinter.method = (ResolvedJavaMethod)this.curMethod;
            }
            this.cfgPrinter.lir = object instanceof LIR ? (LIR)object : debug.contextLookup(LIR.class);
            this.cfgPrinter.nodeLirGenerator = debug.contextLookup(NodeLIRBuilder.class);
            this.cfgPrinter.res = debug.contextLookup(LIRGenerationResult.class);
            if (this.cfgPrinter.lir != null && this.cfgPrinter.lir.getControlFlowGraph() instanceof ControlFlowGraph) {
                this.cfgPrinter.cfg = (ControlFlowGraph)this.cfgPrinter.lir.getControlFlowGraph();
            }
            CodeCacheProvider codeCache = debug.contextLookup(CodeCacheProvider.class);
            if (object instanceof LIR) {
                this.cfgPrinter.printCFG(message, this.cfgPrinter.lir.getBlocks());
                this.lastLIR = (LIR)object;
                if (this.delayedIntervals != null) {
                    this.cfgPrinter.printIntervals(message, this.delayedIntervals);
                    this.delayedIntervals = null;
                }
            } else if (object instanceof StructuredGraph.ScheduleResult) {
                this.cfgPrinter.printSchedule(message, (StructuredGraph.ScheduleResult)object);
            } else if (object instanceof CompilationResult) {
                compResult = (CompilationResult)object;
                this.cfgPrinter.printMachineCode(CFGPrinterObserver.disassemble(options, codeCache, compResult, null), message);
            } else if (object instanceof InstalledCode) {
                compResult = debug.contextLookup(CompilationResult.class);
                if (compResult != null) {
                    this.cfgPrinter.printMachineCode(CFGPrinterObserver.disassemble(options, codeCache, compResult, (InstalledCode)object), message);
                }
            } else if (object instanceof IntervalDumper) {
                if (this.lastLIR == this.cfgPrinter.lir) {
                    this.cfgPrinter.printIntervals(message, (IntervalDumper)object);
                } else {
                    if (this.delayedIntervals != null) {
                        debug.log("Some delayed intervals were dropped (%s)", this.delayedIntervals);
                    }
                    this.delayedIntervals = (IntervalDumper)object;
                }
            } else if (object instanceof int[]) {
                this.cfgPrinter.printCFG(message, (int[])object);
            }
        }
        finally {
            this.cfgPrinter.lir = null;
            this.cfgPrinter.res = null;
            this.cfgPrinter.nodeLirGenerator = null;
            this.cfgPrinter.cfg = null;
            this.cfgPrinter.flush();
        }
    }

    private static DisassemblerProvider selectDisassemblerProvider(OptionValues options) {
        DisassemblerProvider selected = null;
        String arch = Services.getSavedProperty((String)"os.arch");
        boolean isAArch64 = arch.equals("aarch64");
        for (DisassemblerProvider d : GraalServices.load(DisassemblerProvider.class)) {
            if (!d.isAvailable(options)) continue;
            String name = d.getName();
            if (isAArch64 && name.equals("objdump")) {
                return d;
            }
            if (!name.equals("hcf")) continue;
            if (!isAArch64) {
                return d;
            }
            selected = d;
        }
        if (selected == null) {
            selected = new DisassemblerProvider(){

                @Override
                public String getName() {
                    return "nop";
                }
            };
        }
        return selected;
    }

    private static String disassemble(OptionValues options, CodeCacheProvider codeCache, CompilationResult compResult, InstalledCode installedCode) {
        DisassemblerProvider dis = CFGPrinterObserver.selectDisassemblerProvider(options);
        if (installedCode != null) {
            return dis.disassembleInstalledCode(codeCache, compResult, installedCode);
        }
        return dis.disassembleCompiledCode(options, codeCache, compResult);
    }

    @Override
    public void close() {
        if (this.cfgPrinter != null) {
            this.cfgPrinter.close();
            this.cfgPrinter = null;
            this.curDecorators = Collections.emptyList();
            this.curMethod = null;
            this.curCompilation = null;
        }
    }
}

