/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.printer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.core.common.Fields;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugOptions;
import jdk.graal.compiler.debug.PathUtilities;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeMap;
import jdk.graal.compiler.graph.Position;
import jdk.graal.compiler.nodeinfo.Verbosity;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.FullInfopointNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ProxyNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.printer.GraphPrinter;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class CanonicalStringGraphPrinter
implements GraphPrinter {
    private static final Pattern IDENTITY_PATTERN = Pattern.compile("([A-Za-z0-9$_]+)@[0-9a-f]+");
    private final SnippetReflectionProvider snippetReflection;
    private StructuredGraph currentGraph;
    private String currentDirectory;

    public CanonicalStringGraphPrinter(SnippetReflectionProvider snippetReflection) {
        this.snippetReflection = snippetReflection;
    }

    @Override
    public SnippetReflectionProvider getSnippetReflectionProvider() {
        return this.snippetReflection;
    }

    private static String removeIdentities(String str) {
        return IDENTITY_PATTERN.matcher(str).replaceAll("$1");
    }

    protected static void writeCanonicalGraphExpressionString(ValueNode node, boolean checkConstants, boolean removeIdentities, PrintWriter writer) {
        writer.print(node.getClass().getSimpleName());
        writer.print("(");
        Fields properties = node.getNodeClass().getData();
        for (int i = 0; i < properties.getCount(); ++i) {
            String dataStr = String.valueOf(properties.get(node, i));
            if (removeIdentities) {
                dataStr = CanonicalStringGraphPrinter.removeIdentities(dataStr);
            }
            writer.print(dataStr);
            if (i + 1 >= properties.getCount() && !node.inputPositions().iterator().hasNext()) continue;
            writer.print(", ");
        }
        Iterator<Position> iterator = node.inputPositions().iterator();
        while (iterator.hasNext()) {
            Position position = iterator.next();
            Node input = position.get(node);
            if (checkConstants && input instanceof ConstantNode) {
                ConstantNode constantNode = (ConstantNode)input;
                String valueString = constantNode.getValue().toValueString();
                if (removeIdentities) {
                    valueString = CanonicalStringGraphPrinter.removeIdentities(valueString);
                }
                writer.print(valueString);
            } else if (input instanceof ValueNode && !(input instanceof PhiNode) && !(input instanceof FixedNode)) {
                CanonicalStringGraphPrinter.writeCanonicalGraphExpressionString((ValueNode)input, checkConstants, removeIdentities, writer);
            } else if (input == null) {
                writer.print("null");
            } else {
                writer.print(input.getClass().getSimpleName());
            }
            if (!iterator.hasNext()) continue;
            writer.print(", ");
        }
        writer.print(")");
    }

    protected static void writeCanonicalExpressionCFGString(StructuredGraph graph, boolean checkConstants, boolean removeIdentities, PrintWriter writer) {
        ControlFlowGraph controlFlowGraph = CanonicalStringGraphPrinter.getControlFlowGraph(graph);
        if (controlFlowGraph == null) {
            return;
        }
        try {
            for (HIRBlock block : controlFlowGraph.getBlocks()) {
                writer.print("Block ");
                writer.print(block);
                writer.print(" ");
                if (block == controlFlowGraph.getStartBlock()) {
                    writer.print("* ");
                }
                writer.print("-> ");
                for (int i = 0; i < block.getSuccessorCount(); ++i) {
                    HIRBlock successor = (HIRBlock)block.getSuccessorAt(i);
                    writer.print(successor);
                    writer.print(" ");
                }
                writer.println();
                FixedNode node = block.getBeginNode();
                while (node != null) {
                    CanonicalStringGraphPrinter.writeCanonicalGraphExpressionString(node, checkConstants, removeIdentities, writer);
                    writer.println();
                    if (node instanceof FixedWithNextNode) {
                        node = ((FixedWithNextNode)node).next();
                        continue;
                    }
                    node = null;
                }
            }
        }
        catch (Throwable e) {
            writer.println();
            e.printStackTrace(writer);
        }
    }

    protected static ControlFlowGraph getControlFlowGraph(StructuredGraph graph) {
        try {
            return ControlFlowGraph.newBuilder(graph).connectBlocks(true).computeLoops(true).computeFrequency(true).build();
        }
        catch (Throwable e) {
            return null;
        }
    }

    protected static void writeCanonicalGraphString(StructuredGraph graph, boolean excludeVirtual, boolean checkConstants, PrintWriter writer) {
        StructuredGraph.ScheduleResult scheduleResult = GraphPrinter.getScheduleOrNull(graph);
        if (scheduleResult == null) {
            return;
        }
        try {
            NodeMap<Integer> canonicalId = graph.createNodeMap();
            int nextId = 0;
            ArrayList<CallSite> constantsLines = null;
            if (checkConstants) {
                constantsLines = new ArrayList<CallSite>();
            }
            for (HIRBlock block : scheduleResult.getCFG().getBlocks()) {
                writer.print("Block ");
                writer.print(block);
                writer.print(" ");
                if (block == scheduleResult.getCFG().getStartBlock()) {
                    writer.print("* ");
                }
                writer.print("-> ");
                for (int i = 0; i < block.getSuccessorCount(); ++i) {
                    HIRBlock successor = (HIRBlock)block.getSuccessorAt(i);
                    writer.print(successor);
                    writer.print(" ");
                }
                writer.println();
                for (Node node : scheduleResult.getBlockToNodesMap().get(block)) {
                    int id;
                    if (!(node instanceof ValueNode) || !node.isAlive() || excludeVirtual && (node instanceof VirtualObjectNode || node instanceof ProxyNode || node instanceof FullInfopointNode)) continue;
                    if (node instanceof ConstantNode) {
                        if (constantsLines == null) continue;
                        String name = node.toString(Verbosity.Name);
                        String str = name + (String)(excludeVirtual ? "" : "    (" + CanonicalStringGraphPrinter.filteredUsageCount(node) + ")");
                        constantsLines.add((CallSite)((Object)str));
                        continue;
                    }
                    if (canonicalId.get(node) != null) {
                        id = (Integer)canonicalId.get(node);
                    } else {
                        id = nextId++;
                        canonicalId.set(node, id);
                    }
                    String name = node.getClass().getSimpleName();
                    writer.print("  ");
                    writer.print(id);
                    writer.print("|");
                    writer.print(name);
                    if (!excludeVirtual) {
                        writer.print("    (");
                        writer.print(CanonicalStringGraphPrinter.filteredUsageCount(node));
                        writer.print(")");
                    }
                    writer.println();
                }
            }
            if (constantsLines != null) {
                writer.print(constantsLines.size());
                writer.println(" constants:");
                Collections.sort(constantsLines);
                for (String string : constantsLines) {
                    writer.println(string);
                }
            }
        }
        catch (Throwable t) {
            writer.println();
            t.printStackTrace(writer);
        }
    }

    public static String getCanonicalGraphString(StructuredGraph graph, boolean excludeVirtual, boolean checkConstants) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        CanonicalStringGraphPrinter.writeCanonicalGraphString(graph, excludeVirtual, checkConstants, writer);
        writer.flush();
        return stringWriter.toString();
    }

    private static int filteredUsageCount(Node node) {
        return node.usages().filter(n -> !(n instanceof FrameState)).count();
    }

    @Override
    public void beginGroup(DebugContext debug, String name, String shortName, ResolvedJavaMethod method, int bci, Map<Object, Object> properties) throws IOException {
    }

    private String getDirectory(DebugContext debug, StructuredGraph graph) {
        if (graph == this.currentGraph) {
            return this.currentDirectory;
        }
        this.currentDirectory = debug.getDumpPath(".graph-strings", true);
        this.currentGraph = graph;
        return this.currentDirectory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void print(DebugContext debug, Graph graph, Map<Object, Object> properties, int id, String format, Object ... args) throws IOException {
        if (!(graph instanceof StructuredGraph)) return;
        OptionValues options = graph.getOptions();
        StructuredGraph structuredGraph = (StructuredGraph)graph;
        String outDirectory = this.getDirectory(debug, structuredGraph);
        String title = String.format("%03d-%s.txt", id, String.format(format, this.simplifyClassArgs(args)));
        String filePath = PathUtilities.getPath(outDirectory, PathUtilities.sanitizeFileName(title));
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(PathUtilities.openOutputStream(filePath))));){
            switch (DebugOptions.PrintCanonicalGraphStringFlavor.getValue(options)) {
                case 1: {
                    CanonicalStringGraphPrinter.writeCanonicalExpressionCFGString(structuredGraph, DebugOptions.CanonicalGraphStringsCheckConstants.getValue(options), DebugOptions.CanonicalGraphStringsRemoveIdentities.getValue(options), writer);
                    return;
                }
                default: {
                    CanonicalStringGraphPrinter.writeCanonicalGraphString(structuredGraph, DebugOptions.CanonicalGraphStringsExcludeVirtuals.getValue(options), DebugOptions.CanonicalGraphStringsCheckConstants.getValue(options), writer);
                    return;
                }
            }
        }
    }

    @Override
    public void endGroup() throws IOException {
    }

    @Override
    public void close() {
    }
}

