/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import jdk.graal.compiler.bytecode.BytecodeProvider;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.TimerKey;
import jdk.graal.compiler.graph.SourceLanguagePositionProvider;
import jdk.graal.compiler.java.GraphBuilderPhase;
import jdk.graal.compiler.loop.phases.ConvertDeoptimizeToGuardPhase;
import jdk.graal.compiler.nodes.EncodedGraph;
import jdk.graal.compiler.nodes.GraphEncoder;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.IntrinsicContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.nodes.graphbuilderconf.LoopExplosionPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.NodePlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.ParameterPlugin;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.DominatorBasedGlobalValueNumberingPhase;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.PEGraphDecoder;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicMap;

public class CachingPEGraphDecoder
extends PEGraphDecoder {
    private static final TimerKey BuildGraphTimer = DebugContext.timer("PartialEvaluation-GraphBuilding");
    protected final Providers providers;
    protected final GraphBuilderConfiguration graphBuilderConfig;
    protected final OptimisticOptimizations optimisticOpts;
    private final EconomicMap<ResolvedJavaMethod, EncodedGraph> persistentGraphCache;
    private final EconomicMap<ResolvedJavaMethod, EncodedGraph> localGraphCache;
    private final Supplier<AutoCloseable> createPersistentCachedGraphScope;
    private final BasePhase<? super CoreProviders> postParsingPhase;
    private final boolean allowAssumptionsDuringParsing;

    public CachingPEGraphDecoder(Architecture architecture, StructuredGraph graph, Providers providers, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, LoopExplosionPlugin loopExplosionPlugin, InvocationPlugins invocationPlugins, InlineInvokePlugin[] inlineInvokePlugins, ParameterPlugin parameterPlugin, NodePlugin[] nodePlugins, ResolvedJavaMethod peRootForInlining, SourceLanguagePositionProvider sourceLanguagePositionProvider, BasePhase<? super CoreProviders> postParsingPhase, EconomicMap<ResolvedJavaMethod, EncodedGraph> persistentGraphCache, Supplier<AutoCloseable> createPersistentCachedGraphScope, boolean allowAssumptionsDuringParsing, boolean needsExplicitException, boolean forceLink) {
        super(architecture, graph, providers, loopExplosionPlugin, invocationPlugins, inlineInvokePlugins, parameterPlugin, nodePlugins, peRootForInlining, sourceLanguagePositionProvider, new ConcurrentHashMap<PEGraphDecoder.SpecialCallTargetCacheKey, Object>(), new ConcurrentHashMap<ResolvedJavaMethod, Object>(), needsExplicitException, forceLink);
        assert (!graphBuilderConfig.trackNodeSourcePosition() || graph.trackNodeSourcePosition());
        this.providers = providers;
        this.graphBuilderConfig = graphBuilderConfig;
        this.optimisticOpts = optimisticOpts;
        this.postParsingPhase = postParsingPhase;
        this.persistentGraphCache = persistentGraphCache;
        this.createPersistentCachedGraphScope = createPersistentCachedGraphScope;
        this.localGraphCache = EconomicMap.create();
        this.allowAssumptionsDuringParsing = allowAssumptionsDuringParsing;
    }

    protected GraphBuilderPhase.Instance createGraphBuilderPhaseInstance(IntrinsicContext initialIntrinsicContext) {
        return new GraphBuilderPhase.Instance(this.providers, this.graphBuilderConfig, this.optimisticOpts, initialIntrinsicContext);
    }

    private EncodedGraph createGraph(ResolvedJavaMethod method, BytecodeProvider intrinsicBytecodeProvider) {
        CanonicalizerPhase canonicalizer = CanonicalizerPhase.create();
        if (this.graph.isSubstitution() && Services.IS_IN_NATIVE_IMAGE) {
            throw GraalError.shouldNotReachHere("dead path");
        }
        StructuredGraph graphToEncode = this.buildGraph(method, intrinsicBytecodeProvider, canonicalizer);
        try (DebugContext.Scope scope = this.debug.scope((Object)"createGraph", graphToEncode);){
            new ConvertDeoptimizeToGuardPhase(canonicalizer).apply(graphToEncode, this.providers);
            if (GraalOptions.EarlyGVN.getValue(graphToEncode.getOptions()).booleanValue()) {
                new DominatorBasedGlobalValueNumberingPhase(canonicalizer).apply(graphToEncode, this.providers);
            }
        }
        catch (Throwable t) {
            throw this.debug.handle(t);
        }
        return GraphEncoder.encodeSingleGraph(graphToEncode, this.architecture);
    }

    private StructuredGraph buildGraph(ResolvedJavaMethod method, BytecodeProvider intrinsicBytecodeProvider, CanonicalizerPhase canonicalizer) {
        StructuredGraph graphToEncode = new StructuredGraph.Builder(this.options, this.debug, StructuredGraph.AllowAssumptions.ifTrue(this.allowAssumptionsDuringParsing)).profileProvider(null).trackNodeSourcePosition(this.graphBuilderConfig.trackNodeSourcePosition()).method(method).cancellable(this.graph.getCancellable()).build();
        try (DebugContext.Scope scope = this.debug.scope((Object)"buildGraph", graphToEncode);
             DebugCloseable a = BuildGraphTimer.start(this.debug);){
            if (intrinsicBytecodeProvider != null) {
                throw GraalError.shouldNotReachHere("isn't this dead?");
            }
            IntrinsicContext initialIntrinsicContext = null;
            GraphBuilderPhase.Instance graphBuilderPhaseInstance = this.createGraphBuilderPhaseInstance(initialIntrinsicContext);
            graphBuilderPhaseInstance.apply(graphToEncode);
            canonicalizer.apply(graphToEncode, this.providers);
            if (this.postParsingPhase != null) {
                this.postParsingPhase.apply(graphToEncode, this.providers);
            }
        }
        catch (Throwable ex) {
            throw this.debug.handle(ex);
        }
        return graphToEncode;
    }

    private EncodedGraph lookupOrCreatePersistentEncodedGraph(ResolvedJavaMethod method, BytecodeProvider intrinsicBytecodeProvider) {
        EncodedGraph result = (EncodedGraph)this.persistentGraphCache.get((Object)method);
        if (result == null && method.hasBytecodes()) {
            try (AutoCloseable scope = this.createPersistentCachedGraphScope.get();){
                result = this.createGraph(method, intrinsicBytecodeProvider);
            }
            catch (Throwable ex) {
                throw this.debug.handle(ex);
            }
            this.persistentGraphCache.put((Object)method, (Object)result);
        }
        return result;
    }

    @Override
    protected EncodedGraph lookupEncodedGraph(ResolvedJavaMethod method, BytecodeProvider intrinsicBytecodeProvider) {
        EncodedGraph result = (EncodedGraph)this.localGraphCache.get((Object)method);
        if (result != null) {
            return result;
        }
        result = this.lookupOrCreatePersistentEncodedGraph(method, intrinsicBytecodeProvider);
        if (result != null && !result.trackNodeSourcePosition() && this.graph.trackNodeSourcePosition()) {
            assert (method.hasBytecodes());
            result = this.createGraph(method, intrinsicBytecodeProvider);
            assert (result.trackNodeSourcePosition());
        }
        if (result != null) {
            this.localGraphCache.put((Object)method, (Object)result);
        }
        return result;
    }
}

