/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements;

import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.core.common.type.DataPointerConstant;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderTool;
import jdk.graal.compiler.nodes.graphbuilderconf.ParameterPlugin;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;

public class ConstantBindingParameterPlugin
implements ParameterPlugin {
    private final Object[] constantArgs;
    private final MetaAccessProvider metaAccess;
    private final SnippetReflectionProvider snippetReflection;

    public ConstantBindingParameterPlugin(Object[] constantArgs, MetaAccessProvider metaAccess, SnippetReflectionProvider snippetReflection) {
        this.constantArgs = constantArgs;
        this.metaAccess = metaAccess;
        this.snippetReflection = snippetReflection;
    }

    @Override
    public FloatingNode interceptParameter(GraphBuilderTool b, int index, StampPair stamp) {
        Object arg;
        if (index < this.constantArgs.length && (arg = this.constantArgs[index]) != null) {
            ConstantNode constantNode;
            if (arg instanceof ConstantNode) {
                ConstantNode otherCon = (ConstantNode)arg;
                constantNode = otherCon.graph() != b.getGraph() ? ConstantNode.forConstant(otherCon.stamp(NodeView.DEFAULT), otherCon.getValue(), otherCon.getStableDimension(), otherCon.isDefaultStable(), this.metaAccess) : otherCon;
            } else if (arg instanceof DataPointerConstant) {
                constantNode = ConstantNode.forConstant(StampFactory.pointer(), (Constant)arg, this.metaAccess);
            } else if (arg instanceof Constant) {
                constantNode = ConstantNode.forConstant(stamp.getTrustedStamp(), (Constant)arg, this.metaAccess);
            } else {
                JavaKind kind = stamp.getTrustedStamp().getStackKind();
                constantNode = ConstantNode.forConstant(this.snippetReflection.forBoxed(kind, arg), this.metaAccess);
            }
            return constantNode;
        }
        return null;
    }
}

