/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements;

import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.core.common.spi.ForeignCallsProvider;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.graphbuilderconf.GeneratedPluginInjectionProvider;
import jdk.graal.compiler.replacements.arraycopy.ArrayCopyForeignCalls;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;

public class NodeIntrinsificationProvider
implements GeneratedPluginInjectionProvider {
    public static final TargetDescription INJECTED_TARGET = null;
    private final MetaAccessProvider metaAccess;
    private final SnippetReflectionProvider snippetReflection;
    private final ForeignCallsProvider foreignCalls;
    private final WordTypes wordTypes;
    private final TargetDescription target;

    public NodeIntrinsificationProvider(MetaAccessProvider metaAccess, SnippetReflectionProvider snippetReflection, ForeignCallsProvider foreignCalls, WordTypes wordTypes, TargetDescription target) {
        this.metaAccess = metaAccess;
        this.snippetReflection = snippetReflection;
        this.foreignCalls = foreignCalls;
        this.wordTypes = wordTypes;
        this.target = target;
    }

    @Override
    public Stamp getInjectedStamp(Class<?> type, boolean nonNull) {
        JavaKind kind = JavaKind.fromJavaClass(type);
        if (kind == JavaKind.Object) {
            ResolvedJavaType returnType = this.metaAccess.lookupJavaType(type);
            if (this.wordTypes.isWord((JavaType)returnType)) {
                return this.wordTypes.getWordStamp(returnType);
            }
            return StampFactory.object(TypeReference.createWithoutAssumptions(returnType), nonNull);
        }
        return StampFactory.forKind(kind);
    }

    @Override
    public <T> T getInjectedArgument(Class<T> type) {
        T injected = this.snippetReflection.getInjectedNodeIntrinsicParameter(type);
        if (injected != null) {
            return injected;
        }
        if (type.equals(ForeignCallsProvider.class) || type.equals(ArrayCopyForeignCalls.class)) {
            return type.cast(this.foreignCalls);
        }
        if (type.equals(SnippetReflectionProvider.class)) {
            return type.cast(this.snippetReflection);
        }
        if (type.equals(WordTypes.class)) {
            return type.cast(this.wordTypes);
        }
        if (type.equals(TargetDescription.class)) {
            return type.cast(this.target);
        }
        throw new GraalError("Cannot handle injected argument of type %s.", type.getName());
    }
}

