/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements;

import java.util.BitSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.api.replacements.SnippetTemplateCache;
import jdk.graal.compiler.bytecode.BytecodeProvider;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.spi.ForeignCallsProvider;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugHandlersFactory;
import jdk.graal.compiler.debug.DebugOptions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.TimerKey;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.java.GraphBuilderPhase;
import jdk.graal.compiler.loop.phases.ConvertDeoptimizeToGuardPhase;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GeneratedInvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.IntrinsicContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.spi.Replacements;
import jdk.graal.compiler.nodes.spi.SnippetParameterInfo;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.DeadCodeEliminationPhase;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.ConstantBindingParameterPlugin;
import jdk.graal.compiler.replacements.NonNullParameterPlugin;
import jdk.graal.compiler.replacements.SnippetCounterNode;
import jdk.graal.compiler.replacements.arraycopy.ArrayCopyForeignCalls;
import jdk.graal.compiler.word.Word;
import jdk.graal.compiler.word.WordOperationPlugin;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.Pair;

public abstract class ReplacementsImpl
implements Replacements,
InlineInvokePlugin {
    protected Providers providers;
    public final SnippetReflectionProvider snippetReflection;
    public final TargetDescription target;
    protected GraphBuilderConfiguration.Plugins graphBuilderPlugins;
    private final DebugHandlersFactory debugHandlersFactory;
    protected final ConcurrentMap<Pair<ResolvedJavaMethod, OptionValues>, StructuredGraph> graphs;
    protected final BytecodeProvider defaultBytecodeProvider;
    private static final int MAX_GRAPH_INLINING_DEPTH = 100;
    private final EconomicMap<String, SnippetTemplateCache> snippetTemplateCache;
    private static final TimerKey SnippetPreparationTime = DebugContext.timer("SnippetPreparationTime");
    private static final AtomicInteger nextDebugContextId = new AtomicInteger();

    @Override
    public Providers getProviders() {
        return this.providers;
    }

    public void setProviders(Providers providers) {
        this.providers = providers.copyWith(this);
    }

    public void setGraphBuilderPlugins(GraphBuilderConfiguration.Plugins plugins) {
        assert (this.graphBuilderPlugins == null);
        this.graphBuilderPlugins = plugins;
    }

    @Override
    public GraphBuilderConfiguration.Plugins getGraphBuilderPlugins() {
        return this.graphBuilderPlugins;
    }

    @Override
    public <T> T getInjectedArgument(Class<T> capability) {
        if (capability.equals(TargetDescription.class)) {
            return (T)this.target;
        }
        if (capability.equals(ForeignCallsProvider.class)) {
            return (T)this.getProviders().getForeignCalls();
        }
        if (capability.equals(ArrayCopyForeignCalls.class) && this.getProviders().getForeignCalls() instanceof ArrayCopyForeignCalls) {
            return (T)this.getProviders().getForeignCalls();
        }
        if (capability.equals(SnippetReflectionProvider.class)) {
            return (T)this.snippetReflection;
        }
        if (capability.isAssignableFrom(WordTypes.class)) {
            return (T)this.getProviders().getWordTypes();
        }
        throw GraalError.shouldNotReachHere(capability.toString());
    }

    @Override
    public Stamp getInjectedStamp(Class<?> type, boolean nonNull) {
        JavaKind kind = JavaKind.fromJavaClass(type);
        if (kind == JavaKind.Object) {
            WordTypes wordTypes = this.getProviders().getWordTypes();
            if (wordTypes.isWord(type)) {
                return wordTypes.getWordStamp(type);
            }
            ResolvedJavaType returnType = this.providers.getMetaAccess().lookupJavaType(type);
            return StampFactory.object(TypeReference.createWithoutAssumptions(returnType), nonNull);
        }
        return StampFactory.forKind(kind);
    }

    @Override
    public Class<? extends GraphBuilderPlugin> getIntrinsifyingPlugin(ResolvedJavaMethod method) {
        if (!Services.IS_IN_NATIVE_IMAGE) {
            if (method.getAnnotation(Node.NodeIntrinsic.class) != null || method.getAnnotation(Fold.class) != null) {
                return GeneratedInvocationPlugin.class;
            }
            if (method.getAnnotation(Word.Operation.class) != null) {
                return WordOperationPlugin.class;
            }
        }
        return null;
    }

    @Override
    public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
        if (b.parsingIntrinsic()) {
            assert (b.getDepth() < 100) : "inlining limit exceeded";
            return InlineInvokePlugin.InlineInfo.createIntrinsicInlineInfo(method, this.defaultBytecodeProvider);
        }
        assert (Services.IS_BUILDING_NATIVE_IMAGE || method.getAnnotation(Node.NodeIntrinsic.class) == null) : String.format("@%s method %s must only be called from within a replacement%n%s", Node.NodeIntrinsic.class.getSimpleName(), method.format("%h.%n"), b);
        return null;
    }

    @Override
    public void notifyNotInlined(GraphBuilderContext b, ResolvedJavaMethod method, Invoke invoke) {
        IntrinsicContext intrinsic;
        if (b.parsingIntrinsic() && !(intrinsic = b.getIntrinsic()).isCallToOriginal(method)) {
            Class<? extends GraphBuilderPlugin> pluginClass = this.getIntrinsifyingPlugin(method);
            if (pluginClass != null) {
                String methodDesc = method.format("%H.%n(%p)");
                throw new GraalError("Call to %s should have been intrinsified by a %s. This is typically caused by Eclipse failing to run an annotation processor. This can usually be fixed by forcing Eclipse to rebuild the source file in which %s is declared", methodDesc, pluginClass.getSimpleName(), methodDesc);
            }
            throw new GraalError("All non-recursive calls in the intrinsic %s must be inlined or intrinsified: found call to %s", intrinsic.getIntrinsicMethod().format("%H.%n(%p)"), method.format("%h.%n(%p)"));
        }
    }

    public ReplacementsImpl(DebugHandlersFactory debugHandlersFactory, Providers providers, SnippetReflectionProvider snippetReflection, BytecodeProvider bytecodeProvider, TargetDescription target) {
        this.providers = providers.copyWith(this);
        this.snippetReflection = snippetReflection;
        this.target = target;
        this.graphs = new ConcurrentHashMap<Pair<ResolvedJavaMethod, OptionValues>, StructuredGraph>();
        this.snippetTemplateCache = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        this.defaultBytecodeProvider = bytecodeProvider;
        this.debugHandlersFactory = debugHandlersFactory;
    }

    @Override
    public DebugContext openSnippetDebugContext(String idPrefix, ResolvedJavaMethod method, DebugContext outer, OptionValues options) {
        if (DebugOptions.DebugStubsAndSnippets.getValue(options).booleanValue()) {
            return this.openDebugContext(idPrefix, method, options, outer, false);
        }
        if (DebugOptions.DumpOnError.getValue(options).booleanValue()) {
            return this.openDebugContext(idPrefix, method, options, outer, true);
        }
        return DebugContext.disabled(options);
    }

    public DebugContext openSnippetDebugContext(String idPrefix, ResolvedJavaMethod method, OptionValues options) {
        return this.openSnippetDebugContext(idPrefix, method, DebugContext.forCurrentThread(), options);
    }

    public DebugContext openDebugContext(String idPrefix, ResolvedJavaMethod method, OptionValues options) {
        return this.openDebugContext(idPrefix, method, options, DebugContext.forCurrentThread(), false);
    }

    private DebugContext openDebugContext(String idPrefix, ResolvedJavaMethod method, OptionValues options, DebugContext outer, boolean disabled) {
        DebugContext.Description description = new DebugContext.Description(method, idPrefix + nextDebugContextId.incrementAndGet());
        return new DebugContext.Builder(options, this.debugHandlersFactory).globalMetrics(outer.getGlobalMetrics()).description(description).disabled(disabled).build();
    }

    @Override
    public StructuredGraph getSnippet(ResolvedJavaMethod method, ResolvedJavaMethod recursiveEntry, Object[] args, BitSet nonNullParameters, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition, OptionValues options) {
        StructuredGraph graph;
        assert (method.getAnnotation(Snippet.class) != null) : "Snippet must be annotated with @" + Snippet.class.getSimpleName();
        assert (method.hasBytecodes()) : "Snippet must not be abstract or native";
        Pair cacheKey = Pair.create((Object)method, (Object)options);
        StructuredGraph structuredGraph = graph = GraalOptions.UseSnippetGraphCache.getValue(options) != false ? (StructuredGraph)this.graphs.get(cacheKey) : null;
        if (graph == null || trackNodeSourcePosition && !graph.trackNodeSourcePosition()) {
            try (DebugContext debug = this.openSnippetDebugContext("Snippet_", method, options);
                 DebugCloseable a = SnippetPreparationTime.start(debug);){
                StructuredGraph newGraph = this.makeGraph(debug, this.defaultBytecodeProvider, method, args, nonNullParameters, recursiveEntry, trackNodeSourcePosition, replaceePosition, IntrinsicContext.CompilationContext.INLINE_AFTER_PARSING);
                DebugContext.counter("SnippetNodeCount[%#s]", method).add(newGraph.getDebug(), newGraph.getNodeCount());
                if (!GraalOptions.UseSnippetGraphCache.getValue(options).booleanValue() || args != null) {
                    StructuredGraph structuredGraph2 = newGraph;
                    return structuredGraph2;
                }
                newGraph.freeze();
                if (graph != null) {
                    this.graphs.replace((Pair<ResolvedJavaMethod, OptionValues>)cacheKey, graph, newGraph);
                } else {
                    this.graphs.putIfAbsent((Pair<ResolvedJavaMethod, OptionValues>)cacheKey, newGraph);
                }
                graph = (StructuredGraph)this.graphs.get(cacheKey);
            }
        }
        assert (!trackNodeSourcePosition || graph.trackNodeSourcePosition());
        return graph;
    }

    @Override
    public SnippetParameterInfo getSnippetParameterInfo(ResolvedJavaMethod method) {
        return new SnippetParameterInfo(method);
    }

    @Override
    public boolean isSnippet(ResolvedJavaMethod method) {
        return method.getAnnotation(Snippet.class) != null;
    }

    @Override
    public void registerSnippet(ResolvedJavaMethod method, ResolvedJavaMethod original, Object receiver, boolean trackNodeSourcePosition, OptionValues options) {
    }

    @Override
    public void registerConditionalPlugin(InvocationPlugin plugin) {
    }

    @Override
    public boolean hasSubstitution(ResolvedJavaMethod method, OptionValues options) {
        return false;
    }

    @Override
    public BytecodeProvider getDefaultReplacementBytecodeProvider() {
        return this.defaultBytecodeProvider;
    }

    @Override
    public StructuredGraph getInlineSubstitution(ResolvedJavaMethod method, int invokeBci, Invoke.InlineControl inlineControl, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition, StructuredGraph.AllowAssumptions allowAssumptions, OptionValues options) {
        return null;
    }

    public StructuredGraph makeGraph(DebugContext debug, BytecodeProvider bytecodeProvider, ResolvedJavaMethod method, Object[] args, BitSet nonNullParameters, ResolvedJavaMethod original, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition, IntrinsicContext.CompilationContext context) {
        return this.createGraphMaker(method, original).makeGraph(debug, bytecodeProvider, args, nonNullParameters, trackNodeSourcePosition, replaceePosition, context);
    }

    public final StructuredGraph makeGraph(DebugContext debug, BytecodeProvider bytecodeProvider, ResolvedJavaMethod method, Object[] args, BitSet nonNullParameters, ResolvedJavaMethod original, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition) {
        return this.makeGraph(debug, bytecodeProvider, method, args, nonNullParameters, original, trackNodeSourcePosition, replaceePosition, IntrinsicContext.CompilationContext.INLINE_AFTER_PARSING);
    }

    protected abstract GraphMaker createGraphMaker(ResolvedJavaMethod var1, ResolvedJavaMethod var2);

    @Override
    public void registerSnippetTemplateCache(SnippetTemplateCache templates) {
        assert (this.snippetTemplateCache.get((Object)templates.getClass().getName()) == null);
        this.snippetTemplateCache.put((Object)templates.getClass().getName(), (Object)templates);
    }

    @Override
    public <T extends SnippetTemplateCache> T getSnippetTemplateCache(Class<T> templatesClass) {
        SnippetTemplateCache ret = (SnippetTemplateCache)this.snippetTemplateCache.get((Object)templatesClass.getName());
        return (T)((SnippetTemplateCache)templatesClass.cast(ret));
    }

    @Override
    public JavaKind getWordKind() {
        return this.getProviders().getWordTypes().getWordKind();
    }

    public static abstract class GraphMaker {
        protected final ReplacementsImpl replacements;
        protected final ResolvedJavaMethod method;
        protected final ResolvedJavaMethod substitutedMethod;

        public GraphMaker(ReplacementsImpl replacements, ResolvedJavaMethod substitute, ResolvedJavaMethod substitutedMethod) {
            this.replacements = replacements;
            this.method = substitute;
            this.substitutedMethod = substitutedMethod;
        }

        public StructuredGraph makeGraph(DebugContext debug, BytecodeProvider bytecodeProvider, Object[] args, BitSet nonNullParameters, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition, IntrinsicContext.CompilationContext context) {
            DebugContext.Scope s = debug.scope((Object)"BuildSnippetGraph", this.method);
            try {
                assert (this.method.hasBytecodes()) : this.method;
                StructuredGraph graph = this.buildInitialGraph(debug, bytecodeProvider, this.method, args, nonNullParameters, trackNodeSourcePosition, replaceePosition, context);
                this.finalizeGraph(graph);
                debug.dump(2, (Object)graph, "%s: Final", this.method.getName());
                StructuredGraph structuredGraph = graph;
                if (s != null) {
                    s.close();
                }
                return structuredGraph;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    throw debug.handle(e);
                }
            }
        }

        protected void finalizeGraph(StructuredGraph graph) {
            if (!GraalOptions.SnippetCounters.getValue(graph.getOptions()).booleanValue() || graph.getNodes().filter(SnippetCounterNode.class).isEmpty()) {
                int sideEffectCount = 0;
                int countSE = graph.getNodes().filter(e -> this.hasSideEffect(e)).count();
                assert ((sideEffectCount = countSE) >= 0) : "Side effect counts must match " + sideEffectCount + " " + countSE;
                new ConvertDeoptimizeToGuardPhase(CanonicalizerPhase.create()).apply(graph, this.replacements.getProviders());
                assert (sideEffectCount == graph.getNodes().filter(e -> this.hasSideEffect(e)).count()) : "deleted side effecting node";
                new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Required).apply(graph);
            }
        }

        private boolean hasSideEffect(Node node) {
            if (node instanceof StateSplit && ((StateSplit)((Object)node)).hasSideEffect()) {
                ResolvedJavaMethod targetMethod;
                CallTargetNode callTarget;
                if (node instanceof Invoke && (callTarget = ((Invoke)((Object)node)).callTarget()) instanceof MethodCallTargetNode && (targetMethod = ((MethodCallTargetNode)callTarget).targetMethod()).isConstructor()) {
                    ResolvedJavaType throwableType = this.replacements.providers.getMetaAccess().lookupJavaType(Throwable.class);
                    return !throwableType.isAssignableFrom(targetMethod.getDeclaringClass());
                }
                return true;
            }
            return false;
        }

        protected StructuredGraph buildInitialGraph(DebugContext debug, BytecodeProvider bytecodeProvider, ResolvedJavaMethod methodToParse, Object[] args, BitSet nonNullParameters, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition, IntrinsicContext.CompilationContext context) {
            StructuredGraph graph = new StructuredGraph.Builder(debug.getOptions(), debug, StructuredGraph.AllowAssumptions.NO).method(methodToParse).trackNodeSourcePosition(trackNodeSourcePosition).callerContext(replaceePosition).setIsSubstitution(true).build();
            graph.disableUnsafeAccessTracking();
            try (DebugContext.Scope s = debug.scope((Object)"buildInitialGraph", graph);){
                MetaAccessProvider metaAccess = this.replacements.getProviders().getMetaAccess();
                GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(this.replacements.graphBuilderPlugins);
                GraphBuilderConfiguration config = GraphBuilderConfiguration.getSnippetDefault(plugins);
                if (args != null) {
                    plugins.prependParameterPlugin(new ConstantBindingParameterPlugin(args, metaAccess, this.replacements.snippetReflection));
                }
                if (nonNullParameters != null && !nonNullParameters.isEmpty()) {
                    plugins.appendParameterPlugin(new NonNullParameterPlugin(nonNullParameters));
                }
                EncodedIntrinsicContext initialIntrinsicContext = null;
                Snippet snippetAnnotation = null;
                if (!Services.IS_IN_NATIVE_IMAGE) {
                    snippetAnnotation = (Snippet)this.method.getAnnotation(Snippet.class);
                }
                if (snippetAnnotation == null) {
                    initialIntrinsicContext = new EncodedIntrinsicContext(this.substitutedMethod, this.method, bytecodeProvider, context, false);
                } else {
                    ResolvedJavaMethod original = this.substitutedMethod != null ? this.substitutedMethod : this.method;
                    initialIntrinsicContext = new EncodedIntrinsicContext(original, this.method, bytecodeProvider, context, snippetAnnotation.allowPartialIntrinsicArgumentMismatch());
                }
                this.createGraphBuilder(this.replacements.providers, config, OptimisticOptimizations.NONE, initialIntrinsicContext).apply(graph);
                CanonicalizerPhase.create().apply(graph, this.replacements.providers);
            }
            catch (Throwable e) {
                throw debug.handle(e);
            }
            return graph;
        }

        protected abstract GraphBuilderPhase.Instance createGraphBuilder(Providers var1, GraphBuilderConfiguration var2, OptimisticOptimizations var3, IntrinsicContext var4);

        static class EncodedIntrinsicContext
        extends IntrinsicContext {
            EncodedIntrinsicContext(ResolvedJavaMethod method, ResolvedJavaMethod intrinsic, BytecodeProvider bytecodeProvider, IntrinsicContext.CompilationContext compilationContext, boolean allowPartialIntrinsicArgumentMismatch) {
                super(method, intrinsic, bytecodeProvider, compilationContext, allowPartialIntrinsicArgumentMismatch);
            }

            @Override
            public boolean isDeferredInvoke(StateSplit stateSplit) {
                if (Services.IS_IN_NATIVE_IMAGE) {
                    throw GraalError.shouldNotReachHere("unused in libgraal");
                }
                if (stateSplit instanceof Invoke) {
                    Invoke invoke = (Invoke)stateSplit;
                    ResolvedJavaMethod method = invoke.callTarget().targetMethod();
                    if (method == null) {
                        return false;
                    }
                    if (method.getAnnotation(Fold.class) != null) {
                        return true;
                    }
                    Node.NodeIntrinsic annotation = (Node.NodeIntrinsic)method.getAnnotation(Node.NodeIntrinsic.class);
                    if (annotation != null && !annotation.hasSideEffect()) {
                        return true;
                    }
                }
                return false;
            }
        }
    }
}

