/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements;

import java.util.Arrays;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetCounter;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.serviceprovider.GraalUnsafeAccess;
import jdk.graal.compiler.word.ObjectAccess;
import org.graalvm.word.LocationIdentity;
import sun.misc.Unsafe;

@NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
public class SnippetCounterNode
extends FixedWithNextNode
implements Lowerable {
    public static final NodeClass<SnippetCounterNode> TYPE = NodeClass.create(SnippetCounterNode.class);
    @Node.Input
    protected ValueNode increment;
    protected final SnippetCounter counter;
    public static final LocationIdentity SNIPPET_COUNTER_LOCATION = NamedLocationIdentity.mutable("SnippetCounter");

    public SnippetCounterNode(SnippetCounter counter, ValueNode increment) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forVoid());
        this.counter = counter;
        this.increment = increment;
    }

    public SnippetCounter getCounter() {
        return this.counter;
    }

    public ValueNode getIncrement() {
        return this.increment;
    }

    @Node.NodeIntrinsic
    public static native void add(@Node.ConstantNodeParameter SnippetCounter var0, int var1);

    public static void increment(@Node.ConstantNodeParameter SnippetCounter counter) {
        SnippetCounterNode.add(counter, 1);
    }

    @Override
    public void lower(LoweringTool tool) {
        if (this.graph().getGuardsStage().areFrameStatesAtDeopts()) {
            SnippetCounterSnippets.Templates templates = tool.getReplacements().getSnippetTemplateCache(SnippetCounterSnippets.Templates.class);
            templates.lower(this, tool);
        }
    }

    public static LocationIdentity[] addSnippetCounters(LocationIdentity[] privateLocations) {
        for (LocationIdentity location : privateLocations) {
            if (!location.equals(SNIPPET_COUNTER_LOCATION)) continue;
            return privateLocations;
        }
        LocationIdentity[] result = Arrays.copyOf(privateLocations, privateLocations.length + 1);
        result[result.length - 1] = SNIPPET_COUNTER_LOCATION;
        return result;
    }

    static class SnippetCounterSnippets
    implements Snippets {
        private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();

        SnippetCounterSnippets() {
        }

        @Fold
        static int countOffset() {
            try {
                return (int)UNSAFE.objectFieldOffset(SnippetCounter.class.getDeclaredField("value"));
            }
            catch (Exception e) {
                throw new GraalError(e);
            }
        }

        @Snippet
        public static void add(@Snippet.ConstantParameter SnippetCounter counter, int increment) {
            long loadedValue = ObjectAccess.readLong((Object)counter, SnippetCounterSnippets.countOffset(), SNIPPET_COUNTER_LOCATION);
            ObjectAccess.writeLong((Object)counter, SnippetCounterSnippets.countOffset(), loadedValue + (long)increment, SNIPPET_COUNTER_LOCATION);
        }

        public static class Templates
        extends SnippetTemplate.AbstractTemplates {
            private final SnippetTemplate.SnippetInfo add;

            Templates(OptionValues options, Providers providers) {
                super(options, providers);
                this.add = this.snippet(providers, SnippetCounterSnippets.class, "add", SNIPPET_COUNTER_LOCATION);
            }

            public void lower(SnippetCounterNode counter, LoweringTool tool) {
                StructuredGraph graph = counter.graph();
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.add, graph.getGuardsStage(), tool.getLoweringStage());
                args.addConst("counter", counter.getCounter());
                args.add("increment", counter.getIncrement());
                this.template(tool, counter, args).instantiate(tool.getMetaAccess(), counter, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }
    }
}

